/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.CaliInfo;
import cn.org.gddsn.jopens.entity.CaliParam;
import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.CatalogC;
import cn.org.gddsn.jopens.entity.CatalogSequence;
import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.MagType;
import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.OffLineInfo;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.jopens.entity.Pick;
import cn.org.gddsn.jopens.entity.ReirInfo;
import cn.org.gddsn.jopens.entity.SeedConfig;
import cn.org.gddsn.jopens.entity.Sourceparameter;
import cn.org.gddsn.jopens.entity.StationAmplitude;
import cn.org.gddsn.jopens.entity.StationMagnitude;
import cn.org.gddsn.jopens.entity.UniEventId;
import cn.org.gddsn.jopens.entity.Waveform;
import cn.org.gddsn.jopens.entity.WaveformEvent;
import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.entity.seed.TimeSpan;
import cn.org.gddsn.jopens.service.SeedCache;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import java.sql.Timestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.jboss.ejb3.entity.HibernateSession;
import org.springframework.orm.jpa.JpaCallback;
import org.springframework.orm.jpa.support.JpaDaoSupport;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class SeedVolumeJPAService
extends JpaDaoSupport
implements SeedVolumeService {
    static Logger logger = Logger.getLogger(SeedVolumeJPAService.class);
    private SeedCache seedCache = null;

    @Override
    public void writeReplication(NetworkInfo ni) {
        EntityManager em = this.getJpaTemplate().getEntityManager();
        if (em instanceof HibernateSession) {
            HibernateSession hs = (HibernateSession)em;
            Session session = hs.getHibernateSession();
            session.replicate((Object)ni, ReplicationMode.LATEST_VERSION);
        }
    }

    @Override
    public Catalog findCatalog(String catalogId) {
        Catalog c = this.getJpaTemplate().find(Catalog.class, (Object)catalogId);
        if (c == null) {
            return null;
        }
        c.getPhases().size();
        c.getMags().size();
        return c;
    }

    @Override
    public List<Catalog> findCatalogByEventId(String eventId) {
        EventInfo ei = this.getJpaTemplate().find(EventInfo.class, (Object)eventId);
        for (Catalog c : ei.getCatalogs()) {
            c.getPhases().size();
            c.getMags().size();
        }
        return ei.getCatalogs();
    }

    private Dataless cascadeDataless(long id) {
        Dataless dl = this.getJpaTemplate().find(Dataless.class, (Object)id);
        if (dl == null) {
            return dl;
        }
        if (dl.getSaveTime() == null) {
            dl.setSaveTime(new Timestamp(new Date().getTime()));
            dl = this.getJpaTemplate().merge(dl);
            logger.info("add Dataless savetime");
        }
        Dataless cacheDl = null;
        if (this.seedCache != null && (cacheDl = this.seedCache.getDataless(dl.getId())) != null && cacheDl.getId() == dl.getId() && cacheDl.getSaveTime().getTime() == dl.getSaveTime().getTime()) {
            logger.info("use server side cache Dataless: " + dl.getId());
            return cacheDl;
        }
        if (dl.getVolumeIndex().getBlockette011() != null) {
            dl.getVolumeIndex().getBlockette011().getPairs().size();
        }
        if (dl.getVolumeIndex().getBlockette012() != null) {
            dl.getVolumeIndex().getBlockette012().getSpans().size();
        }
        for (TimeSpan ts : dl.getTimeSpan()) {
            if (ts.getBlockette071() != null) {
                ts.getBlockette071().getMagnitudes().size();
            }
            ts.getBlockette072().size();
            ts.getBlockette074().size();
        }
        if (this.seedCache != null) {
            this.seedCache.updateDataless(dl);
        }
        return dl;
    }

    private SeedConfig cascadeSeedConfig(long id) {
        SeedConfig sc = this.getJpaTemplate().find(SeedConfig.class, (Object)id);
        if (sc == null) {
            return sc;
        }
        if (sc.getSaveTime() == null) {
            sc.setSaveTime(new Timestamp(new Date().getTime()));
            sc = this.getJpaTemplate().merge(sc);
            logger.info("add SeedConfig savetime");
        }
        SeedConfig cacheSC = null;
        if (this.seedCache != null && (cacheSC = this.seedCache.getSeedConfig(sc.getId())) != null && cacheSC.getId() == sc.getId() && cacheSC.getSaveTime().getTime() == sc.getSaveTime().getTime()) {
            logger.info("use server side cache SeedConfig: " + sc.getId());
            return cacheSC;
        }
        Abbreviation abbr = sc.getAbbreviation();
        abbr.getBlockette030().size();
        abbr.getBlockette031().size();
        abbr.getBlockette032().size();
        abbr.getBlockette033().size();
        abbr.getBlockette034().size();
        for (Station sta : sc.getStation()) {
            sta.getBlockette051().size();
            for (Channel chn : sta.getChannel()) {
                chn.getResponse().size();
                for (Response rsp : chn.getResponse()) {
                    if (rsp.getBlockette058() == null) continue;
                    rsp.getBlockette058().getHistoryValues().size();
                }
            }
        }
        if (this.seedCache != null) {
            this.seedCache.updateSeedConfig(sc);
        }
        return sc;
    }

    @Override
    public Dataless findDatalessByEventId(final String eventId, final boolean dlCascade, final boolean scCascade) {
        return (Dataless)this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                EventInfo ei = SeedVolumeJPAService.this.getJpaTemplate().find(EventInfo.class, (Object)eventId);
                if (dlCascade) {
                    ei.setDataless(SeedVolumeJPAService.this.cascadeDataless(ei.getDataless().getId()));
                }
                if (scCascade) {
                    ei.getDataless().setSeedConfig(SeedVolumeJPAService.this.cascadeSeedConfig(ei.getDataless().getSeedConfig().getId()));
                }
                if (ei.getStartTime() != null && ei.getEndTime() != null) {
                    ei.getDataless().getVolumeIndex().getBlockette010().setStartTime(new Timestamp(ei.getStartTime().getTime()));
                    ei.getDataless().getVolumeIndex().getBlockette010().setEndTime(new Timestamp(ei.getEndTime().getTime()));
                }
                return ei.getDataless();
            }
        }, true);
    }

    @Override
    public Dataless findDatalessByEventId(String eventId) {
        return this.findDatalessByEventId(eventId, true, true);
    }

    @Override
    public long findDatalessIdByEventId(final String eventId) {
        return (Long)this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                EventInfo ei = SeedVolumeJPAService.this.getJpaTemplate().find(EventInfo.class, (Object)eventId);
                if (ei.getStartTime() != null && ei.getEndTime() != null) {
                    ei.getDataless().getVolumeIndex().getBlockette010().setStartTime(new Timestamp(ei.getStartTime().getTime()));
                    ei.getDataless().getVolumeIndex().getBlockette010().setEndTime(new Timestamp(ei.getEndTime().getTime()));
                }
                return ei.getDataless().getId();
            }
        }, true);
    }

    @Override
    public Dataless findDefaultDataless() {
        NetworkInfo ni = this.findNetworkInfoSelf();
        if (ni == null) {
            return null;
        }
        return this.findDatalessById(ni.getUniCode());
    }

    @Override
    public Dataless findDatalessById(long id) {
        return this.findDatalessById(id, true, true);
    }

    @Override
    public Dataless findDatalessById(final long id, final boolean dlCascade, final boolean scCascade) {
        return (Dataless)this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Dataless dl = SeedVolumeJPAService.this.getJpaTemplate().find(Dataless.class, (Object)id);
                if (dl != null) {
                    if (dlCascade) {
                        dl = SeedVolumeJPAService.this.cascadeDataless(dl.getId());
                    }
                    if (scCascade) {
                        dl.setSeedConfig(SeedVolumeJPAService.this.cascadeSeedConfig(dl.getSeedConfig().getId()));
                    }
                }
                return dl;
            }
        }, true);
    }

    @Override
    public EventInfo getTimeInfo(final String eventId) {
        return (EventInfo)this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                EventInfo ei = SeedVolumeJPAService.this.getJpaTemplate().find(EventInfo.class, (Object)eventId);
                if (ei.getStartTime() != null && ei.getEndTime() != null) {
                    ei.getDataless().getVolumeIndex().getBlockette010().setStartTime(new Timestamp(ei.getStartTime().getTime()));
                    ei.getDataless().getVolumeIndex().getBlockette010().setEndTime(new Timestamp(ei.getEndTime().getTime()));
                } else {
                    ei.setStartTime(ei.getDataless().getVolumeIndex().getBlockette010().getStartTime());
                    ei.setEndTime(ei.getDataless().getVolumeIndex().getBlockette010().getEndTime());
                }
                return ei;
            }
        }, true);
    }

    @Override
    public NetworkInfo findNetworkInfoSelf() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("self", "Y");
        List niList = this.getJpaTemplate().findByNamedParams("select e from NetworkInfo e where e.self= :self", map);
        if (niList.size() == 0) {
            return null;
        }
        return (NetworkInfo)niList.get(0);
    }

    @Override
    public NetworkInfo findNetworkInfo(String netCode) {
        return this.getJpaTemplate().find(NetworkInfo.class, (Object)netCode);
    }

    @Override
    public void writeNetworkInfo(NetworkInfo ni) {
        this.getJpaTemplate().merge(ni);
    }

    @Override
    public List<Waveform> getWaveform(String eventId) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("eventId", eventId);
        return this.getJpaTemplate().findByNamedParams("select e from WaveformEvent e where e.eventInfo.eventId= :eventId order by e.channelLocator.netCode, e.channelLocator.stationCode, e.channelLocator.locId, e.channelLocator.chanCode, e.startTime, e.startTimeFrac", map);
    }

    @Override
    public List<Waveform> getWaveform(String eventId, ChannelLocator cl) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("eventId", eventId);
        map.put("net", cl.getNetCode());
        map.put("sta", cl.getStationCode());
        map.put("locId", cl.getLocId());
        map.put("chan", cl.getChanCode());
        return this.getJpaTemplate().findByNamedParams("select e from WaveformEvent e where e.eventInfo.eventId= :eventId and e.channelLocator.netCode= :net and e.channelLocator.stationCode= :sta and e.channelLocator.locId= :locId and e.channelLocator.chanCode= :chan order by e.startTime, e.startTimeFrac", map);
    }

    @Override
    public int[] getWaveformChunkSize(String eventId, ChannelLocator cl) {
        long now = System.currentTimeMillis();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("eventId", eventId);
        map.put("net", cl.getNetCode());
        map.put("sta", cl.getStationCode());
        map.put("locId", cl.getLocId());
        map.put("chan", cl.getChanCode());
        List list = this.getJpaTemplate().findByNamedParams("select e.recLenth from WaveformEvent e where e.eventInfo.eventId= :eventId e.channelLocator.netCode= :net and e.channelLocator.stationCode= :sta and e.channelLocator.locId= :locId and e.channelLocator.chanCode= :chan ", map);
        if (list.size() == 0) {
            return null;
        }
        Object[] obj = (Object[])list.get(0);
        int[] par = new int[]{Integer.parseInt(obj[0].toString()), list.size()};
        return par;
    }

    @Override
    public int[] getWaveformChunkSize(Date startTime, Date endTime, ChannelLocator cl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("net", cl.getNetCode());
        map.put("sta", cl.getStationCode());
        map.put("locId", cl.getLocId());
        map.put("chan", cl.getChanCode());
        List list = this.getJpaTemplate().findByNamedParams("select e.recLenth from WaveformCon e where e.startTime >= :startTime and e.startTime <= :endTime e.channelLocator.netCode= :net and e.channelLocator.stationCode= :sta and e.channelLocator.locId= :locId and e.channelLocator.chanCode= :chan ", map);
        if (list.size() == 0) {
            return null;
        }
        Object[] obj = (Object[])list.get(0);
        int[] par = new int[]{Integer.parseInt(obj[0].toString()), list.size()};
        return par;
    }

    @Override
    public List<Waveform> getWaveform(Date startTime, Date endTime, String[] nets, String[] stas) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(startTime);
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        StringBuffer sb = new StringBuffer();
        sb.append(" AND e.channelLocator.netCode in (");
        int i = 0;
        while (i < nets.length) {
            if (i == nets.length - 1) {
                sb.append("'" + nets[i] + "') ");
            } else {
                sb.append("'" + nets[i] + "', ");
            }
            ++i;
        }
        sb.append(" AND e.channelLocator.stationCode in (");
        i = 0;
        while (i < stas.length) {
            if (i == stas.length - 1) {
                sb.append("'" + stas[i] + "') ");
            } else {
                sb.append("'" + stas[i] + "', ");
            }
            ++i;
        }
        return this.getJpaTemplate().findByNamedParams("select e from WaveformCon e where e.startTime >= :startTime and e.startTime <= :endTime " + sb.substring(0) + " order by e.channelLocator.netCode, e.channelLocator.stationCode, " + "e.channelLocator.locId, e.channelLocator.chanCode, e.startTime, e.startTimeFrac", map);
    }

    @Override
    public List<Waveform> getWaveform(Date startTime, Date endTime) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        return this.getJpaTemplate().findByNamedParams("select e from WaveformCon e where e.startTime >= :startTime and e.startTime <= :endTime order by e.channelLocator.netCode, e.channelLocator.stationCode, e.channelLocator.locId, e.channelLocator.chanCode, e.startTime, e.startTimeFrac", map);
    }

    @Override
    public List<Waveform> getWaveform(Date startTime, Date endTime, ChannelLocator cl) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startTime", startTime);
        map.put("endTime", endTime);
        map.put("net", cl.getNetCode());
        map.put("sta", cl.getStationCode());
        map.put("locId", cl.getLocId());
        map.put("chan", cl.getChanCode());
        return this.getJpaTemplate().findByNamedParams("select e from WaveformCon e where e.startTime >= :startTime and e.startTime <= :endTime and e.channelLocator.netCode= :net and e.channelLocator.stationCode= :sta and e.channelLocator.locId= :locId and e.channelLocator.chanCode= :chan order by e.startTime, e.startTimeFrac", map);
    }

    @Override
    public EventInfo findEventInfo(String eventId) {
        EventInfo info = this.getJpaTemplate().find(EventInfo.class, (Object)eventId);
        if (info != null) {
            info.getCatalogs().size();
            for (Catalog c : info.getCatalogs()) {
                c.getPhases().size();
                c.getMags().size();
            }
        }
        return info;
    }

    @Override
    public void updateRtsEventInfo(String eventId, Date startTime, Date endTime) {
        boolean exist;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("eventId", eventId);
        List list = this.getJpaTemplate().find("select e from EventInfo e where e.eventId= :eventId", map);
        boolean bl = exist = list.size() != 0;
        if (!exist) {
            EventInfo info = new EventInfo();
            info.setEventId(eventId);
            info.setStartTime(startTime);
            info.setEndTime(endTime);
            Dataless dl = this.findDefaultDataless();
            info.setDataless(dl);
            this.getJpaTemplate().merge(info);
        } else {
            EventInfo info = (EventInfo)list.get(0);
            info.setStartTime(startTime);
            info.setEndTime(endTime);
            this.getJpaTemplate().merge(info);
        }
    }

    @Override
    public void deleteRtsEventInfo(int timeoutHours) {
        Date deadTime = new Date(new Date().getTime() - (long)(timeoutHours * 3600) * 1000L);
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("deadTime", deadTime);
        List list = this.getJpaTemplate().findByNamedParams("select e from EventInfo e where e.startTime <:deadTime", map);
        for (EventInfo info : list) {
            this.deleteEventInfo(info.getEventId(), true);
        }
    }

    @Override
    public void deleteEventInfo(final String eventId, boolean bRts) {
        this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                EventInfo info = em.find(EventInfo.class, eventId);
                if (info == null) {
                    return null;
                }
                UniEventId uid = info.getUniEventId();
                if (uid != null) {
                    uid.getEventInfos().remove(info);
                    em.merge(uid);
                    if (uid.getEventInfos().size() == 0) {
                        em.remove(uid);
                    }
                }
                em.createQuery("delete from WaveformEvent w where w.eventInfo.eventId= :eventId").setParameter("eventId", (Object)info.getEventId()).executeUpdate();
                Iterator<Catalog> it = info.getCatalogs().iterator();
                while (it.hasNext()) {
                    Catalog c = it.next();
                    SeedVolumeJPAService.this.deleteCatalogForeignKey(em, c.getId());
                    it.remove();
                    em.remove(c);
                }
                em.remove(info);
                NetworkInfo ni = SeedVolumeJPAService.this.findNetworkInfoSelf();
                if (ni == null) {
                    return null;
                }
                Dataless ddl = em.find(Dataless.class, ni.getUniCode());
                Dataless dl = info.getDataless();
                if (dl != null && ddl != null && dl.getId() != ddl.getId()) {
                    em.remove(dl);
                }
                return null;
            }
        }, true);
    }

    @Override
    public void updateEventInfo(final EventInfo info) {
        this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                SeedVolumeJPAService.this.getJpaTemplate().merge(info);
                Catalog cata = null;
                for (Catalog c1 : info.getCatalogs()) {
                    if (!(c1 instanceof CatalogC)) continue;
                    cata = c1;
                    break;
                }
                SeedVolumeJPAService.this.updateCatalogSequence(em, cata);
                return null;
            }
        }, true);
    }

    @Override
    public EventInfo readEventInfo(String eventId) {
        long ct = System.currentTimeMillis();
        EventInfo ei = this.getJpaTemplate().find(EventInfo.class, (Object)eventId);
        logger.info("ei time(sec): " + (System.currentTimeMillis() - ct) / 1000L);
        ct = System.currentTimeMillis();
        ei.setDataless(this.cascadeDataless(ei.getDataless().getId()));
        ei.getDataless().setSeedConfig(this.cascadeSeedConfig(ei.getDataless().getSeedConfig().getId()));
        logger.info("ei time(sec): " + (System.currentTimeMillis() - ct) / 1000L);
        ct = System.currentTimeMillis();
        ei.getWaveformEvents().size();
        logger.info("waveform time(sec): " + (System.currentTimeMillis() - ct) / 1000L);
        return ei;
    }

    @Override
    public void deleteDataless(long id) {
        Dataless dl = this.getJpaTemplate().find(Dataless.class, (Object)id);
        if (dl != null) {
            this.getJpaTemplate().remove(dl);
            this.getJpaTemplate().remove(dl.getSeedConfig());
        }
    }

    @Override
    public long writeDataless(Dataless dataless) {
        return this.getJpaTemplate().merge(dataless).getId();
    }

    @Override
    public void writeEventInfo(final EventInfo eventInfo) {
        this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                long now_ms = System.currentTimeMillis();
                NetworkInfo ni = SeedVolumeJPAService.this.findNetworkInfoSelf();
                if (ni == null) {
                    logger.warn("Could default NetworkInfo");
                    return null;
                }
                Dataless dl = em.find(Dataless.class, ni.getUniCode());
                SeedConfig sc = null;
                if (eventInfo.getDataless() != null) {
                    if (dl != null) {
                        sc = dl.getSeedConfig();
                        eventInfo.getDataless().setSeedConfig(sc);
                    } else {
                        sc = eventInfo.getDataless().getSeedConfig();
                    }
                }
                logger.info("Prepare time: " + (System.currentTimeMillis() - now_ms));
                now_ms = System.currentTimeMillis();
                Set<WaveformEvent> wfeSet = eventInfo.getWaveformEvents();
                eventInfo.setWaveformEvents(null);
                em.merge(eventInfo);
                logger.info("persist infoInfo time: " + (System.currentTimeMillis() - now_ms));
                now_ms = System.currentTimeMillis();
                int c = 0;
                for (WaveformEvent wfe : wfeSet) {
                    em.persist(wfe);
                    if (++c % 50 != 0) continue;
                    em.flush();
                    em.clear();
                }
                logger.info("persist waveform time: " + (System.currentTimeMillis() - now_ms));
                em.flush();
                Catalog cata = null;
                for (Catalog c1 : eventInfo.getCatalogs()) {
                    if (!(c1 instanceof CatalogC)) continue;
                    cata = c1;
                    break;
                }
                SeedVolumeJPAService.this.updateCatalogSequence(em, cata);
                return null;
            }
        }, true);
    }

    public void writeEventInfo0(EventInfo eventInfo) {
        long now_ms = System.currentTimeMillis();
        SeedConfig sc = this.getJpaTemplate().find(SeedConfig.class, (Object)1L);
        if (sc != null) {
            eventInfo.getDataless().setSeedConfig(sc);
        } else {
            sc = eventInfo.getDataless().getSeedConfig();
        }
        HashMap<String, Channel> maps = new HashMap<String, Channel>(512);
        for (Station sta : sc.getStation()) {
            for (Channel chn : sta.getChannel()) {
                String cl = String.valueOf(sta.getBlockette050().getNetworkCode()) + "/" + sta.getBlockette050().getStation();
                cl = String.valueOf(cl) + "/" + chn.getBlockette052().getLocation() + "/" + chn.getBlockette052().getChannel();
                maps.put(cl, chn);
            }
        }
        logger.info("Prepare time: " + (System.currentTimeMillis() - now_ms));
        now_ms = System.currentTimeMillis();
        Set<WaveformEvent> wfeSet = eventInfo.getWaveformEvents();
        eventInfo.setWaveformEvents(null);
        this.getJpaTemplate().persist(eventInfo);
        logger.info("persist infoInfo time: " + (System.currentTimeMillis() - now_ms));
        now_ms = System.currentTimeMillis();
        int c = 0;
        for (WaveformEvent wfe : wfeSet) {
            this.getJpaTemplate().persist(wfe);
            if (++c % 1000 != 0) continue;
            this.getJpaTemplate().flush();
        }
        logger.info("persist waveform time: " + (System.currentTimeMillis() - now_ms));
        now_ms = System.currentTimeMillis();
        eventInfo.setWaveformEvents(wfeSet);
        this.getJpaTemplate().merge(eventInfo);
        this.getJpaTemplate().flush();
        logger.info("merge eventinfo and waveform time: " + (System.currentTimeMillis() - now_ms));
    }

    @Override
    public ReirInfo writeReirInfo(ReirInfo info) {
        return this.getJpaTemplate().merge(info);
    }

    @Override
    public ReirInfo readReirInfo(long id) {
        ReirInfo info = this.getJpaTemplate().find(ReirInfo.class, (Object)id);
        if (info != null && info.getCatalog() != null) {
            info.getCatalog().getPhases().size();
            info.getCatalog().getMags().size();
        }
        return info;
    }

    @Override
    public List<ReirInfo> findReirInfo() {
        return this.getJpaTemplate().find("select e from ReirInfo e ORDER BY e.recvTime DESC");
    }

    @Override
    public MagType findMagTypeById(String id) {
        return this.getJpaTemplate().find(MagType.class, (Object)id);
    }

    @Override
    public void addMagType(MagType magType) {
        this.getJpaTemplate().persist(magType);
    }

    @Override
    public void removeMagType(String id) {
        this.getJpaTemplate().remove(this.findMagTypeById(id));
    }

    @Override
    public void updateMagType(MagType magType) {
        this.getJpaTemplate().merge(magType);
    }

    @Override
    public String findNewestEventId() {
        List list = this.getJpaTemplate().find("select e from EventInfo e order by e.startTime desc limit 1");
        if (list.size() == 0) {
            return null;
        }
        EventInfo info = (EventInfo)list.get(0);
        return info.getEventId();
    }

    @Override
    public List<Catalog> findCatalogR(EventInfo localInfo, float maxOriginDiff, float maxLocDiff, float maxMagDiff) {
        Date otime = localInfo.getCatalogs().get(0).getOriginTime();
        Date minTime = new Date(otime.getTime() - (long)((int)maxOriginDiff) * 1000L);
        Date maxTime = new Date(otime.getTime() + (long)((int)maxOriginDiff) * 1000L);
        float lat = localInfo.getCatalogs().get(0).getLat();
        float minLat = lat - maxLocDiff;
        float maxLat = lat + maxLocDiff;
        float lon = localInfo.getCatalogs().get(0).getLon();
        float minLon = lon - maxLocDiff;
        float maxLon = lon + maxLocDiff;
        float m = localInfo.getCatalogs().get(0).getM();
        float minM = m - maxMagDiff;
        float maxM = m + maxMagDiff;
        HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
        map.put("minTime", minTime);
        map.put("maxTime", maxTime);
        map.put("minLat", Float.valueOf(minLat));
        map.put("maxLat", Float.valueOf(maxLat));
        map.put("minLon", Float.valueOf(minLon));
        map.put("maxLon", Float.valueOf(maxLon));
        map.put("minM", Float.valueOf(minM));
        map.put("maxM", Float.valueOf(maxM));
        List r = this.getJpaTemplate().findByNamedParams("select e from CatalogR e where e.originTime > :minTime and e.originTime < :maxTime and e.lat > :minLat and e.lat < :maxLat and e.lon > :minLon and e.lon < :maxLon and e.m > :minM and e.m < :maxM and e.eventInfo=null order by e.netCode, e.originTime", map);
        r.addAll(localInfo.getCatalogs());
        return r;
    }

    @Override
    public List<Catalog> findCatalog(Catalog c, float maxOriginDiff, float maxLocDiff, float maxMagDiff, boolean cascade) {
        Date otime = c.getOriginTime();
        Date minTime = new Date(otime.getTime() - (long)((int)maxOriginDiff) * 1000L);
        Date maxTime = new Date(otime.getTime() + (long)((int)maxOriginDiff) * 1000L);
        float lat = c.getLat();
        float minLat = lat - maxLocDiff;
        float maxLat = lat + maxLocDiff;
        float lon = c.getLon();
        float minLon = lon - maxLocDiff;
        float maxLon = lon + maxLocDiff;
        float m = c.getM();
        float minM = m - maxMagDiff;
        float maxM = m + maxMagDiff;
        HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
        map.put("minTime", minTime);
        map.put("maxTime", maxTime);
        map.put("minLat", Float.valueOf(minLat));
        map.put("maxLat", Float.valueOf(maxLat));
        map.put("minLon", Float.valueOf(minLon));
        map.put("maxLon", Float.valueOf(maxLon));
        map.put("minM", Float.valueOf(minM));
        map.put("maxM", Float.valueOf(maxM));
        List cataList = this.getJpaTemplate().findByNamedParams("select e from Catalog e where e.originTime > :minTime and e.originTime < :maxTime and e.lat > :minLat and e.lat < :maxLat and e.lon > :minLon and e.lon < :maxLon and e.m > :minM and e.m < :maxM order by e.netCode, e.originTime", map);
        for (Catalog cat : cataList) {
            cat.getPhases().size();
            cat.getMags().size();
        }
        return cataList;
    }

    @Override
    public List<Catalog> findCatalog(EventInfo localInfo, float maxOriginDiff, float maxLocDiff, float maxMagDiff) {
        Date otime = localInfo.getCatalogs().get(0).getOriginTime();
        Date minTime = new Date(otime.getTime() - (long)((int)maxOriginDiff) * 1000L);
        Date maxTime = new Date(otime.getTime() + (long)((int)maxOriginDiff) * 1000L);
        float lat = localInfo.getCatalogs().get(0).getLat();
        float minLat = lat - maxLocDiff;
        float maxLat = lat + maxLocDiff;
        float lon = localInfo.getCatalogs().get(0).getLon();
        float minLon = lon - maxLocDiff;
        float maxLon = lon + maxLocDiff;
        float m = localInfo.getCatalogs().get(0).getM();
        float minM = m - maxMagDiff;
        float maxM = m + maxMagDiff;
        HashMap<String, Comparable<Date>> map = new HashMap<String, Comparable<Date>>();
        map.put("minTime", minTime);
        map.put("maxTime", maxTime);
        map.put("minLat", Float.valueOf(minLat));
        map.put("maxLat", Float.valueOf(maxLat));
        map.put("minLon", Float.valueOf(minLon));
        map.put("maxLon", Float.valueOf(maxLon));
        map.put("minM", Float.valueOf(minM));
        map.put("maxM", Float.valueOf(maxM));
        return this.getJpaTemplate().findByNamedParams("select e from Catalog e where e.originTime > :minTime and e.originTime < :maxTime and e.lat > :minLat and e.lat < :maxLat and e.lon > :minLon and e.lon < :maxLon and e.m > :minM and e.m < :maxM order by e.eventInfo.uniEventId.nationEventId, e.netCode, e.originTime", map);
    }

    @Override
    public void writeUniEventId(UniEventId uniEvent) {
        this.getJpaTemplate().persist(uniEvent);
        this.getJpaTemplate().flush();
    }

    @Override
    public void updateUniEventId(String uniEventId, EventInfo eventInfo) {
        UniEventId uniEvent = this.getJpaTemplate().find(UniEventId.class, (Object)uniEventId);
        if (uniEvent == null) {
            return;
        }
        if (eventInfo.getCatalogs().isEmpty()) {
            return;
        }
        Catalog myCata = eventInfo.getCatalogs().get(0);
        Iterator<EventInfo> it = uniEvent.getEventInfos().iterator();
        block0: while (it.hasNext()) {
            EventInfo ei = it.next();
            for (Catalog c : ei.getCatalogs()) {
                if (!c.getNetCode().equals(myCata.getNetCode())) continue;
                it.remove();
                ei.setUniEventId(null);
                this.getJpaTemplate().remove(ei);
                this.getJpaTemplate().flush();
                continue block0;
            }
        }
        uniEvent.getEventInfos().add(eventInfo);
        eventInfo.setUniEventId(uniEvent);
        this.getJpaTemplate().merge(uniEvent);
        this.getJpaTemplate().flush();
    }

    @Override
    public SeedConfig findSeedConfig(long id, boolean scCascade) {
        SeedConfig sc = this.getJpaTemplate().find(SeedConfig.class, (Object)id);
        if (sc == null) {
            return null;
        }
        if (scCascade) {
            sc = this.cascadeSeedConfig(sc.getId());
        }
        return sc;
    }

    @Override
    public SeedConfig findSeedConfig(long id) {
        return this.findSeedConfig(id, true);
    }

    @Override
    public void deleteUniEventId(String eventId) {
        UniEventId ue = this.getJpaTemplate().find(UniEventId.class, (Object)eventId);
        if (ue != null) {
            this.getJpaTemplate().remove(ue);
        }
    }

    @Override
    public void deleteCatalog(final String eventInfoId, final String catalogId) {
        if (eventInfoId == null || catalogId == null) {
            return;
        }
        this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                EventInfo ei = em.find(EventInfo.class, eventInfoId);
                Catalog c = em.find(Catalog.class, catalogId);
                if (ei == null || c == null) {
                    logger.info(ei);
                    logger.info(c);
                    return null;
                }
                logger.info(catalogId);
                SeedVolumeJPAService.this.deleteCatalogForeignKey(em, catalogId);
                ei.getCatalogs().remove(c);
                c.setEventInfo(null);
                em.remove(c);
                return null;
            }
        }, true);
    }

    private void deleteCatalogForeignKey(EntityManager em, String catalogId) {
        if (catalogId == null) {
            return;
        }
        em.createQuery("delete from Sourceparameter e where e.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
        em.createQuery("delete from ReirInfo e where e.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
        em.createQuery("delete from Momenttensor e where e.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
        em.createQuery("delete from RegFocmec e where e.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
        em.createQuery("delete from Sourceprocess e where e.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
    }

    @Override
    public void replaceCatalog(final String eventInfoId, final String origCatalogId, final Catalog newCatalog) {
        this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                EventInfo ei = em.find(EventInfo.class, eventInfoId);
                Catalog origCatalog = em.find(Catalog.class, origCatalogId);
                if (ei == null || origCatalog == null) {
                    logger.info(ei);
                    logger.info(origCatalog);
                    logger.info("return should not be null, eventInfoId=" + eventInfoId + ", origCatalogId=" + origCatalogId);
                    return null;
                }
                logger.info(origCatalogId);
                origCatalog.updateCatalog(newCatalog);
                for (Mag m : origCatalog.getMags()) {
                    em.remove(m);
                }
                for (Phase p : origCatalog.getPhases()) {
                    em.remove(p);
                }
                origCatalog.setMags(newCatalog.getMags());
                origCatalog.setPhases(newCatalog.getPhases());
                for (Mag m : origCatalog.getMags()) {
                    m.setCatalog(origCatalog);
                }
                for (Phase p : origCatalog.getPhases()) {
                    p.setCatalog(origCatalog);
                }
                em.merge(origCatalog);
                SeedVolumeJPAService.this.updateCatalogSequence(em, newCatalog);
                return null;
            }
        }, true);
    }

    @Override
    public void writeCaliInfo(CaliInfo ci) {
        this.getJpaTemplate().persist(ci);
    }

    @Override
    public CaliInfo findCaliInfo(long id) {
        return this.getJpaTemplate().find(CaliInfo.class, (Object)id);
    }

    @Override
    public void writeCaliParam(CaliParam cp) {
        this.getJpaTemplate().persist(cp);
    }

    @Override
    public void findClear() {
        this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                em.flush();
                em.clear();
                return null;
            }
        }, true);
    }

    @Override
    public List<ReirInfo> findReirInfo(String sort) {
        return null;
    }

    @Override
    public void writeSourceParameter(final String catalogId, final Sourceparameter sp) {
        this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Catalog c = em.find(Catalog.class, catalogId);
                if (c == null) {
                    return null;
                }
                em.createQuery("delete from Sourceparameter s where s.catalog.id= :catalogId").setParameter("catalogId", (Object)catalogId).executeUpdate();
                sp.setCatalog(c);
                sp.setEventInfo(c.getEventInfo());
                em.merge(sp);
                return null;
            }
        }, true);
    }

    @Override
    public OffLineInfo getOffLineInfo(String eventInfoId) {
        EventInfo ei = this.getJpaTemplate().find(EventInfo.class, (Object)eventInfoId);
        if (ei == null) {
            return null;
        }
        return ei.getOffLineInfo();
    }

    public void setSeedCache(SeedCache seedCache) {
        this.seedCache = seedCache;
    }

    @Override
    public List<EventInfo> findEventInfoList(Date begDate, Date endDate) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        map.put("beg", begDate);
        map.put("end", endDate);
        return this.getJpaTemplate().findByNamedParams("select e from EventInfo e where e.startTime >= :beg  and e.startTime < :end order by e.startTime", map);
    }

    @Override
    public Mag findMag(long id) {
        return this.getJpaTemplate().find(Mag.class, (Object)id);
    }

    @Override
    public StationAmplitude findStationAmplitudeById(String ampId) {
        return this.getJpaTemplate().find(StationAmplitude.class, (Object)ampId);
    }

    @Override
    public StationMagnitude findStationMagnitudeById(String magId) {
        return this.getJpaTemplate().find(StationMagnitude.class, (Object)magId);
    }

    @Override
    public Pick findPickById(String pickId) {
        return this.getJpaTemplate().find(Pick.class, (Object)pickId);
    }

    @Override
    public void updateCatalog(final String cataId, final List<StationMagnitude> sms) {
        this.getJpaTemplate().execute(new JpaCallback(){

            public Object doInJpa(EntityManager em) throws PersistenceException {
                Catalog c = em.find(Catalog.class, cataId);
                if (c == null) {
                    return null;
                }
                for (StationMagnitude sm : sms) {
                    StationMagnitude _sm = c.findStationMagnitude(sm.getId());
                    if (_sm != null) {
                        _sm.setCatalog(null);
                        c.getStationMagnitudes().remove(_sm);
                        em.remove(_sm);
                    }
                    sm.setCatalog(c);
                    c.getStationMagnitudes().add(sm);
                }
                em.merge(c);
                return c;
            }
        }, true);
    }

    @Override
    public List<String> findCatalogSequenceName() {
        HashMap map = new HashMap();
        List css = this.getJpaTemplate().findByNamedParams("select e from CatalogSequence e order by e.sequenName", map);
        LinkedList<String> sns = new LinkedList<String>();
        for (CatalogSequence cs : css) {
            sns.add(cs.getSequenName());
        }
        return sns;
    }

    private void updateCatalogSequence(EntityManager em, Catalog cata) {
        CatalogSequence cs;
        String seqName;
        if (cata != null && (seqName = cata.getSequenName()) != null && (cs = em.find(CatalogSequence.class, seqName)) == null) {
            cs = new CatalogSequence();
            cs.setSequenName(seqName);
            cs.setCatalog(em.find(Catalog.class, cata.getId()));
            em.persist(cs);
        }
    }
}

