/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.jopens.service.SpringUtil;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import org.jboss.annotation.ejb.ResourceAdapter;
import org.jboss.logging.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="cronTrigger", propertyValue="0 0 3 * * ?")})
@ResourceAdapter(value="quartz-ra.rar")
public class SeedVolumeEventExporter
implements Job {
    static final Logger logger = Logger.getLogger(SeedVolumeEventExporter.class);
    @Resource(name="SeedVolumeExporter/EventWaveformDir", type=String.class)
    private String eventWaveformDir = "/usr/local/jboss4/server/default/deploy/JOPENSEAR.ear/JOPENSWeb.war/seed/evt";
    @Resource(name="ejb/BeanFactoryPath", type=String.class)
    private String beanFactoryPath;
    private SeedVolumeService exportService;

    private void export(Date fireTime) {
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        this.export(jobExecutionContext.getFireTime());
    }

    @PostConstruct
    public void postConstruct() {
        logger.info((Object)("beanFactoryPath = " + this.beanFactoryPath));
        logger.info((Object)("Exporter/EventWaveformDir = " + this.eventWaveformDir));
        try {
            SpringUtil util = new SpringUtil();
            util.loadBeanFactory();
            this.exportService = (SeedVolumeService)util.getBeanFactory().getBean("seedVolumeService");
        }
        catch (Exception ex) {
            logger.warn((Object)"Init seedVolumeService export-service.xml failt!");
            logger.warn((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    public SeedVolumeService getExportService() {
        return this.exportService;
    }

    public void setExportService(SeedVolumeService exportService) {
        this.exportService = exportService;
    }
}

