/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.Waveform;
import cn.org.gddsn.jopens.entity.seed.Blockette010;
import cn.org.gddsn.jopens.entity.seed.Blockette011;
import cn.org.gddsn.jopens.entity.seed.Blockette012;
import cn.org.gddsn.jopens.entity.seed.Blockette030;
import cn.org.gddsn.jopens.entity.seed.Blockette031;
import cn.org.gddsn.jopens.entity.seed.Blockette032;
import cn.org.gddsn.jopens.entity.seed.Blockette033;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import cn.org.gddsn.jopens.entity.seed.Blockette051;
import cn.org.gddsn.jopens.entity.seed.Blockette052;
import cn.org.gddsn.jopens.entity.seed.Blockette070;
import cn.org.gddsn.jopens.entity.seed.Blockette074;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.entity.seed.Pair;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Span;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.entity.seed.TimeSpan;
import cn.org.gddsn.jopens.service.EventExportPlugin;
import cn.org.gddsn.jopens.service.SeedExportPlugin;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import edu.iris.timeutils.TimeStamp;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.regexp.RE;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;

public class SeedExporterUtil {
    static Logger logger = Logger.getLogger(SeedExporterUtil.class);
    private File file;
    private Date startTime;
    private Date endTime;
    private String eventId;
    private String[] net;
    private String[] station;
    private String netRegexp;
    private String stationRegexp;
    private int seqV = 1;
    private int seqA = 1;
    private int seqS = 1;
    private int seqT = 1;
    private int sizeT = 1;
    private int waveformRecordLength = 512;
    private Dataless dl;
    private SeedExportPlugin seedExportPlugin;

    public void export() throws IOException {
        boolean found;
        long now = System.currentTimeMillis();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.file), 4096);
        this.dl = this.seedExportPlugin.getDataless(this.eventId, this.startTime, this.endTime);
        if (this.eventId != null) {
            this.startTime = this.dl.getVolumeIndex().getBlockette010().getStartTime();
            this.endTime = this.dl.getVolumeIndex().getBlockette010().getEndTime();
        }
        logger.info("Load station info elapse time: " + (System.currentTimeMillis() - now));
        if (this.netRegexp != null || this.stationRegexp != null) {
            Vector<String> netVec = new Vector<String>();
            Vector<String> stationVec = new Vector<String>();
            RE reNet = null;
            RE reStation = null;
            if (this.netRegexp != null) {
                reNet = new RE(this.netRegexp);
            }
            if (this.stationRegexp != null) {
                reStation = new RE(this.stationRegexp);
            }
            for (Station s : this.dl.getSeedConfig().getStation()) {
                found = false;
                if (reNet != null && this.stationRegexp == null) {
                    found = reNet.match(s.getBlockette050().getNetworkCode());
                }
                if (reNet == null && this.stationRegexp != null) {
                    found = reStation.match(s.getBlockette050().getStation());
                }
                if (reNet != null && this.stationRegexp != null) {
                    boolean bl = found = reNet.match(s.getBlockette050().getNetworkCode()) && reStation.match(s.getBlockette050().getStation());
                }
                if (!found) continue;
                netVec.add(s.getBlockette050().getNetworkCode());
                stationVec.add(s.getBlockette050().getStation());
            }
            this.net = new String[netVec.size()];
            this.station = new String[this.net.length];
            netVec.toArray(this.net);
            stationVec.toArray(this.station);
        }
        this.seedExportPlugin.setFilter(this.net, this.station);
        this.seedExportPlugin.process(this.eventId, this.startTime, this.endTime);
        this.waveformRecordLength = this.seedExportPlugin.getWaveformRecordLength();
        this.setBlockette052RecordLength();
        List<Station> origStaList = this.dl.getSeedConfig().getStation();
        LinkedList<Station> newStaList = new LinkedList<Station>();
        newStaList.addAll(origStaList);
        this.dl.getSeedConfig().setStation(newStaList);
        Vector<String> netVec = new Vector<String>();
        Vector<String> stationVec = new Vector<String>();
        int i = 0;
        while (i < this.net.length) {
            if (this.hasWaveform(this.net[i], this.station[i])) {
                netVec.add(this.net[i]);
                stationVec.add(this.station[i]);
            }
            ++i;
        }
        this.net = new String[netVec.size()];
        this.station = new String[this.net.length];
        netVec.toArray(this.net);
        stationVec.toArray(this.station);
        Iterator<Station> it = this.dl.getSeedConfig().getStation().iterator();
        while (it.hasNext()) {
            Station s = it.next();
            found = false;
            int i2 = 0;
            while (i2 < this.station.length) {
                if (s.getBlockette050().getNetworkCode().equals(this.net[i2]) && s.getBlockette050().getStation().equals(this.station[i2])) {
                    found = true;
                    break;
                }
                ++i2;
            }
            if (found) continue;
            it.remove();
        }
        logger.info("station size: " + this.station.length);
        this.buildVolumeIndex(this.dl);
        this.buildAbbr(this.dl);
        this.fixupVolumeIndex(this.dl);
        this.fixupTimeSpan(this.dl, 'P');
        this.fixupB074(this.dl);
        int seq = this.dl.writeSeedVolumeDataless(os);
        DecimalFormat fmt = new DecimalFormat("000000");
        int lsize = (int)Math.pow(2.0, this.dl.getVolumeIndex().getBlockette010().getLogicalRecordLength());
        List<Waveform> wfList = null;
        for (Blockette074 b074 : this.dl.getTimeSpan().get(0).getBlockette074()) {
            ChannelLocator cl = new ChannelLocator(b074.getNetworkCode(), b074.getStation(), b074.getLocation(), b074.getChannel());
            int chunkSize = this.seedExportPlugin.getWaveformChunkSize(cl);
            wfList = this.seedExportPlugin.getWaveform(cl);
            if (wfList == null) continue;
            int c = 1;
            for (Waveform w : wfList) {
                byte[] buf = w.getWaveform();
                int recLen = w.getRecLenth();
                int k = 0;
                while (k < w.getChunkSize()) {
                    System.arraycopy(fmt.format(seq).getBytes(), 0, w.getWaveform(), k * recLen, 6);
                    ((OutputStream)os).write(buf, k * recLen, recLen);
                    if (c++ % (lsize / this.waveformRecordLength) == 0) {
                        ++seq;
                    }
                    ++k;
                }
            }
            int nblock = chunkSize % (lsize / this.waveformRecordLength);
            byte[] zero = new byte[this.waveformRecordLength];
            int i3 = 0;
            while (i3 < zero.length) {
                zero[i3] = 32;
                ++i3;
            }
            if (nblock == 0) continue;
            int leftBlock = lsize / this.waveformRecordLength - nblock;
            int i4 = 0;
            while (i4 < leftBlock) {
                System.arraycopy(fmt.format(seq).getBytes(), 0, zero, 0, 6);
                ((OutputStream)os).write(zero);
                ++i4;
            }
            ++seq;
        }
        wfList = null;
        ((OutputStream)os).close();
        this.dl.getSeedConfig().setStation(origStaList);
        logger.info("Export " + this.file + " elapse time: " + (System.currentTimeMillis() - now));
    }

    public void clear() {
        this.seedExportPlugin.clear();
    }

    private boolean hasWaveform(String net, String sta) {
        Station stn = this.dl.findStation(net, sta);
        if (stn == null) {
            return false;
        }
        boolean found = false;
        for (Channel chn : stn.getChannel()) {
            ChannelLocator cl = new ChannelLocator(stn.getBlockette050().getNetworkCode(), stn.getBlockette050().getStation(), chn.getBlockette052().getLocation(), chn.getBlockette052().getChannel());
            if (this.seedExportPlugin.getWaveform(cl) == null) continue;
            found = true;
            break;
        }
        return found;
    }

    private void fixupB074(Dataless dl) throws IOException {
        int lsize = (int)Math.pow(2.0, dl.getVolumeIndex().getBlockette010().getLogicalRecordLength());
        List<Blockette074> b074s = dl.getTimeSpan().get(0).getBlockette074();
        for (Blockette074 b074 : b074s) {
            ChannelLocator cl = new ChannelLocator(b074.getNetworkCode(), b074.getStation(), b074.getLocation(), b074.getChannel());
            if (this.seedExportPlugin.getWaveform(cl) == null) continue;
            int nblock = this.seedExportPlugin.getWaveformChunkSize(cl);
            b074.setFirstSequence(this.seqT);
            b074.setFirstSubSequence(1);
            b074.setLastSequence(this.seqT + (nblock - 1) / (lsize / this.waveformRecordLength));
            b074.setLastSubSeuence((nblock - 1) % (lsize / this.waveformRecordLength) + 1);
            this.seqT += nblock / (lsize / this.waveformRecordLength);
            if (nblock % (lsize / this.waveformRecordLength) <= 0) continue;
            ++this.seqT;
        }
    }

    private void setBlockette052RecordLength() {
        int len = 256;
        int n = 8;
        while ((len *= 2) <= this.waveformRecordLength) {
            ++n;
        }
        for (Station s : this.dl.getSeedConfig().getStation()) {
            for (Channel c : s.getChannel()) {
                Blockette052 b052 = c.getBlockette052();
                if (b052 == null) continue;
                b052.setDataRecordLength(n);
            }
        }
    }

    private void fixupTimeSpan(Dataless dl, char flag) throws IOException {
        int total = 0;
        if (dl.getTimeSpan().size() == 0) {
            dl.getTimeSpan().add(new TimeSpan());
            dl.getTimeSpan().get(0).setBlockette070(new Blockette070());
        }
        TimeSpan ts = dl.getTimeSpan().get(0);
        Blockette070 b070 = ts.getBlockette070();
        b070.setStartTime(new TimeStamp(this.startTime.getTime()));
        b070.setEndTime(new TimeStamp(this.endTime.getTime()));
        b070.setTimeSpanFlag(flag);
        b070.fixupBlocketteLength();
        total += b070.getBlocketteLength();
        ArrayList<Blockette074> b074s = new ArrayList<Blockette074>();
        dl.getTimeSpan().get(0).setBlockette074(b074s);
        int i = 0;
        while (i < this.station.length) {
            Station sta = dl.findStation(this.net[i], this.station[i]);
            if (sta != null) {
                for (Channel c : sta.getChannel()) {
                    ChannelLocator cl = new ChannelLocator(sta.getBlockette050().getNetworkCode(), sta.getBlockette050().getStation(), c.getBlockette052().getLocation(), c.getBlockette052().getChannel());
                    if (this.seedExportPlugin.getWaveform(cl) == null) continue;
                    Blockette074 b074 = new Blockette074();
                    b074s.add(b074);
                    b074.setStation(sta.getBlockette050().getStation());
                    b074.setNetworkCode(sta.getBlockette050().getNetworkCode());
                    b074.setLocation(c.getBlockette052().getLocation());
                    b074.setChannel(c.getBlockette052().getChannel());
                    b074.setStartTime(new TimeStamp(this.startTime.getTime()));
                    b074.setFirstSequence(0);
                    b074.setFirstSubSequence(1);
                    b074.setLastSequence(0);
                    b074.setLastSequence(1);
                    b074.setEndTime(new TimeStamp(this.endTime.getTime()));
                    b074.fixupBlocketteLength();
                    total += b074.getBlocketteLength();
                }
            }
            ++i;
        }
        int lsize = (int)Math.pow(2.0, dl.getVolumeIndex().getBlockette010().getLogicalRecordLength());
        int nblock = total / (lsize - 8);
        if (total % (lsize - 8) > 0) {
            ++nblock;
        }
        this.sizeT = nblock;
        this.seqT += this.sizeT;
    }

    private int getStationBlockSize(Dataless dl, String net, String stn) {
        int total = 0;
        Station sta = dl.findStation(net, stn);
        if (sta == null) {
            return 0;
        }
        sta.getBlockette050().fixupBlocketteLength();
        total += sta.getBlockette050().getBlocketteLength();
        for (Blockette051 b051 : sta.getBlockette051()) {
            total += b051.getBlocketteLength();
        }
        for (Channel chn : sta.getChannel()) {
            chn.getBlockette052().fixupBlocketteLength();
            total += chn.getBlockette052().getBlocketteLength();
            for (Response rsp : chn.getResponse()) {
                if (rsp.getBlockette053() != null) {
                    rsp.getBlockette053().fixupBlocketteLength();
                    total += rsp.getBlockette053().getBlocketteLength();
                }
                if (rsp.getBlockette054() != null) {
                    rsp.getBlockette054().fixupBlocketteLength();
                    total += rsp.getBlockette054().getBlocketteLength();
                }
                if (rsp.getBlockette055() != null) {
                    rsp.getBlockette055().fixupBlocketteLength();
                    total += rsp.getBlockette055().getBlocketteLength();
                }
                if (rsp.getBlockette056() != null) {
                    rsp.getBlockette056().fixupBlocketteLength();
                    total += rsp.getBlockette056().getBlocketteLength();
                }
                if (rsp.getBlockette057() != null) {
                    rsp.getBlockette057().fixupBlocketteLength();
                    total += rsp.getBlockette057().getBlocketteLength();
                }
                if (rsp.getBlockette058() != null) {
                    rsp.getBlockette058().fixupBlocketteLength();
                    total += rsp.getBlockette058().getBlocketteLength();
                }
                if (rsp.getBlockette061() == null) continue;
                rsp.getBlockette061().fixupBlocketteLength();
                total += rsp.getBlockette061().getBlocketteLength();
            }
        }
        int lsize = (int)Math.pow(2.0, dl.getVolumeIndex().getBlockette010().getLogicalRecordLength());
        int nblock = total / (lsize - 8);
        if (total % (lsize - 8) > 0) {
            ++nblock;
        }
        return nblock;
    }

    private void buildVolumeIndex(Dataless dl) {
        Blockette010 b010 = dl.getVolumeIndex().getBlockette010();
        b010.setStartTime(new TimeStamp(this.startTime.getTime()));
        b010.setEndTime(new TimeStamp(this.endTime.getTime()));
        b010.setVolumeTime(new TimeStamp(new Date().getTime()));
        b010.setOrganization("DSN");
        b010.setLabel("DSN");
        b010.setLogicalRecordLength(12);
        b010.fixupBlocketteLength();
        Blockette011 b011 = dl.getVolumeIndex().getBlockette011();
        if (b011 == null) {
            b011 = new Blockette011();
            dl.getVolumeIndex().setBlockette011(b011);
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        String[] stringArray = this.station;
        int n = this.station.length;
        int n2 = 0;
        while (n2 < n) {
            String sta = stringArray[n2];
            Pair p = new Pair();
            p.setStation(sta);
            pairs.add(p);
            p.setSequence(0);
            ++n2;
        }
        b011.setPairs(pairs);
        b011.fixupBlocketteLength();
        Blockette012 b012 = dl.getVolumeIndex().getBlockette012();
        if (b012 == null) {
            b012 = new Blockette012();
            dl.getVolumeIndex().setBlockette012(b012);
        }
        Span span = new Span();
        span.setBeginingOfSpan(new TimeStamp(this.startTime.getTime()));
        span.setEndOfSpan(new TimeStamp(this.endTime.getTime()));
        span.setSequence(0);
        ArrayList<Span> spans = new ArrayList<Span>();
        spans.add(span);
        b012.setSpans(spans);
        b012.fixupBlocketteLength();
        int total = b010.getBlocketteLength() + b011.getBlocketteLength() + b012.getBlocketteLength();
        int lsize = (int)Math.pow(2.0, b010.getLogicalRecordLength());
        this.seqA = this.seqV + total / (lsize - 8);
        if (total % (lsize - 8) > 0) {
            ++this.seqA;
        }
    }

    private void fixupVolumeIndex(Dataless dl) {
        List<Pair> pairs = dl.getVolumeIndex().getBlockette011().getPairs();
        int i = 0;
        while (i < this.station.length) {
            Pair p = pairs.get(i);
            p.setStation(this.station[i]);
            p.setSequence(this.seqS);
            this.seqS += this.getStationBlockSize(dl, this.net[i], this.station[i]);
            ++i;
        }
        this.seqT = this.seqS;
        dl.getVolumeIndex().getBlockette012().getSpans().get(0).setSequence(this.seqT);
    }

    private void buildAbbr(Dataless dl) {
        int total = 0;
        List<Blockette030> b030s = dl.getSeedConfig().getAbbreviation().getBlockette030();
        for (Blockette030 b : b030s) {
            b.fixupBlocketteLength();
            total += b.getBlocketteLength();
        }
        List<Blockette031> b031s = dl.getSeedConfig().getAbbreviation().getBlockette031();
        for (Blockette031 b : b031s) {
            b.fixupBlocketteLength();
            total += b.getBlocketteLength();
        }
        List<Blockette032> b032s = dl.getSeedConfig().getAbbreviation().getBlockette032();
        for (Blockette032 b : b032s) {
            b.fixupBlocketteLength();
            total += b.getBlocketteLength();
        }
        List<Blockette033> b033s = dl.getSeedConfig().getAbbreviation().getBlockette033();
        for (Blockette033 b : b033s) {
            b.fixupBlocketteLength();
            total += b.getBlocketteLength();
        }
        List<Blockette034> b034s = dl.getSeedConfig().getAbbreviation().getBlockette034();
        for (Blockette034 b : b034s) {
            b.fixupBlocketteLength();
            total += b.getBlocketteLength();
        }
        int lsize = (int)Math.pow(2.0, dl.getVolumeIndex().getBlockette010().getLogicalRecordLength());
        this.seqS = this.seqA + total / (lsize - 8);
        if (total % (lsize - 8) > 0) {
            ++this.seqS;
        }
    }

    public void setNetStation(String[] net, String[] sta) {
        this.net = net;
        this.station = sta;
        this.netRegexp = null;
        this.stationRegexp = null;
    }

    public void setNetStationRegexp(String netRegexp, String staRegexp) {
        this.netRegexp = netRegexp;
        this.stationRegexp = staRegexp;
        this.net = null;
        this.station = null;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
        this.eventId = null;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
        this.eventId = null;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
        this.endTime = null;
        this.startTime = null;
    }

    public void setSeedExportPlugin(SeedExportPlugin seedExportPlugin) {
        this.seedExportPlugin = seedExportPlugin;
    }

    public static void main(String[] args) throws Exception {
        SeedExporterUtil.testEvent(args);
    }

    public static void testEvent(String[] args) throws Exception {
        FileSystemResource res = new FileSystemResource("JOPENS-service-test.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        SeedVolumeService service = (SeedVolumeService)factory.getBean("seedVolumeService");
        SeedExporterUtil util = new SeedExporterUtil();
        util.setFile(new File("/tmp/test.seed"));
        util.setEventId("434");
        util.setNetStationRegexp(".*", "SHZ");
        util.export();
        EventExportPlugin seedExportPlugin = new EventExportPlugin();
        seedExportPlugin.setStationService(service);
        seedExportPlugin.setWaveformService(service);
        util.setSeedExportPlugin(seedExportPlugin);
    }

    public static void testTimeSpan(String[] args) throws Exception {
        long ms = new Date().getTime();
        long ms1 = ms / 1000L / 3600L / 24L * 24L * 3600L * 1000L - (long)TimeZone.getDefault().getRawOffset();
        System.out.println(new Date(ms));
        System.out.println(new Date(ms1));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        FileSystemResource res = new FileSystemResource("JOPENS-service-test.xml");
        XmlBeanFactory factory = new XmlBeanFactory(res);
        SeedVolumeService service = (SeedVolumeService)factory.getBean("seedVolumeService");
        SeedExporterUtil util = new SeedExporterUtil();
        util.setFile(new File("/tmp/test.seed"));
        util.setEventId(null);
        util.setStartTime(sdf.parse("2007-04-19 00:00:00"));
        util.setEndTime(sdf.parse("2007-04-20 00:00:00"));
        util.setNetStationRegexp("GD", "XNH");
        EventExportPlugin seedExportPlugin = new EventExportPlugin();
        seedExportPlugin.setStationService(service);
        seedExportPlugin.setWaveformService(service);
        util.setSeedExportPlugin(seedExportPlugin);
        util.export();
    }
}

