/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.InstrDic;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.jopens.entity.Sourceparameter;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.service.EqType;
import cn.org.gddsn.jopens.service.PhaseChild;
import cn.org.gddsn.jopens.service.PhaseParent;
import cn.org.gddsn.jopens.service.ReportService;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.PageSize;
import com.lowagie.text.Phrase;
import com.lowagie.text.Table;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TemporalType;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Local(value={ReportService.class})
@Remote(value={ReportService.class})
public class ReportServiceBean
implements ReportService {
    static Logger logger = Logger.getLogger(ReportServiceBean.class);
    private static final String DEFAULT_FONT = "/usr/local/jopens/msdp/font/gbsn00lp.ttf";
    private static final String reportDir = "/usr/local/jopens/report";
    @PersistenceContext
    private EntityManager em;
    private String blank = " ";
    private PrintWriter wr;
    private SimpleDateFormat dateFt = new SimpleDateFormat("yyyy/MM/dd");
    private SimpleDateFormat timeFt = new SimpleDateFormat("HH:mm:ss.SS");
    private SimpleDateFormat timeFt10 = new SimpleDateFormat("HH:mm:ss");

    private String findFontFile() {
        File f = new File(DEFAULT_FONT);
        if (f.exists() && f.isFile() && f.canRead()) {
            return DEFAULT_FONT;
        }
        String path = System.getProperty("user.dir");
        logger.info("User current dir: " + path);
        File f1 = new File(path, "gbsn00lp.ttf");
        logger.info("Try to use " + f1.getAbsolutePath());
        return f1.getAbsolutePath();
    }

    @Override
    public byte[] generatePdfCatalog(String title, String subTitle, String where, String fileName) throws IOException {
        if (fileName != null) {
            FileOutputStream fos = new FileOutputStream(new File(reportDir, fileName));
            this.generatePdfCatalog(title, subTitle, where, fos, this.findFontFile());
            fos.close();
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0x100000);
        this.generatePdfCatalog(title, subTitle, where, baos, this.findFontFile());
        baos.close();
        return baos.toByteArray();
    }

    @Override
    public byte[] generatePdfReport(String title, String subTitle, String where, String fileName, char cataType) throws IOException {
        if (fileName != null) {
            FileOutputStream fos = new FileOutputStream(new File(reportDir, fileName));
            this.generatePdfReport(title, subTitle, where, fos, this.findFontFile(), cataType);
            fos.close();
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(0x800000);
        this.generatePdfReport(title, subTitle, where, baos, this.findFontFile(), cataType);
        baos.close();
        return baos.toByteArray();
    }

    @Override
    public byte[] generateWeekCatalog(String where, String fileName) throws IOException {
        if (fileName != null) {
            OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "GB2312");
            this.generateWeekCatalog(where, fos);
            fos.close();
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "GB2312");
        this.generateWeekCatalog(where, osw);
        osw.close();
        return baos.toByteArray();
    }

    @Override
    public byte[] generateNewCatalog(String where, String fileName) throws IOException {
        if (fileName != null) {
            OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "GB2312");
            this.generateCatalog(where, fos, true);
            fos.close();
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "GB2312");
        this.generateCatalog(where, osw, true);
        osw.close();
        return baos.toByteArray();
    }

    @Override
    public byte[] generateMonthCatalog(String where, String fileName) throws IOException {
        if (fileName != null) {
            OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), "GB2312");
            this.generateCatalog(where, fos, false);
            fos.close();
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(16384);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, "GB2312");
        this.generateCatalog(where, osw, false);
        osw.close();
        return baos.toByteArray();
    }

    public void generatePdfCatalog(String title, String subTitle, String where, OutputStream os, String fontFile) throws IOException {
        Document document = new Document(PageSize.A4.rotate(), 36.0f, 36.0f, 36.0f, 18.0f);
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)os);
            BaseFont bfcf = BaseFont.createFont((String)fontFile, (String)"Identity-H", (boolean)true);
            Font font = new Font(bfcf, 12.0f);
            HeaderFooter header = new HeaderFooter(new Phrase(title, new Font(bfcf, 20.0f)), false);
            header.setAlignment(1);
            header.setBorder(0);
            document.setHeader(header);
            HeaderFooter footer = new HeaderFooter(new Phrase("", font), true);
            footer.setAlignment(1);
            footer.setBorder(0);
            document.setFooter(footer);
            document.open();
            Table datatable = new Table(17);
            datatable.setPadding(3.0f);
            datatable.setSpacing(0.0f);
            datatable.setBorder(0);
            int[] headerwidths = new int[]{5, 3, 3, 3, 5, 10, 12, 14, 3, 4, 4, 4, 6, 4, 4, 5, 18};
            datatable.setWidths(headerwidths);
            datatable.setWidth(107.0f);
            Cell cell_y_m = new Cell((Element)new Phrase(subTitle, font));
            cell_y_m.setHorizontalAlignment(2);
            cell_y_m.setColspan(17);
            cell_y_m.setBorder(0);
            datatable.addCell(cell_y_m);
            datatable.setDefaultCellBorderWidth(2.0f);
            datatable.setDefaultHorizontalAlignment(1);
            datatable.setDefaultRowspan(2);
            datatable.addCell(new Phrase("\u5e8f  \u53f7", font));
            datatable.setDefaultRowspan(1);
            datatable.setDefaultColspan(4);
            datatable.addCell(new Phrase("\u53d1\u9707\u65f6\u95f4", font));
            datatable.setDefaultRowspan(1);
            datatable.setDefaultColspan(3);
            datatable.addCell(new Phrase("\u9707\u4e2d\u4f4d\u7f6e", font));
            datatable.setDefaultRowspan(2);
            datatable.setDefaultColspan(1);
            datatable.addCell(new Phrase("\u4f4d  \u53f7", font));
            datatable.setDefaultRowspan(1);
            datatable.setDefaultColspan(3);
            datatable.addCell(new Phrase("\u9707\u7ea7", font));
            datatable.setDefaultRowspan(2);
            datatable.setDefaultColspan(1);
            datatable.addCell(new Phrase("\u6df1\u5ea6(km)", font));
            datatable.addCell(new Phrase("\u7cbe  \u5ea6", font));
            datatable.addCell(new Phrase("\u53f0\u6570", font));
            datatable.addCell(new Phrase("\u8d44\u6599\u6765\u6e90", font));
            datatable.addCell(new Phrase("\u5907\u6ce8", font));
            datatable.setDefaultRowspan(1);
            datatable.setDefaultColspan(1);
            datatable.addCell(new Phrase("\u65e5", font));
            datatable.addCell(new Phrase("\u65f6", font));
            datatable.addCell(new Phrase("\u5206", font));
            datatable.addCell(new Phrase("\u79d2", font));
            datatable.addCell(new Phrase("\u7eac\u5ea6", font));
            datatable.addCell(new Phrase("\u7ecf\u5ea6", font));
            datatable.addCell(new Phrase("\u5730\u70b9", font));
            datatable.addCell(new Phrase("ML", font));
            datatable.addCell(new Phrase("Md", font));
            datatable.addCell(new Phrase("Ms", font));
            datatable.endHeaders();
            datatable.setDefaultRowspan(1);
            datatable.setDefaultColspan(1);
            datatable.setDefaultCellBorderWidth(1.0f);
            int n = 0;
            SimpleDateFormat dd = new SimpleDateFormat("dd");
            SimpleDateFormat HH = new SimpleDateFormat("HH");
            SimpleDateFormat mm = new SimpleDateFormat("mm");
            SimpleDateFormat ss = new SimpleDateFormat("ss");
            DecimalFormat mag_df = new DecimalFormat("0.0");
            DecimalFormat two_df = new DecimalFormat("00");
            DecimalFormat three_df = new DecimalFormat("000");
            this.em.flush();
            List lst = this.em.createQuery("select e from CatalogC e where " + where + " order by e.originTime, e.originTimeFrac").getResultList();
            for (Catalog c : lst) {
                datatable.addCell(new Phrase("" + ++n, font));
                Date sb = c.getOriginTime();
                int sb_ns = c.getOriginTimeFrac();
                Date sbc = new Date(sb.getTime() + (long)((int)Math.round((double)sb_ns / 10.0)));
                datatable.addCell(new Phrase(dd.format(sbc), font));
                datatable.addCell(new Phrase(HH.format(sbc), font));
                datatable.addCell(new Phrase(mm.format(sbc), font));
                String dotStr = Integer.toString(Math.round((float)(sbc.getTime() % 1000L) / 100.0f));
                if (sb_ns < 9500) {
                    datatable.addCell(new Phrase(String.valueOf(ss.format(sbc)) + "." + dotStr, font));
                } else {
                    long v = sbc.getTime();
                    long v1 = Math.round((double)v / 1000.0);
                    long v2 = v1 * 1000L;
                    datatable.addCell(new Phrase(String.valueOf(ss.format(v2)) + ".0", font));
                }
                double lat = c.getLat();
                if (lat < -98.0) {
                    datatable.addCell("");
                } else {
                    double lat_c = (double)((int)lat) + (double)Math.round((lat - (double)((int)lat)) * 60.0) / 60.0;
                    String str_lat = two_df.format((int)lat_c) + "\u00b0" + two_df.format(Math.round((lat_c - (double)((int)lat_c)) * 60.0)) + "\u2032";
                    datatable.addCell(new Phrase(str_lat, font));
                }
                if (lat < -98.0) {
                    datatable.addCell("");
                } else {
                    double lon = c.getLon();
                    double lon_c = (double)((int)lon) + (double)Math.round((lon - (double)((int)lon)) * 60.0) / 60.0;
                    String str_lon = three_df.format((int)lon_c) + "\u00b0" + two_df.format(Math.round((lon_c - (double)((int)lon_c)) * 60.0)) + "\u2032";
                    datatable.addCell(new Phrase(str_lon, font));
                }
                datatable.addCell(new Phrase(c.getLocation(), font));
                if (c.getEpicId() == null) {
                    datatable.addCell("");
                } else {
                    datatable.addCell(new Phrase(c.getEpicId(), font));
                }
                double ml = this.getMag(c, "ML");
                if (ml > -9999.0) {
                    datatable.addCell(new Phrase(mag_df.format(ml), font));
                } else {
                    datatable.addCell("");
                }
                double md = this.getMag(c, "Md");
                if (md > -9999.0) {
                    datatable.addCell(new Phrase(mag_df.format(md), font));
                } else {
                    datatable.addCell("");
                }
                double ms = this.getMag(c, "Ms");
                if (ms > -9999.0) {
                    datatable.addCell(new Phrase(mag_df.format(ms), font));
                } else {
                    datatable.addCell("");
                }
                double depth = c.getDepth();
                if (depth < -99998.0) {
                    datatable.addCell("");
                } else {
                    datatable.addCell(new Phrase(three_df.format(depth), font));
                }
                if (c.getQloc() == null) {
                    datatable.addCell("");
                } else {
                    datatable.addCell(new Phrase(c.getQloc(), font));
                }
                datatable.addCell(new Phrase(two_df.format(this.getLocStn(c)), font));
                if (c.getSourceId() == null) {
                    datatable.addCell("");
                } else {
                    datatable.addCell(new Phrase(c.getSourceId(), font));
                }
                String comment = c.getRemark();
                if (comment == null) {
                    comment = "";
                }
                Cell comment_cell = new Cell((Element)new Phrase(comment, font));
                comment_cell.setHorizontalAlignment(0);
                datatable.addCell(comment_cell);
            }
            document.add((Element)datatable);
        }
        catch (DocumentException de) {
            logger.warn(de.getMessage());
        }
        catch (IOException ioe) {
            logger.warn(ioe.getMessage());
        }
        document.close();
    }

    public void generateCatalog(String where, Writer wr, boolean isNewCatalog) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd HHmmss");
        DecimalFormat mag_df = new DecimalFormat("0.0");
        DecimalFormat depth_df = new DecimalFormat("000");
        DecimalFormat two_df = new DecimalFormat("00");
        DecimalFormat three_df = new DecimalFormat("000");
        this.em.flush();
        List lst = this.em.createQuery("select e from CatalogC e where " + where + " order by e.originTime, e.originTimeFrac").getResultList();
        for (Catalog c : lst) {
            Date sb = c.getOriginTime();
            int sb_fr = c.getOriginTimeFrac();
            Date sbc = new Date(sb.getTime() / 1000L * 1000L + (long)((int)Math.round((double)sb_fr / 10.0)));
            String dotStr = Integer.toString(Math.round((float)(sbc.getTime() % 1000L) / 100.0f));
            if (sb_fr < 9500) {
                wr.write(String.valueOf(sdf.format(sbc)) + "." + dotStr);
            } else {
                long v = sbc.getTime();
                long v1 = Math.round((double)v / 1000.0);
                long v2 = v1 * 1000L;
                wr.write(String.valueOf(sdf.format(v2)) + ".0");
            }
            wr.write(32);
            double lat = c.getLat();
            if (lat < -98.0) {
                wr.write("    ");
            } else {
                double lat_c = (double)((int)lat) + (double)Math.round((lat - (double)((int)lat)) * 60.0) / 60.0;
                wr.write(two_df.format((int)lat_c) + two_df.format((int)Math.round((lat_c - (double)((int)lat_c)) * 60.0)));
            }
            wr.write(32);
            if (lat < -98.0) {
                wr.write("     ");
            } else {
                double lon = c.getLon();
                double lon_c = (double)((int)lon) + (double)Math.round((lon - (double)((int)lon)) * 60.0) / 60.0;
                wr.write(three_df.format((int)lon_c) + two_df.format((int)Math.round((lon_c - (double)((int)lon_c)) * 60.0)));
            }
            wr.write(32);
            double depth = c.getDepth();
            if (depth < -99998.0) {
                wr.write("   ");
            } else {
                wr.write(depth_df.format(depth));
            }
            wr.write(32);
            double ml = this.getMag(c, "ML");
            if (ml > -9999.0) {
                wr.write("ML" + mag_df.format(ml));
            } else {
                wr.write("     ");
            }
            wr.write(32);
            if (c.getEpicId() == null) {
                wr.write("  ");
            } else {
                wr.write(c.getEpicId());
            }
            if (c.getQloc() == null || Integer.parseInt(c.getQloc()) < -99998) {
                wr.write("4");
            } else {
                wr.write(c.getQloc());
            }
            if (c.getSourceId() == null || Integer.parseInt(c.getSourceId()) < -99998) {
                wr.write("00");
            } else {
                wr.write(two_df.format(Integer.parseInt(c.getSourceId())));
            }
            wr.write(32);
            int used_stn = this.getLocStn(c);
            wr.write(two_df.format(used_stn));
            wr.write(32);
            String eflag = c.getEqType();
            if (eflag.equals("\u5929\u7136\u5730\u9707")) {
                wr.write("E");
            } else {
                wr.write("B");
            }
            if (isNewCatalog) {
                this.handlNewCatalog(c, wr);
            }
            if (used_stn == 1) {
                String comment = c.getRemark();
                int idx = comment.indexOf(40);
                if (idx != -1 && comment.length() >= idx + 7) {
                    wr.write("0" + comment.substring(idx + 4, idx + 7));
                    wr.write(32);
                    wr.write(comment.substring(0, idx));
                } else {
                    wr.write("0     ");
                }
            } else {
                wr.write("     ");
                wr.write(c.getLocation());
            }
            wr.write("\r\n");
        }
    }

    private void handlNewCatalog(Catalog c, Writer wr) throws IOException {
        List lst = this.em.createQuery("select e from Sourceparameter e where e.catalog.id = :id").setParameter("id", (Object)c.getId()).getResultList();
        if (lst.size() == 0) {
            return;
        }
        Sourceparameter sp = (Sourceparameter)lst.get(0);
        String buf = String.format(" Mw%3.1f %8.3E %5.2f %7.2f", Float.valueOf(sp.getMw()), Float.valueOf(sp.getM0()), Float.valueOf(sp.getStressDrop()), Float.valueOf(sp.getRadius()));
        wr.write(buf);
    }

    public void generateWeekCatalog(String where, Writer wr) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        DecimalFormat mag_df = new DecimalFormat("0.0");
        DecimalFormat depth_df = new DecimalFormat("000");
        DecimalFormat two_df = new DecimalFormat("00");
        DecimalFormat three_df = new DecimalFormat("000");
        this.em.flush();
        List lst = this.em.createQuery("select e from CatalogC e where " + where + " order by e.originTime, e.originTimeFrac").getResultList();
        for (Catalog c : lst) {
            Date sb = c.getOriginTime();
            int sb_fr = c.getOriginTimeFrac();
            Date sbc = new Date(sb.getTime() / 1000L * 1000L + (long)Math.round((float)sb_fr / 10.0f));
            String dotStr = Integer.toString(Math.round((float)(sbc.getTime() % 1000L) / 100.0f));
            if (sb_fr < 9500) {
                wr.write(String.valueOf(sdf.format(sbc)) + "." + dotStr);
            } else {
                long v = sbc.getTime();
                long v1 = Math.round((double)v / 1000.0);
                long v2 = v1 * 1000L;
                wr.write(String.valueOf(sdf.format(v2)) + ".0");
            }
            wr.write(32);
            double lat = c.getLat();
            if (lat < -99998.0) {
                wr.write("    ");
            } else {
                double lat_c = (double)((int)lat) + (double)Math.round((lat - (double)((int)lat)) * 60.0) / 60.0;
                wr.write(two_df.format((int)lat_c) + two_df.format((int)Math.round((lat_c - (double)((int)lat_c)) * 60.0)));
            }
            wr.write(32);
            if (lat < -99998.0) {
                wr.write("     ");
            } else {
                double lon = c.getLon();
                double lon_c = (double)((int)lon) + (double)Math.round((lon - (double)((int)lon)) * 60.0) / 60.0;
                wr.write(three_df.format((int)lon_c) + two_df.format((int)Math.round((lon_c - (double)((int)lon_c)) * 60.0)));
            }
            wr.write(32);
            double ml = this.getMag(c, "ML");
            if (ml > -9999.0) {
                wr.write("ML" + mag_df.format(ml));
            } else {
                wr.write("     ");
            }
            wr.write(32);
            double depth = c.getDepth();
            if (depth < -99998.0) {
                wr.write("000");
            } else {
                wr.write(depth_df.format(depth));
            }
            if (c.getEpicId() == null || Integer.parseInt(c.getEpicId()) < -99998) {
                wr.write("00");
            } else {
                wr.write(two_df.format(Integer.parseInt(c.getEpicId())));
            }
            wr.write(c.getQloc());
            if (c.getSourceId() == null || Integer.parseInt(c.getSourceId()) < -99998) {
                wr.write("00");
            } else {
                wr.write(two_df.format(Integer.parseInt(c.getSourceId())));
            }
            wr.write(32);
            wr.write(c.getLocation());
            wr.write("\r\n");
        }
    }

    public void generatePdfReport(String title, String subTitle, String where, OutputStream os, String fontFile, char cataType) throws IOException {
        int nRowInPage = 21;
        int nRow = 0;
        int n = 0;
        Document document = new Document(PageSize.A4.rotate());
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)os);
            BaseFont bfcf = BaseFont.createFont((String)fontFile, (String)"Identity-H", (boolean)true);
            Font font = new Font(bfcf, 10.9f);
            Font fnt_title = new Font(bfcf, 20.0f);
            Font fnt_sub = new Font(bfcf, 6.0f);
            Table datatable = this.fillPdfReportFrame(document, title, subTitle, font, fnt_title, fnt_sub);
            this.em.flush();
            String select = "select e from CatalogC e where ";
            select = cataType == 'I' ? "select e from CatalogI e where " : (cataType == 'A' ? "select e from CatalogA e where " : (cataType == 'R' ? "select e from CatalogR e where " : "select e from CatalogC e where "));
            List lst = this.em.createQuery(String.valueOf(select) + where + " order by e.originTime, e.originTimeFrac").getResultList();
            for (Catalog c : lst) {
                nRow += this.getLocPha(c) + 1;
                String cata_id = c.getCataName();
                logger.info("process " + n + ": " + cata_id);
                this.fillOneCatalogReport(datatable, font, fnt_sub, ++n, c);
            }
            int padRow = nRow % nRowInPage;
            int i = 0;
            while (i < nRowInPage - padRow) {
                this.fillBlankCells(datatable, 19, 1);
                ++i;
            }
            document.add((Element)datatable);
        }
        catch (DocumentException de) {
            logger.warn(de.getMessage());
        }
        catch (IOException ioe) {
            logger.warn(ioe.getMessage());
        }
        document.close();
    }

    private float getMag(List<Phase> phs, String netCode, String station, String mag) {
        float mv = -99999.0f;
        for (Phase p : phs) {
            if (!p.getChannelLocator().getNetCode().equals(netCode) || !p.getChannelLocator().getStationCode().equals(station) || p.getMagType() == null || !p.getMagType().getId().equalsIgnoreCase(mag)) continue;
            mv = p.getMagVal();
            break;
        }
        return mv;
    }

    private List<Phase> getPhases(List<Station> allSta, Catalog c) {
        List<Phase> lst = c.getPhases();
        int size = lst.size();
        Phase p0 = lst.get(0);
        ArrayList<PhaseParent> phaseParents = new ArrayList<PhaseParent>();
        ArrayList<PhaseChild> phaseChildren = new ArrayList<PhaseChild>();
        int i = 0;
        while (i < size) {
            Phase p1 = lst.get(i);
            if (p1.getChannelLocator().getNetCode().equals(p0.getChannelLocator().getNetCode()) && p1.getChannelLocator().getStationCode().equals(p0.getChannelLocator().getStationCode())) {
                phaseChildren.add(new PhaseChild(p1));
                p0 = p1;
            } else {
                Collections.sort(phaseChildren);
                Station sta = this.findStation(allSta, ((PhaseChild)phaseChildren.get(0)).getPhase());
                phaseParents.add(new PhaseParent(phaseChildren, c.getLat(), c.getLon(), sta.getBlockette050().getLatitude(), sta.getBlockette050().getLongitude()));
                phaseChildren = new ArrayList();
                phaseChildren.add(new PhaseChild(p1));
                p0 = p1;
            }
            ++i;
        }
        Collections.sort(phaseChildren);
        Station sta = this.findStation(allSta, ((PhaseChild)phaseChildren.get(0)).getPhase());
        phaseParents.add(new PhaseParent(phaseChildren, c.getLat(), c.getLon(), sta.getBlockette050().getLatitude(), sta.getBlockette050().getLongitude()));
        Collections.sort(phaseParents);
        ArrayList<Phase> newlst = new ArrayList<Phase>();
        int count = 0;
        int sizeParent = phaseParents.size();
        int j = 0;
        while (j < sizeParent) {
            PhaseParent phaseParent = (PhaseParent)phaseParents.get(j);
            int sizeChild = phaseParent.getPhaseChildren().size();
            int k = 0;
            while (k < sizeChild) {
                newlst.add(phaseParent.getPhaseChildren().get(k).getPhase());
                ++count;
                ++k;
            }
            ++j;
        }
        logger.info("checking: FORMER/NOW   locPha: " + c.getLocPha() + "/" + count + " locStn: " + c.getLocStn() + "/" + sizeParent);
        return newlst;
    }

    private List<Station> findAllStation() {
        List allSta = this.em.createQuery("select s from Station s  ").getResultList();
        return allSta;
    }

    private Station findStation(List<Station> allSta, Phase p) {
        Station sta = null;
        int i = 0;
        while (i < allSta.size()) {
            if (p.getChannelLocator().getNetCode().equals(allSta.get(i).getBlockette050().getNetworkCode()) && p.getChannelLocator().getStationCode().equals(allSta.get(i).getBlockette050().getStation())) {
                sta = allSta.get(i);
                break;
            }
            ++i;
        }
        return sta;
    }

    private List<PhaseParent> getPhaseParentsAndChildren(Catalog c) {
        List<Phase> lst = c.getPhases();
        int size = lst.size();
        Phase p0 = lst.get(0);
        ArrayList<PhaseParent> phaseParents = new ArrayList<PhaseParent>();
        ArrayList<PhaseChild> phaseChildren = new ArrayList<PhaseChild>();
        int i = 0;
        while (i < size) {
            Phase p1 = lst.get(i);
            if (p1.getChannelLocator().getNetCode().equals(p0.getChannelLocator().getNetCode()) && p1.getChannelLocator().getStationCode().equals(p0.getChannelLocator().getStationCode())) {
                phaseChildren.add(new PhaseChild(p1));
                p0 = p1;
            } else {
                Collections.sort(phaseChildren);
                phaseParents.add(new PhaseParent(phaseChildren));
                phaseChildren = new ArrayList();
                phaseChildren.add(new PhaseChild(p1));
                p0 = p1;
            }
            ++i;
        }
        Collections.sort(phaseChildren);
        phaseParents.add(new PhaseParent(phaseChildren));
        Collections.sort(phaseParents);
        return phaseParents;
    }

    private List<PhaseParent> getPhaseParentsAndChildren(List<Station> allSta, Catalog c) {
        List<Phase> lst = c.getPhases();
        int size = lst.size();
        Phase p0 = lst.get(0);
        ArrayList<PhaseParent> phaseParents = new ArrayList<PhaseParent>();
        ArrayList<PhaseChild> phaseChildren = new ArrayList<PhaseChild>();
        int i = 0;
        while (i < size) {
            Phase p1 = lst.get(i);
            if (p1.getChannelLocator().getNetCode().equals(p0.getChannelLocator().getNetCode()) && p1.getChannelLocator().getStationCode().equals(p0.getChannelLocator().getStationCode())) {
                phaseChildren.add(new PhaseChild(p1));
                p0 = p1;
            } else {
                Collections.sort(phaseChildren);
                Station sta = this.findStation(allSta, ((PhaseChild)phaseChildren.get(0)).getPhase());
                phaseParents.add(new PhaseParent(phaseChildren, c.getLat(), c.getLon(), sta.getBlockette050().getLatitude(), sta.getBlockette050().getLongitude()));
                phaseChildren = new ArrayList();
                phaseChildren.add(new PhaseChild(p1));
                p0 = p1;
            }
            ++i;
        }
        Collections.sort(phaseChildren);
        Station sta = this.findStation(allSta, ((PhaseChild)phaseChildren.get(0)).getPhase());
        phaseParents.add(new PhaseParent(phaseChildren, c.getLat(), c.getLon(), sta.getBlockette050().getLatitude(), sta.getBlockette050().getLongitude()));
        Collections.sort(phaseParents);
        return phaseParents;
    }

    private void fillBlankCells(Table datatable, int n, int rowSpan) {
        int i = 0;
        while (i < n) {
            Cell cell = new Cell("");
            cell.setBorder(12);
            cell.setRowspan(rowSpan);
            datatable.addCell(cell);
            ++i;
        }
    }

    private void fillOneCatalogReport(Table datatable, Font font, Font fnt_sub, int order, Catalog c) throws DocumentException {
        SimpleDateFormat MM_dd = new SimpleDateFormat("MM-dd");
        SimpleDateFormat HH_mm_ssSSS1 = new SimpleDateFormat("HH-mm-ss");
        DecimalFormat df = new DecimalFormat("##0.00");
        DecimalFormat mag_df = new DecimalFormat("0.0");
        DecimalFormat dis_df = new DecimalFormat("####.0");
        this.fillOneCell(datatable, "" + order, font, 1);
        Date sb = c.getOriginTime();
        int sb_ns = c.getOriginTimeFrac();
        Date sbc = new Date(sb.getTime() + (long)(sb_ns / 10));
        this.fillOneCell(datatable, MM_dd.format(sbc), font, 1);
        Phrase[] srcCell = this.formatSource(c, font, fnt_sub);
        this.fillSource(datatable, srcCell[0], 1);
        this.fillBlankCells(datatable, 16, 1);
        int n = 0;
        String pre_stn_name = "";
        List<Station> allSta = this.findAllStation();
        List<Phase> phs = this.getPhases(allSta, c);
        for (Phase p : phs) {
            String wsign;
            this.fillBlankCells(datatable, 2, 1);
            this.fillSource(datatable, srcCell[++n], 1);
            String stn_name = p.getChannelLocator().getStationCode();
            if (pre_stn_name.equals(stn_name)) {
                this.fillBlankCells(datatable, 2, 1);
            } else {
                Station sta = this.findStationBy(p.getChannelLocator().getNetCode(), p.getChannelLocator().getStationCode(), c.getOriginTime());
                String cname = null;
                if (sta.getStationInfo() == null) {
                    cname = sta.getBlockette050().getStation();
                } else {
                    cname = sta.getStationInfo().getStaCname();
                    if (cname == null) {
                        cname = sta.getBlockette050().getStation();
                    }
                }
                this.fillOneCell(datatable, cname, font, 1);
                String instrument = sta.getChannel().get(0).getBlockette052().getInstrument().getDescription();
                int idx = instrument.indexOf(47);
                if (idx != -1) {
                    instrument = instrument.substring(0, idx);
                }
                int len = instrument.length();
                instrument = instrument.substring(0, Math.min(6, len));
                this.fillOneCell(datatable, instrument, font, 1);
            }
            String phase_name = p.getPhaseName().toUpperCase();
            String clarity = p.getClarity();
            if (clarity == null) {
                clarity = "";
            }
            if ((wsign = p.getWsign()) == null) {
                wsign = "";
            }
            if (clarity.equals("(")) {
                this.fillOneCell(datatable, "(" + phase_name + ")", font, 1);
            } else {
                this.fillOneCell(datatable, String.valueOf(clarity) + phase_name + wsign, font, 1);
            }
            Date pt = p.getPhaseTime();
            int pt_ns = p.getPhaseTimeFrac();
            Date ptc = new Date(pt.getTime() + (long)Math.round((float)pt_ns / 10.0f));
            String dotStr = Integer.toString(Math.round((float)(ptc.getTime() % 1000L) / 100.0f));
            if (pt_ns < 9500) {
                this.fillOneCell(datatable, String.valueOf(HH_mm_ssSSS1.format(ptc)) + "." + dotStr, font, 1);
            } else {
                long v = ptc.getTime();
                long v1 = Math.round((double)v / 1000.0);
                long v2 = v1 * 1000L;
                this.fillOneCell(datatable, String.valueOf(HH_mm_ssSSS1.format(v2)) + ".0", font, 1);
            }
            if (!pre_stn_name.equals(stn_name)) {
                if (this.getLocStn(c) == 1) {
                    this.fillOneCell(datatable, "", font, 1);
                    double Ml = this.getMag(c, "ML");
                    if (Ml < -99998.0) {
                        this.fillOneCell(datatable, " ", font, 1);
                    } else {
                        this.fillOneCell(datatable, mag_df.format(Ml), font, 1);
                    }
                    double Md = this.getMag(c, "Md");
                    if (Md < -99998.0) {
                        this.fillOneCell(datatable, " ", font, 1);
                    } else {
                        this.fillOneCell(datatable, mag_df.format(Md), font, 1);
                    }
                    double Ms = this.getMag(c, "Ms");
                    if (Ms < -99998.0) {
                        this.fillOneCell(datatable, " ", font, 1);
                    } else {
                        this.fillOneCell(datatable, mag_df.format(Ms), font, 1);
                    }
                } else {
                    this.fillOneCell(datatable, dis_df.format(p.getDistance()), font, 1);
                    float ml = this.getMag(phs, p.getChannelLocator().getNetCode(), p.getChannelLocator().getStationCode(), "ML");
                    if (ml > -9999.0f) {
                        this.fillOneCell(datatable, mag_df.format(ml), font, 1);
                    } else {
                        this.fillOneCell(datatable, " ", font, 1);
                    }
                    float md = this.getMag(phs, p.getChannelLocator().getNetCode(), p.getChannelLocator().getStationCode(), "Md");
                    if (md > -9999.0f) {
                        this.fillOneCell(datatable, mag_df.format(md), font, 1);
                    } else {
                        this.fillOneCell(datatable, " ", font, 1);
                    }
                    float ms = this.getMag(phs, p.getChannelLocator().getNetCode(), p.getChannelLocator().getStationCode(), "Ms");
                    if (ms > -9999.0f) {
                        this.fillOneCell(datatable, mag_df.format(ms), font, 1);
                    } else {
                        this.fillOneCell(datatable, " ", font, 1);
                    }
                }
            } else {
                this.fillBlankCells(datatable, 4, 1);
            }
            String phase_type = p.getPhaseType();
            if (phase_type.equals("amp")) {
                if (phase_name.endsWith("N")) {
                    this.fillOneCell(datatable, df.format(p.getPeriod()), font, 1);
                    this.fillOneCell(datatable, df.format(p.getAmp()), font, 1);
                    this.fillBlankCells(datatable, 6, 1);
                } else if (phase_name.endsWith("E")) {
                    this.fillBlankCells(datatable, 2, 1);
                    this.fillOneCell(datatable, df.format(p.getPeriod()), font, 1);
                    this.fillOneCell(datatable, df.format(p.getAmp()), font, 1);
                    this.fillBlankCells(datatable, 4, 1);
                } else if (phase_name.endsWith("Z")) {
                    this.fillBlankCells(datatable, 4, 1);
                    this.fillOneCell(datatable, df.format(p.getPeriod()), font, 1);
                    this.fillOneCell(datatable, df.format(p.getAmp()), font, 1);
                    this.fillBlankCells(datatable, 2, 1);
                }
            } else {
                this.fillBlankCells(datatable, 8, 1);
            }
            pre_stn_name = stn_name;
        }
        int i = n + 1;
        while (i < srcCell.length) {
            this.fillBlankCells(datatable, 2, 1);
            this.fillSource(datatable, srcCell[i], 1);
            this.fillBlankCells(datatable, 16, 1);
            ++i;
        }
    }

    private void fillOneCell(Table datatable, String text, Font font, int rowSpan) throws DocumentException {
        Cell cell = new Cell((Element)new Phrase(text, font));
        cell.setBorder(12);
        cell.setVerticalAlignment(5);
        cell.setRowspan(rowSpan);
        datatable.addCell(cell);
    }

    private void fillSource(Table datatable, Phrase phrase, int rowSpan) throws DocumentException {
        Cell cell = new Cell((Element)phrase);
        cell.setBorder(12);
        cell.setVerticalAlignment(5);
        cell.setHorizontalAlignment(0);
        cell.setRowspan(rowSpan);
        datatable.addCell(cell);
    }

    private Table fillPdfReportFrame(Document document, String title, String subTitle, Font font, Font fnt_title, Font font_sub) throws DocumentException {
        HeaderFooter header = new HeaderFooter(new Phrase(title, fnt_title), false);
        header.setAlignment(1);
        header.setBorder(0);
        document.setHeader(header);
        HeaderFooter footer = new HeaderFooter(new Phrase("", font), true);
        footer.setAlignment(1);
        footer.setBorder(0);
        document.setFooter(footer);
        document.open();
        Table datatable = new Table(19);
        datatable.setPadding(0.0f);
        datatable.setCellsFitPage(true);
        datatable.setBorder(2);
        int[] headerwidths = new int[]{4, 5, 12, 6, 5, 4, 10, 6, 3, 3, 3, 5, 6, 5, 6, 4, 5, 4, 4};
        datatable.setWidths(headerwidths);
        datatable.setWidth(100.0f);
        Cell cell_y_m = new Cell((Element)new Phrase(subTitle, font));
        cell_y_m.setHorizontalAlignment(2);
        cell_y_m.setColspan(19);
        cell_y_m.setBorder(0);
        datatable.addCell(cell_y_m);
        datatable.setDefaultCellBorderWidth(2.0f);
        datatable.setDefaultHorizontalAlignment(1);
        datatable.setDefaultRowspan(3);
        datatable.addCell(new Phrase("\u5e8f    \u53f7", font));
        datatable.addCell(new Phrase("\u65e5    \u671f", font));
        datatable.addCell(new Phrase("\n\u5730\u9707\u53c2\u6570", font));
        datatable.addCell(new Phrase("\n\u53f0 \u7ad9", font));
        datatable.addCell(new Phrase("\n\u4eea\u5668", font));
        datatable.addCell(new Phrase("\n\u9707\u76f8", font));
        datatable.addCell(new Phrase("\u9707\u76f8\u5230\u65f6\nHH-mm-ss", font));
        datatable.setDefaultRowspan(3);
        datatable.addCell(new Phrase("\u9707 \u4e2d\n\u8ddd(km)", font));
        datatable.setDefaultRowspan(2);
        datatable.setDefaultColspan(3);
        datatable.addCell(new Phrase("\u9707\u7ea7", font));
        datatable.setDefaultRowspan(1);
        datatable.setDefaultColspan(6);
        datatable.addCell(new Phrase("\u5468\u671f\u4e0e\u5730\u52a8\u901f\u5ea6", font));
        datatable.setDefaultRowspan(2);
        datatable.setDefaultColspan(2);
        datatable.addCell(new Phrase("\u6301\u7eed\u65f6\u95f4\u4e0e\n\u8870\u51cf\u53cc\u632f\u5e45", font));
        datatable.setDefaultRowspan(1);
        datatable.setDefaultColspan(2);
        datatable.addCell(new Phrase("\u5357  \u5317", font));
        datatable.addCell(new Phrase("\u4e1c  \u897f", font));
        datatable.addCell(new Phrase("\u5782  \u76f4", font));
        datatable.setDefaultRowspan(1);
        datatable.setDefaultColspan(1);
        datatable.addCell(new Phrase("ML", font));
        datatable.addCell(new Phrase("Md", font));
        datatable.addCell(new Phrase("Ms", font));
        datatable.addCell(new Phrase("T(s)", font));
        datatable.addCell(new Phrase("A(um/s)", font));
        datatable.addCell(new Phrase("T(s)", font));
        datatable.addCell(new Phrase("A(um/s)", font));
        datatable.addCell(new Phrase("T(s)", font));
        datatable.addCell(new Phrase("A(um/s)", font));
        datatable.addCell(new Phrase("t(s)", font));
        datatable.addCell(new Phrase("D(mm)", font));
        datatable.endHeaders();
        datatable.setDefaultRowspan(1);
        datatable.setDefaultColspan(1);
        datatable.setDefaultCellBorderWidth(1.0f);
        return datatable;
    }

    private Phrase[] formatSource(Catalog c, Font fnt_norm, Font fnt_sub) {
        double depth;
        double ms;
        double md;
        double ml;
        double lon;
        SimpleDateFormat HH_mm_ssSSS = new SimpleDateFormat("HH:mm:ss");
        DecimalFormat mag_df = new DecimalFormat("0.0");
        DecimalFormat two_df = new DecimalFormat("00");
        DecimalFormat three_df = new DecimalFormat("000");
        int num = this.getLocPha(c) + 1;
        if (num < 6) {
            num = 6;
        }
        Phrase[] srcCell = new Phrase[num];
        int n = 0;
        Date sb = c.getOriginTime();
        int sb_ns = c.getOriginTimeFrac();
        Date sbc = new Date(sb.getTime() + (long)Math.round((float)sb_ns / 10.0f));
        String dotStr = Integer.toString(Math.round((float)(sbc.getTime() % 1000L) / 100.0f));
        if (sb_ns < 9500) {
            srcCell[n++] = new Phrase("O: " + HH_mm_ssSSS.format(sbc) + "." + dotStr, fnt_norm);
        } else {
            long v = sbc.getTime();
            long v1 = Math.round((double)v / 1000.0);
            long v2 = v1 * 1000L;
            srcCell[n++] = new Phrase("O: " + HH_mm_ssSSS.format(v2) + ".0", fnt_norm);
        }
        double lat = c.getLat();
        if (lat > -98.0) {
            String str_lat = "\u03c8";
            Phrase phrs_lat = new Phrase(str_lat, fnt_norm);
            if (lat > 0.0) {
                phrs_lat.add((Object)new Chunk("N", fnt_sub).setTextRise(-2.0f));
            } else {
                phrs_lat.add((Object)new Chunk("S", fnt_sub).setTextRise(-2.0f));
            }
            double lat_c = (double)((int)lat) + (double)Math.round((lat - (double)((int)lat)) * 60.0) / 60.0;
            phrs_lat.add((Object)new Chunk(" " + two_df.format((int)lat_c) + "\u00b0" + two_df.format(Math.round((lat_c - (double)((int)lat_c)) * 60.0)) + "\u2032", fnt_norm));
            srcCell[n++] = phrs_lat;
        }
        if ((lon = (double)c.getLon()) > -998.0) {
            String str_lon = "\u03bb";
            Phrase phrs_lon = new Phrase(str_lon, fnt_norm);
            if (lon > 0.0) {
                phrs_lon.add((Object)new Chunk("E", fnt_sub).setTextRise(-2.0f));
            } else {
                phrs_lon.add((Object)new Chunk("W", fnt_sub).setTextRise(-2.0f));
            }
            double lon_c = (double)((int)lon) + (double)Math.round((lon - (double)((int)lon)) * 60.0) / 60.0;
            phrs_lon.add((Object)new Chunk(" " + three_df.format((int)lon_c) + "\u00b0" + two_df.format(Math.round((lon_c - (double)((int)lon_c)) * 60.0)) + "\u2032", fnt_norm));
            srcCell[n++] = phrs_lon;
        }
        if ((ml = this.getMag(c, "ML")) > -99998.0) {
            Phrase phrs_Ml = new Phrase("M", fnt_norm);
            phrs_Ml.add((Object)new Chunk("L", fnt_sub).setTextRise(-2.0f));
            phrs_Ml.add((Object)new Chunk(": " + mag_df.format(ml), fnt_norm));
            srcCell[n++] = phrs_Ml;
        }
        if ((md = this.getMag(c, "Md")) > -99998.0) {
            Phrase phrs_Md = new Phrase("M", fnt_norm);
            phrs_Md.add((Object)new Chunk("d", fnt_sub).setTextRise(-2.0f));
            phrs_Md.add((Object)new Chunk(": " + mag_df.format(md), fnt_norm));
            srcCell[n++] = phrs_Md;
        }
        if ((ms = this.getMag(c, "Ms")) > -99998.0) {
            Phrase phrs_Ms = new Phrase("M", fnt_norm);
            phrs_Ms.add((Object)new Chunk("s", fnt_sub).setTextRise(-2.0f));
            phrs_Ms.add((Object)new Chunk(": " + mag_df.format(ms), fnt_norm));
            srcCell[n++] = phrs_Ms;
        }
        if ((depth = (double)c.getDepth()) > -99998.0) {
            srcCell[n++] = new Phrase("H: " + three_df.format(Math.round(depth)) + "(km)", fnt_norm);
        }
        if (c.getQloc() != null && Integer.parseInt(c.getQloc()) > -99998) {
            srcCell[n++] = new Phrase("\u7cbe\u5ea6: " + c.getQloc(), fnt_norm);
        }
        if (n >= num) {
            logger.warn(c.getCataName());
        }
        srcCell[n++] = new Phrase(c.getLocation(), fnt_norm);
        int i = n;
        while (i < num) {
            srcCell[i] = new Phrase("");
            ++i;
        }
        return srcCell;
    }

    private double getMag(Catalog c, String magType) {
        Set<Mag> mags = c.getMags();
        boolean found = false;
        Mag M = null;
        for (Mag m : mags) {
            if (!m.getMagType().getId().equalsIgnoreCase(magType)) continue;
            found = true;
            M = m;
            break;
        }
        if (found) {
            return M.getMagVal();
        }
        return -99999.0;
    }

    private int getLocStn(Catalog c) {
        int orig = c.getLocStn();
        if (orig == 0) {
            HashSet<String> hs = new HashSet<String>();
            for (Phase p : c.getPhases()) {
                hs.add(String.valueOf(p.getChannelLocator().getNetCode()) + "/" + p.getChannelLocator().getStationCode());
            }
            if (hs.size() != orig) {
                logger.warn("sanity check failt: the number of location station is incorrect for: " + c.getCataName());
            }
            c.setLocStn(hs.size());
        }
        return c.getLocStn();
    }

    private int getLocPha(Catalog c) {
        int orig = c.getLocPha();
        if (orig == 0) {
            int n = c.getPhases().size();
            if (orig != n) {
                logger.warn("sanity check failt: the number of location phase is incorrect for: " + c.getCataName());
            }
            c.setLocPha(n);
        }
        return c.getLocPha();
    }

    private Station findStationBy(String net, String sta, Date validDate) {
        List lst = this.em.createQuery("select s from Station s where s.blockette050.networkCode=:net and s.blockette050.station=:sta and ((s.blockette050.startTime < :validDate and s.blockette050.endTime > :validDate) or (s.blockette050.startTime < :validDate and s.blockette050.endTime is null)  )").setParameter("net", (Object)net).setParameter("sta", (Object)sta).setParameter("validDate", validDate, TemporalType.TIMESTAMP).getResultList();
        if (lst.size() == 0) {
            return null;
        }
        return (Station)lst.get(0);
    }

    @Override
    public List<Catalog> findCatalog(String where) {
        List lst = this.em.createQuery("select e from CatalogC e where " + where + " order by e.originTime, e.originTimeFrac").getResultList();
        return lst;
    }

    @Override
    public NetworkInfo findNetworkInfo() {
        NetworkInfo ninfo = (NetworkInfo)this.em.createQuery("select e from NetworkInfo e   order by e.id").getResultList().get(0);
        return ninfo;
    }

    @Override
    public Channel findChannelById(long id) {
        Channel chn = this.em.find(Channel.class, id);
        if (chn != null && chn.getResponse() != null) {
            chn.getResponse().size();
            chn.getChannelInfo();
        }
        return chn;
    }

    @Override
    public Station findStationById(long id) {
        Station sta = this.em.find(Station.class, id);
        if (sta != null) {
            sta.getChannel().size();
        }
        return sta;
    }

    @Override
    public Collection<Station> findStaListByNetwork(String netCode) {
        List staList = null;
        staList = netCode.trim().length() != 0 ? this.em.createQuery("select e from Station e where e.blockette050.networkCode = :netCode  order by e.id").setParameter("netCode", (Object)netCode).getResultList() : this.em.createQuery("select e from Station e   order by e.id").getResultList();
        return staList;
    }

    @Override
    public InstrDic findInstrDicById(long id) {
        InstrDic inst = this.em.find(InstrDic.class, id);
        if (inst != null) {
            inst.getChannel().size();
            for (Channel chan : inst.getChannel()) {
                chan.getResponse().size();
            }
        }
        return inst;
    }

    @Override
    public void write(String exportType, String where, String fileName) throws IOException {
        if (exportType.equals("catalogBasic")) {
            this.writeCatalogBasic(where, fileName);
        }
        if (exportType.equals("catalogFull")) {
            this.writeCatalogFull(where, fileName);
        }
        if (exportType.equals("bulletin")) {
            this.writeBulletin(where, fileName);
        }
        if (exportType.equals("bulletinPrint")) {
            this.writeBulletinPrint(where, fileName);
        }
    }

    public void writeCatalogBasic(String where, String fileName) throws IOException {
        this.wr = new PrintWriter(new FileWriter(fileName));
        this.writeVI0("Catalog_basic", 1.0f);
        NetworkInfo ni = this.findNetworkInfo();
        this.writeVI1(ni);
        this.writeHBO();
        List<Catalog> cataList = this.findCatalog(where);
        this.writeCatalogData(cataList, false);
        this.wr.close();
    }

    public void writeCatalogFull(String where, String fileName) throws IOException {
        this.wr = new PrintWriter(new FileWriter(fileName));
        this.writeVI0("Catalog_full", 1.0f);
        NetworkInfo ni = this.findNetworkInfo();
        this.writeVI1(ni);
        this.writeHBO();
        this.writeHEO();
        this.writeHMB();
        List<Catalog> cataList = this.findCatalog(where);
        this.writeCatalogData(cataList, true);
        this.wr.close();
    }

    public void writeBulletin(String where, String fileName) throws IOException {
        this.wr = new PrintWriter(new FileWriter(fileName));
        this.writeVI0("Bulletin", 1.0f);
        NetworkInfo ni = this.findNetworkInfo();
        this.writeVI1(ni);
        this.writeHSB();
        List staList = (List)this.findStaListByNetwork("");
        this.writeDSB(staList);
        this.writeHBO();
        this.writeHEO();
        this.writeHMB();
        this.writeHPB();
        List<Catalog> cataList = this.findCatalog(where);
        this.writeBulletin(cataList);
        logger.info("\u89c2\u6d4b\u62a5\u544a... \u751f\u6210");
        this.wr.close();
    }

    public void writeBulletinPrint(String where, String fileName) throws IOException {
        this.wr = new PrintWriter(new FileWriter(fileName));
        List<Catalog> cataList = this.findCatalog(where);
        this.writeBulletinPrint(cataList);
        logger.info("\u89c2\u6d4b\u62a5\u544a-\u6253\u5370\u7248... \u751f\u6210");
        this.wr.close();
    }

    public void writeBulletin(List<Catalog> lst) throws IOException {
        for (Catalog c : lst) {
            logger.info("cataId " + c.getId());
            this.wr.printf("%-3s", "DBO");
            this.wr.print(" ");
            this.wr.printf("%-2s", c.getNetCode());
            this.wr.print(" ");
            this.wr.printf("%-10s", this.dateFt.format(c.getOriginTime()));
            this.wr.print(" ");
            Date sb = c.getOriginTime();
            int sb_ns = c.getOriginTimeFrac();
            Date sbc = new Date(sb.getTime() + (long)Math.round((float)sb_ns / 10.0f));
            this.wr.printf("%-11s", this.disposeTime(sbc));
            this.wr.print(" ");
            this.wr.printf("%7s", this.disposeFloat(c.getLat(), 7, "0.000"));
            this.wr.print(" ");
            this.wr.printf("%8s", this.disposeFloat(c.getLon(), 9, "0.000"));
            this.wr.print(" ");
            this.wr.printf("%3s", this.disposeFloat(c.getDepth(), 3, "##"));
            this.wr.print(" ");
            this.wr.printf("%5s", c.getMSource());
            this.wr.print(" ");
            this.wr.printf("%4s", this.disposeFloat(ReportServiceBean.Ms2ML(c.getM()), 4, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%3s", this.disposeFloat(c.getRms(), 3, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%-1s", c.getQloc());
            this.wr.print(" ");
            this.wr.printf("%-3s", c.getSumStn());
            this.wr.print(" ");
            this.wr.printf("%-3s", c.getLocStn());
            this.wr.print(" ");
            String eqTypeCode = EqType.getName(c.getEqType());
            this.wr.printf("%-2s", eqTypeCode);
            this.wr.print(" ");
            this.wr.printf("%2s", c.getEpicId());
            this.wr.print(" ");
            this.wr.printf("%2s", c.getSourceId());
            this.wr.print(" ");
            this.wr.printf("%-16s", c.getLocation());
            this.wr.println();
            this.writeDEO(c);
            List<Station> allSta = this.findAllStation();
            List<Phase> phases = this.getPhases(allSta, c);
            this.writePhases(phases);
        }
    }

    private void writeCatalogData(List<Catalog> lst, boolean more) {
        for (Catalog c : lst) {
            logger.info("cataId " + c.getId());
            this.wr.printf("%-3s", "DBO");
            this.wr.print(" ");
            this.wr.printf("%-2s", c.getNetCode());
            this.wr.print(" ");
            this.wr.printf("%-10s", this.dateFt.format(c.getOriginTime()));
            this.wr.print(" ");
            Date sb = c.getOriginTime();
            int sb_ns = c.getOriginTimeFrac();
            Date sbc = new Date(sb.getTime() + (long)Math.round((float)sb_ns / 10.0f));
            this.wr.printf("%-11s", this.disposeTime(sbc));
            this.wr.print(" ");
            this.wr.printf("%7s", this.disposeFloat(c.getLat(), 7, "0.000"));
            this.wr.print(" ");
            this.wr.printf("%8s", this.disposeFloat(c.getLon(), 9, "0.000"));
            this.wr.print(" ");
            this.wr.printf("%3s", this.disposeFloat(c.getDepth(), 3, "##"));
            this.wr.print(" ");
            this.wr.printf("%5s", c.getMSource());
            this.wr.print(" ");
            this.wr.printf("%4s", this.disposeFloat(ReportServiceBean.Ms2ML(c.getM()), 4, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%4s", this.disposeFloat(c.getRms(), 4, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%-1s", c.getQloc());
            this.wr.print(" ");
            this.wr.printf("%-3s", c.getSumStn());
            this.wr.print(" ");
            this.wr.printf("%-3s", c.getLocStn());
            this.wr.print(" ");
            String eqTypeCode = EqType.getName(c.getEqType());
            this.wr.printf("%-2s", eqTypeCode);
            this.wr.print(" ");
            this.wr.printf("%2s", c.getEpicId());
            this.wr.print(" ");
            this.wr.printf("%2s", c.getSourceId());
            this.wr.print(" ");
            this.wr.printf("%-16s", c.getLocation());
            this.wr.println();
            if (!more) continue;
            this.writeDEO(c);
        }
    }

    private void writeDEO(Catalog c) {
        this.wr.printf("%-3s", "DEO");
        this.wr.print(" ");
        if (c.getId().contains(".A.")) {
            this.wr.printf("%-1s", "A");
        }
        if (c.getId().contains(".C.")) {
            this.wr.printf("%-1s", "C");
        }
        if (c.getId().contains(".I.")) {
            this.wr.printf("%-1s", "I");
        }
        if (c.getId().contains(".R.")) {
            this.wr.printf("%-1s", "R");
        }
        this.wr.print(" ");
        this.wr.printf("%-20s", c.getEventInfo().getEventId());
        this.wr.print(" ");
        this.wr.printf("%-20s", this.disposeNULL(c.getSequenName(), 20));
        this.wr.print(" ");
        this.wr.printf("%-1s", c.getDepfixFlag());
        this.wr.print(" ");
        this.wr.printf("%4s", this.disposeFloat(c.getM(), 4, "0.0"));
        this.wr.print(" ");
        this.wr.printf("%-5s", c.getMSource());
        this.wr.print(" ");
        this.wr.printf("%5s", this.disposeFloat(c.getSpmin(), 5, "0.0"));
        this.wr.print(" ");
        this.wr.printf("%5s", this.disposeFloat(c.getDmin(), 5, "0.0"));
        this.wr.print(" ");
        this.wr.printf("%5s", this.disposeFloat(c.getGapAzi(), 5, "0.0"));
        this.wr.print(" ");
        this.wr.printf("%5s", this.disposeFloat(c.getErh(), 5, "0.0"));
        this.wr.print(" ");
        this.wr.printf("%5s", this.disposeFloat(c.getErz(), 5, "0.0"));
        this.wr.print(" ");
        this.wr.printf("%-1s", c.getQnet());
        this.wr.print(" ");
        this.wr.printf("%-1s", c.getQcom());
        this.wr.print(" ");
        this.wr.printf("%3s", this.disposeFloat(c.getSumPha(), 3, "0"));
        this.wr.print(" ");
        this.wr.printf("%3s", c.getLocPha());
        this.wr.print(" ");
        this.wr.printf("%4s", c.getFeNum());
        this.wr.print(" ");
        this.wr.printf("%-64s", this.disposeNULL(c.getFeSname(), 64));
        this.wr.println();
        for (Mag m : c.getMags()) {
            this.wr.printf("%-3s", "DMB");
            this.wr.print(" ");
            this.wr.printf("%-5s", m.getMagType().getId());
            this.wr.print(" ");
            this.wr.printf("%4s", this.disposeFloat(m.getMagVal(), 4, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%5s", this.disposeFloat(m.getMagGap(), 5, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%3s", m.getMagStn());
            this.wr.print(" ");
            this.wr.printf("%4s", this.disposeFloat(m.getMagError().floatValue(), 4, "0.00"));
            this.wr.println();
        }
    }

    private void writeDSB(List<Station> staList) {
        int i = 1;
        for (Station s : staList) {
            logger.info("seq" + i + " sta=" + s.getBlockette050().getStation());
            this.wr.printf("%-3s", "DSB");
            this.wr.print(" ");
            this.wr.printf("%-2s", s.getBlockette050().getNetworkCode());
            this.wr.print(" ");
            this.wr.printf("%-5s", s.getBlockette050().getStation());
            this.wr.print(" ");
            this.wr.printf("%-10s", s.getBlockette050().getSiteName());
            this.wr.print(" ");
            this.wr.printf("%-1s", s.getStationInfo().getBuildType());
            this.wr.print(" ");
            this.wr.printf("%-1s", s.getChannel().size());
            this.wr.print(" ");
            this.wr.printf("%8.4s", this.disposeDouble(s.getBlockette050().getLatitude(), 8, "0.0000"));
            this.wr.print(" ");
            this.wr.printf("%9.4s", this.disposeDouble(s.getBlockette050().getLongitude(), 9, "0.0000"));
            this.wr.print(" ");
            this.wr.printf("%4s", this.disposeDouble(s.getBlockette050().getElevation(), 9, "##"));
            this.wr.print(" ");
            this.wr.printf("%4s", this.disposeDouble(s.getStationInfo().getLocaldepth(), 9, "##"));
            this.wr.print(" ");
            String instru = "";
            if (s.getStationInfo().getInstrumentId() != 0) {
                instru = this.findInstrDicById(s.getStationInfo().getInstrumentId()).getInstrModel();
            }
            this.wr.printf("%-12s", instru);
            this.wr.print(" ");
            String dat = "";
            if (s.getStationInfo().getInstrumentId() != 0) {
                dat = this.findInstrDicById(s.getStationInfo().getInstrumentId()).getInstrModel();
            }
            this.wr.printf("%-12s", dat);
            this.wr.print(" ");
            this.wr.printf("%-14s", s.getStationInfo().getRockType());
            this.wr.print(" ");
            this.wr.printf("%10s", this.disposeDoubleSen(this.nSensitivity(s), 10, "0.0000E00"));
            this.wr.print(" ");
            this.wr.printf("%10s", this.disposeDoubleSen(this.eSensitivity(s), 10, "0.0000E00"));
            this.wr.print(" ");
            this.wr.printf("%10s", this.disposeDoubleSen(this.zSensitivity(s), 10, "0.0000E00"));
            this.wr.println();
            ++i;
        }
    }

    private void writePhases(List<Phase> phases) {
        for (Phase p : phases) {
            this.wr.printf("%-3s", "DBP");
            this.wr.print(" ");
            this.wr.printf("%-26s", p.getCatalog().getId());
            this.wr.print(" ");
            this.wr.printf("%-2s", p.getChannelLocator().getNetCode());
            this.wr.print(" ");
            this.wr.printf("%-5s", p.getChannelLocator().getStationCode());
            this.wr.print(" ");
            this.wr.printf("%-2s", p.getChannelLocator().getLocId());
            this.wr.print(" ");
            this.wr.printf("%-6s", p.getChannelLocator().getChanCode());
            this.wr.print(" ");
            this.wr.printf("%-2s", p.getRecType());
            this.wr.print(" ");
            this.wr.printf("%-7s", p.getPhaseName());
            this.wr.print(" ");
            this.wr.printf("%-5s", p.getPhaseType());
            this.wr.print(" ");
            this.wr.printf("%-10s", this.dateFt.format(p.getPhaseTime()));
            this.wr.print(" ");
            this.wr.printf("%-11s", this.timeFt.format(p.getPhaseTime()));
            this.wr.print(" ");
            this.wr.printf("%7s", this.disposeFloat(p.getAmp(), 7, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%-4s", p.getAmpType());
            this.wr.print(" ");
            this.wr.printf("%5s", this.disposeFloat(p.getPeriod(), 5, "0.000"));
            this.wr.print(" ");
            this.wr.printf("%3s", this.disposeFloat(p.getWeight(), 3, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%-1s", p.getClarity());
            this.wr.print(" ");
            this.wr.printf("%-1s", p.getWsign());
            this.wr.print(" ");
            this.wr.printf("%5s", this.disposeFloat(p.getResi(), 5, "0.00"));
            this.wr.print(" ");
            if (p.getMagType() != null) {
                this.wr.printf("%-4s", p.getMagType().getId());
            } else {
                this.wr.print("       ");
            }
            this.wr.print(" ");
            this.wr.printf("%4s", this.disposeFloat(p.getMagVal(), 4, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%6s", this.disposeFloat(p.getDistance(), 6, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%6s", this.disposeFloat(p.getAzimuth(), 6, "0.0"));
            this.wr.println();
        }
    }

    private void writeBulletinPrint(List<Catalog> lst) throws IOException {
        for (Catalog c : lst) {
            this.writeBulletinCatalogPart(c);
        }
        this.wr.println();
        for (Catalog c : lst) {
            logger.info("cataId " + c.getId());
            this.writeBulletinCatalogPart(c);
            List<PhaseParent> phaseParents = this.getPhaseParentsAndChildren(c);
            this.writePhaseParentsAndChildren(phaseParents);
        }
    }

    private void writePhaseParentsAndChildren(List<PhaseParent> phaseParents) {
        for (PhaseParent parent : phaseParents) {
            int size = parent.getPhaseChildren().size();
            int count = 1;
            for (PhaseChild child : parent.getPhaseChildren()) {
                Phase p = child.getPhase();
                if (count == 1) {
                    this.wr.printf("%-2s", p.getChannelLocator().getNetCode());
                } else {
                    this.wr.print("  ");
                }
                this.wr.print(" ");
                if (count == 1) {
                    this.wr.printf("%-5s", p.getChannelLocator().getStationCode());
                } else {
                    this.wr.print("     ");
                }
                this.wr.print(" ");
                this.wr.printf("%-3s", p.getChannelLocator().getChanCode());
                this.wr.print(" ");
                this.wr.printf("%-1s", p.getClarity());
                this.wr.print(" ");
                this.wr.printf("%-1s", p.getWsign());
                this.wr.print(" ");
                this.wr.printf("%-7s", p.getPhaseName());
                this.wr.print(" ");
                this.wr.printf("%3s", this.disposeFloat_WeightAndResi(p.getWeight(), 3, "0.0"));
                this.wr.print(" ");
                this.wr.printf("%-2s", p.getRecType());
                this.wr.print(" ");
                Date sb = p.getPhaseTime();
                int sb_ns = p.getPhaseTimeFrac();
                Date sbc = new Date(sb.getTime() + (long)Math.round((float)sb_ns / 100.0f));
                this.wr.printf("%-11s", this.disposeTime(sbc));
                this.wr.print(" ");
                this.wr.printf("%6s", this.disposeFloat_WeightAndResi(p.getResi(), 6, "0.00"));
                this.wr.print(" ");
                if (count == 1) {
                    this.wr.printf("%6s", this.disposeFloat(p.getDistance(), 6, "0.0"));
                } else {
                    this.wr.print("      ");
                }
                this.wr.print(" ");
                if (count == 1) {
                    this.wr.printf("%5s", this.disposeFloat(p.getAzimuth(), 5, "0.0"));
                } else {
                    this.wr.print("     ");
                }
                this.wr.print(" ");
                if ((double)(p.getAmp() * 1000.0f) > 9999999.9) {
                    this.wr.printf("%9s", this.disposeFloatAmp(p.getAmp() * 1000.0f, "0.00000E0"));
                } else {
                    this.wr.printf("%9s", this.disposeFloat(p.getAmp() * 1000.0f, 9, "0.0"));
                }
                this.wr.print(" ");
                this.wr.printf("%6s", this.disposeFloat(p.getPeriod(), 6, "0.00"));
                this.wr.print(" ");
                if (count == size) {
                    if (p.getMagType() != null) {
                        this.wr.printf("%-3s", p.getMagType().getId());
                    } else {
                        this.wr.print("   ");
                    }
                } else {
                    this.wr.print("   ");
                }
                this.wr.print(" ");
                if (count == size) {
                    this.wr.printf("%4s", this.disposeFloat(p.getMagVal(), 4, "0.0"));
                } else {
                    this.wr.print("    ");
                }
                this.wr.println();
                ++count;
            }
        }
    }

    public void writeBulletinCatalogPart(Catalog c) {
        this.wr.printf("%2s", c.getNetCode());
        this.wr.print(" ");
        this.wr.printf("%-10s", this.dateFt.format(c.getOriginTime()));
        this.wr.print(" ");
        Date sb = c.getOriginTime();
        int sb_ns = c.getOriginTimeFrac();
        Date sbc = new Date(sb.getTime() + (long)Math.round((float)sb_ns / 10.0f));
        this.wr.printf("%-10s", this.disposeTime10(sbc));
        this.wr.print(" ");
        if (c.getLocStn() == 1) {
            this.wr.print("       ");
        } else {
            this.wr.printf("%7s", this.disposeFloat(c.getLat(), 7, "0.000"));
        }
        this.wr.print(" ");
        if (c.getLocStn() == 1) {
            this.wr.print("        ");
        } else {
            this.wr.printf("%8s", this.disposeFloat(c.getLon(), 9, "0.000"));
        }
        this.wr.print(" ");
        if (c.getLocStn() == 1) {
            this.wr.print("   ");
        } else {
            this.wr.printf("%3s", this.disposeFloat(c.getDepth(), 3, "##"));
        }
        this.wr.print(" ");
        this.wr.printf("%4s", this.disposeFloat(ReportServiceBean.Ms2ML(c.getM()), 4, "0.0"));
        this.wr.print(" ");
        if (c.getMSource().equals("ML")) {
            this.wr.print("   ");
            this.wr.print(" ");
        } else {
            this.wr.printf("%3s", this.disposeFloat(c.getM(), 4, "0.0"));
            this.wr.print(" ");
        }
        if (c.getLocStn() == 1) {
            this.wr.print(" ");
        } else {
            this.wr.printf("%-1s", c.getQloc());
        }
        this.wr.print(" ");
        if (c.getLocStn() == 1) {
            this.wr.print("   ");
        } else {
            this.wr.printf("%3s", c.getLocStn());
        }
        this.wr.print(" ");
        String eqTypeCode = EqType.getName(c.getEqType());
        this.wr.printf("%-2s", eqTypeCode);
        this.wr.print(" ");
        if (c.getLocStn() == 1) {
            this.wr.print("  ");
        } else {
            this.wr.printf("%2s", c.getEpicId());
        }
        this.wr.print(" ");
        this.wr.printf("%-1s", c.getLocation());
        this.wr.println();
    }

    private void writePhasesPrint(List<Phase> phases) {
        for (Phase p : phases) {
            this.wr.printf("%-2s", p.getChannelLocator().getNetCode());
            this.wr.print(" ");
            this.wr.printf("%-5s", p.getChannelLocator().getStationCode());
            this.wr.print(" ");
            this.wr.printf("%-3s", p.getChannelLocator().getChanCode());
            this.wr.print(" ");
            this.wr.printf("%-1s", p.getClarity());
            this.wr.print(" ");
            this.wr.printf("%-1s", p.getWsign());
            this.wr.print(" ");
            this.wr.printf("%-7s", p.getPhaseName());
            this.wr.print(" ");
            this.wr.printf("%3s", this.disposeFloat(p.getWeight(), 3, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%-2s", p.getRecType());
            this.wr.print(" ");
            Date sb = p.getPhaseTime();
            int sb_ns = p.getPhaseTimeFrac();
            Date sbc = new Date(sb.getTime() + (long)Math.round((float)sb_ns / 10.0f));
            this.wr.printf("%-11s", this.disposeTime(sbc));
            this.wr.print(" ");
            this.wr.printf("%6s", this.disposeFloat(p.getResi(), 6, "0.00"));
            this.wr.print(" ");
            this.wr.printf("%6s", this.disposeFloat(p.getDistance(), 6, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%5s", this.disposeFloat(p.getAzimuth(), 5, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%9s", this.disposeFloat(p.getAmp(), 9, "0.0"));
            this.wr.print(" ");
            this.wr.printf("%6s", this.disposeFloat(p.getPeriod(), 6, "0.00"));
            this.wr.print(" ");
            if (p.getMagType() != null) {
                this.wr.printf("%-3s", p.getMagType().getId());
            } else {
                this.wr.print("   ");
            }
            this.wr.print(" ");
            this.wr.printf("%4s", this.disposeFloat(p.getMagVal(), 4, "0.0"));
            this.wr.println();
        }
    }

    public void writeVI0(String type, float edition) throws IOException {
        this.wr.printf("%-3s %-12s %-14s %-7s %-3.1f", "VI0", "Volume_type", type, "CSF_Ver", Float.valueOf(edition));
        this.wr.println();
    }

    public void writeVI1(NetworkInfo netInfo) throws IOException {
        String onDate = null;
        String offDate = null;
        String remark = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SS");
        onDate = netInfo.getOndate() == null ? df.format(new Date()) : df.format(netInfo.getOndate());
        offDate = netInfo.getOffdate() == null ? df.format(new Date()) : df.format(netInfo.getOffdate());
        if (netInfo.getRemark() == null) {
            remark = "  ";
        }
        this.wr.printf("%-3s %-8s %-2s %-8s %-30s %-20s %-20s %-12s", "VI1", "Net_code", netInfo.getNetSname(), "Net_cname", netInfo.getNetCname(), onDate, offDate, remark);
        this.wr.println();
    }

    public void writeHBO() throws IOException {
        this.wr.print("HBO Net date O_time Epi_lat Epi_lon Epi_depth Mag_name Mag_value Rms Qloc Sum_stn Loc_stn Eq_type Epic_id Source_id Location_cname");
        this.wr.println();
    }

    public void writeHEO() throws IOException {
        this.wr.print("HEO Auto_flag Event_id Sequen_name Depfix_flag M M_source SPmin Dmin Gap_azi Erh Erz Qnet Qcom Sum_pha Loc_pha FE_num FE_sname");
        this.wr.println();
    }

    public void writeHMB() throws IOException {
        this.wr.print("HMB Mag_name Mag_val Mag_gap Mag_stn Mag_error");
        this.wr.println();
    }

    public void writeHPB() throws IOException {
        this.wr.print("HPB Net_code Sta_code Chn_code Clarity Wsign Phase_name Weight Rec_type Phase_time Phase_time Resi Distance Azi Amp Period Mag_name Mag_val");
        this.wr.println();
    }

    public void writeHSB() throws IOException {
        this.wr.print("HSB Net_code Sta_code Sta_cname Sta_type Chan_num Sta_lat Sta_lon Sta_elev Local_depth sensor Datarecord Rock_type Sensi-NS Sensi-EW Sensi-UD");
        this.wr.println();
    }

    public String wword(String str, int len) {
        String tmp = null;
        if (str.length() >= len) {
            tmp = String.valueOf(str.substring(0, len)) + this.blank;
        } else if (str.length() < len) {
            int i = 0;
            while (i < len - str.length()) {
                tmp = String.valueOf(tmp) + this.blank;
                ++i;
            }
            tmp = String.valueOf(str) + this.blank;
            tmp = String.valueOf(tmp) + this.blank;
        }
        return tmp;
    }

    public static float Ml2Ms(float ml) {
        return 1.13f * ml - 1.08f;
    }

    public static float Ms2ML(float ms) {
        return (ms + 1.08f) / 1.13f;
    }

    public String disposeFloatAmp(float v, String format) {
        DecimalFormat df = new DecimalFormat(format);
        String s = "";
        if (v > 0.0f) {
            s = df.format(v);
            s = String.valueOf(s.substring(0, s.lastIndexOf("E"))) + "E" + s.substring(s.lastIndexOf("E") + 1, s.length());
        }
        return s;
    }

    public String disposeFloat_WeightAndResi(float v, int width, String format) {
        DecimalFormat df = new DecimalFormat(format);
        String s = "";
        if (v < -9999.0f) {
            int i = 1;
            while (i < width) {
                s = String.valueOf(s) + " ";
                ++i;
            }
        } else {
            s = df.format(v);
        }
        return s;
    }

    public String disposeFloat(float v, int width, String format) {
        DecimalFormat df = new DecimalFormat(format);
        String s = "";
        if (v < -9999.0f || (double)v == 0.0) {
            int i = 1;
            while (i < width) {
                s = String.valueOf(s) + " ";
                ++i;
            }
        } else {
            s = df.format(v);
        }
        return s;
    }

    private Object disposeNULL(String sequenName, int width) {
        String s = "";
        if (sequenName == null) {
            int i = 1;
            while (i < width) {
                s = String.valueOf(s) + " ";
                ++i;
            }
        } else {
            s = sequenName;
        }
        return s;
    }

    public String disposeDoubleSen(double v, int width, String format) {
        DecimalFormat df = new DecimalFormat(format);
        String s = "";
        if (v < -9999.0 || v == 0.0) {
            int i = 1;
            while (i < width) {
                s = String.valueOf(s) + " ";
                ++i;
            }
        } else {
            s = df.format(v);
            s = String.valueOf(s.substring(0, s.lastIndexOf("E"))) + "E+" + s.substring(s.lastIndexOf("E") + 1, s.length());
        }
        return s;
    }

    public String disposeDouble(double v, int width, String format) {
        DecimalFormat df = new DecimalFormat(format);
        String s = "";
        if (v < -9999.0 || v == 0.0) {
            int i = 1;
            while (i < width) {
                s = String.valueOf(s) + " ";
                ++i;
            }
        } else {
            s = df.format(v);
        }
        return s;
    }

    public String disposeTime10(Date time) {
        String time0 = this.timeFt.format(time);
        String time1 = time0.substring(0, time0.lastIndexOf("."));
        String time2 = time0.substring(time0.lastIndexOf(".") + 1, time0.length());
        String newTime2 = Integer.toString((int)Math.round((double)Integer.parseInt(time2) / 100.0));
        String newTime0 = null;
        newTime0 = newTime2.length() == 1 ? String.valueOf(time1) + "." + newTime2 : String.valueOf(this.timeFt10.format(new Date(time.getTime() + 500L))) + ".0";
        return newTime0;
    }

    public String disposeTime(Date time) {
        String time0 = this.timeFt.format(time);
        String time1 = time0.substring(0, time0.lastIndexOf("."));
        String time2 = time0.substring(time0.lastIndexOf(".") + 1, time0.length());
        String newTime2 = Integer.toString((int)Math.round((double)Integer.parseInt(time2) / 10.0));
        String newTime0 = null;
        newTime0 = newTime2.length() == 2 ? String.valueOf(time1) + "." + newTime2 : String.valueOf(time1) + "." + time2;
        return newTime0;
    }

    public String disposeTimeOld(Date time, int Frac) {
        Date sbc = new Date(time.getTime() + (long)Math.round((float)Frac / 10.0f));
        String time0 = this.timeFt.format(sbc);
        String time1 = time0.substring(0, time0.lastIndexOf("."));
        String time2 = time0.substring(time0.lastIndexOf(".") + 1, time0.length());
        String newTime2 = Integer.toString(Math.round((float)Integer.parseInt(time2) / 10.0f));
        String newTime0 = null;
        newTime0 = newTime2.length() == 2 ? String.valueOf(time1) + "." + newTime2 : String.valueOf(time1) + "." + time2;
        return newTime0;
    }

    public double nSensitivity(Station s) {
        Channel channel;
        List<Response> responseList;
        Response r;
        long id = 0L;
        id = s.getId();
        Station s1 = this.findStationById(id);
        double sensitivity = 0.0;
        if (s1.getChannel().size() >= 3 && (r = (responseList = (channel = this.findChannelById(id = s1.getChannel().get(0).getId())).getResponse()).get(0)).getBlockette058() != null) {
            sensitivity = r.getBlockette058().getSensitivity();
        }
        return sensitivity;
    }

    public double eSensitivity(Station s) {
        Channel channel;
        List<Response> responseList;
        Response r;
        long id = 0L;
        id = s.getId();
        Station s1 = this.findStationById(id);
        double sensitivity = 0.0;
        if (s1.getChannel().size() >= 3 && (r = (responseList = (channel = this.findChannelById(id = s1.getChannel().get(1).getId())).getResponse()).get(0)).getBlockette058() != null) {
            sensitivity = r.getBlockette058().getSensitivity();
        }
        return sensitivity;
    }

    public double zSensitivity(Station s) {
        Channel channel;
        List<Response> responseList;
        Response r;
        long id = 0L;
        id = s.getId();
        Station s1 = this.findStationById(id);
        double sensitivity = 0.0;
        if (s1.getChannel().size() >= 3 && (r = (responseList = (channel = this.findChannelById(id = s1.getChannel().get(2).getId())).getResponse()).get(0)).getBlockette058() != null) {
            sensitivity = r.getBlockette058().getSensitivity();
        }
        return sensitivity;
    }
}

