/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.Phase;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;

public class PhaseChild
implements Comparable {
    private Phase phase;
    private String phaseName;
    private Date phaseTime;
    private int phaseTimeFrac;
    private Date phaseFullTime;

    public PhaseChild(Phase phase) {
        this.phase = phase;
    }

    public PhaseChild(String phaseName, Date phaseTime, int phaseTimeFrac, Phase phase) {
        this.phaseName = phaseName;
        this.phaseTime = phaseTime;
        this.phaseTimeFrac = phaseTimeFrac;
        this.phase = phase;
    }

    public PhaseChild(String phaseName, Date phaseTime, int phaseTimeFrac) {
        this.phaseName = phaseName;
        this.phaseTime = phaseTime;
        this.phaseTimeFrac = phaseTimeFrac;
    }

    public Phase getPhase() {
        return this.phase;
    }

    public void setPhase(Phase phase) {
        this.phase = phase;
    }

    public String getPhaseName() {
        if (this.phase != null) {
            this.phaseName = this.phase.getPhaseName();
        }
        return this.phaseName;
    }

    public void setPhaseName(String phaseName) {
        this.phaseName = phaseName;
    }

    public Date getPhaseTime() {
        if (this.phase != null) {
            this.phaseTime = this.phase.getPhaseTime();
        }
        return this.phaseTime;
    }

    public void setPhaseTime(Date phaseTime) {
        this.phaseTime = phaseTime;
    }

    public int getPhaseTimeFrac() {
        if (this.phase != null) {
            this.phaseTimeFrac = this.phase.getPhaseTimeFrac();
        }
        return this.phaseTimeFrac;
    }

    public void setPhaseTimeFrac(int phaseTimeFrac) {
        this.phaseTimeFrac = phaseTimeFrac;
    }

    public Date getPhaseFullTime() {
        Date date1;
        this.phaseFullTime = date1 = new Date(this.phaseTime.getTime() / 1000L * 1000L + (long)((int)Math.round((double)this.phaseTimeFrac / 10.0)));
        return this.phaseFullTime;
    }

    public int compareTo(Object o) {
        Date date1 = new Date(this.getPhaseTime().getTime() / 1000L * 1000L + (long)((int)Math.round((double)this.getPhaseTimeFrac() / 10.0)));
        Date date2 = new Date(((PhaseChild)o).getPhaseTime().getTime() / 1000L * 1000L + (long)((int)Math.round((double)((PhaseChild)o).getPhaseTimeFrac() / 10.0)));
        return (int)(date1.getTime() - date2.getTime());
    }

    public static void main(String[] args) throws ParseException {
        SimpleDateFormat timeFt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat fullTimeFt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        Object[] phaseChildren = new PhaseChild[]{new PhaseChild("Pg", timeFt.parse("2009-01-01 00:02:23"), 1457), new PhaseChild("Sg", timeFt.parse("2009-01-01 00:02:44"), 3483), new PhaseChild("SMN", timeFt.parse("2009-01-01 00:02:45"), 2353), new PhaseChild("SME", timeFt.parse("2009-01-01 00:02:46"), 234)};
        Arrays.sort(phaseChildren);
        int i = 0;
        while (i < phaseChildren.length) {
            Object phaseChild = phaseChildren[i];
            System.out.println(String.valueOf(((PhaseChild)phaseChild).getPhaseName()) + " " + fullTimeFt.format(((PhaseChild)phaseChild).getPhaseFullTime()));
            ++i;
        }
        System.out.println("**** collection sort ****");
        ArrayList<PhaseChild> phaseChildren1 = new ArrayList<PhaseChild>();
        phaseChildren1.add(new PhaseChild("Pg", timeFt.parse("2009-01-01 00:02:23"), 1457));
        phaseChildren1.add(new PhaseChild("SMN", timeFt.parse("2009-01-01 00:02:45"), 2353));
        phaseChildren1.add(new PhaseChild("SME", timeFt.parse("2009-01-01 00:02:46"), 234));
        phaseChildren1.add(new PhaseChild("Sg", timeFt.parse("2009-01-01 00:02:44"), 3483));
        Collections.sort(phaseChildren1);
        int i2 = 0;
        while (i2 < phaseChildren.length) {
            Object phaseChild = phaseChildren[i2];
            System.out.println(String.valueOf(((PhaseChild)phaseChild).getPhaseName()) + " " + fullTimeFt.format(((PhaseChild)phaseChild).getPhaseFullTime()));
            ++i2;
        }
    }
}

