/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.CaliParam;
import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.LogCenter;
import cn.org.gddsn.jopens.entity.LogStation;
import cn.org.gddsn.jopens.entity.StationInfo;
import cn.org.gddsn.jopens.entity.mon.SSSClient;
import cn.org.gddsn.jopens.service.MonitorService;
import java.util.Collection;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateless
@Local(value={MonitorService.class})
@Remote(value={MonitorService.class})
public class MonitorServiceBean
implements MonitorService {
    static Logger logger = Logger.getLogger(MonitorServiceBean.class);
    @PersistenceContext
    private EntityManager manager;

    @Override
    public SSSClient findSSSClientById(long id) {
        return this.manager.find(SSSClient.class, id);
    }

    @Override
    public void updateSSSClient(SSSClient sc) {
        this.manager.merge(sc);
    }

    @Override
    public void removeSSSClient(long id) {
        SSSClient sc = this.manager.find(SSSClient.class, id);
        if (sc != null) {
            this.manager.remove(sc);
        }
    }

    @Override
    public void addSSSClient(SSSClient sc) {
        this.manager.persist(sc);
    }

    @Override
    public Collection<SSSClient> findAllSSSClient() {
        return this.manager.createQuery("select e from SSSClient e").getResultList();
    }

    @Override
    public Collection<LogStation> findAllLogStation() {
        return this.manager.createQuery("select e from LogStation e ORDER BY e.startTime DESC").getResultList();
    }

    @Override
    public LogStation findLogStationById(long id) {
        return this.manager.find(LogStation.class, id);
    }

    @Override
    public void addLogStation(LogStation stationLog) {
        this.manager.persist(stationLog);
    }

    @Override
    public void removeLogStation(long id) {
        this.manager.remove(this.findLogStationById(id));
    }

    @Override
    public long updateLogStation(LogStation stationLog) {
        LogStation log = this.manager.merge(stationLog);
        return log.getId();
    }

    @Override
    public Collection<LogCenter> findAllLogCenter() {
        return this.manager.createQuery("select e from LogCenter e ORDER BY e.startTime DESC").getResultList();
    }

    @Override
    public LogCenter findLogCenterById(long id) {
        return this.manager.find(LogCenter.class, id);
    }

    @Override
    public void addLogCenter(LogCenter logCenter) {
        this.manager.persist(logCenter);
    }

    @Override
    public void removeLogCenter(long id) {
        this.manager.remove(this.findLogCenterById(id));
    }

    @Override
    public long updateLogCenter(LogCenter logCenter) {
        LogCenter log = this.manager.merge(logCenter);
        return log.getId();
    }

    @Override
    public List<LogCenter> findAllLogCenterByWhere(String where) {
        return this.manager.createQuery("select e from LogCenter e  where " + where + " order by e.startTime").getResultList();
    }

    @Override
    public List<LogStation> findAllLogStationByWhere(String where) {
        return this.manager.createQuery("select e from LogStation e  where " + where + " order by e.startTime").getResultList();
    }

    @Override
    public List<Catalog> findAllCatalogIByWhere(String whereC) {
        return this.manager.createQuery("select e from Catalog e where " + whereC + " and Auto_flag ='I' " + " order by e.originTime, e.originTimeFrac").getResultList();
    }

    @Override
    public Collection findAllCaliParam() {
        return this.manager.createQuery("select e from CaliParam e     order by e.staCode").getResultList();
    }

    @Override
    public CaliParam findCaliParamByStaCode(long l) {
        CaliParam cali = this.manager.find(CaliParam.class, l);
        return cali;
    }

    @Override
    public void updateCaliParam(CaliParam caliParam) {
        this.manager.merge(caliParam);
    }

    @Override
    public List<StationInfo> findAllSta_code() {
        return this.manager.createQuery("select e from StationInfo e  ").getResultList();
    }
}

