/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.LostWaveform;
import cn.org.gddsn.jopens.service.LostWaveformService;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.log4j.Logger;

@Stateless
@Local(value={LostWaveformService.class})
@Remote(value={LostWaveformService.class})
public class LostWaveformServiceBean
implements LostWaveformService,
Serializable {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(LostWaveformServiceBean.class);
    @PersistenceContext
    private EntityManager em;

    public LostWaveform save(LostWaveform LostWaveform2) {
        return this.em.merge(new LostWaveform(LostWaveform2));
    }

    public LostWaveform findById(long id) {
        return this.em.find(LostWaveform.class, id);
    }

    public List findByInterval(Date start, Date end, LostWaveformService.Mode mode) {
        Query query = this.em.createQuery("select substring(e.startTime, 1, :width),e.channelLocator.netCode, e.channelLocator.stationCode, sum(e.duraSecs) from LostWaveform e where e.startTime > :start and e.startTime < :end and e.channelLocator.chanCode like '%Z' group by e.channelLocator.stationCode, substring(e.startTime,1,:width) order by e.startTime ,e.channelLocator.netCode").setParameter("width", (Object)new Integer(mode.width())).setParameter("start", start, TemporalType.TIMESTAMP).setParameter("end", end, TemporalType.TIMESTAMP);
        return query.getResultList();
    }

    @Remove
    public void checkout() {
        this.em.flush();
    }

    public List findDelayByInterval(Date start, Date end, float minSecond) {
        Query query = this.em.createQuery("select e from DelayStatus e where e.actionTime > :start and e.actionTime < :end  and  e.delaySecond > :minSecond and e.channelLocator.chanCode like '%Z' order by e.channelLocator.stationCode, e.actionTime").setParameter("minSecond", (Object)Float.valueOf(minSecond)).setParameter("start", start, TemporalType.TIMESTAMP).setParameter("end", end, TemporalType.TIMESTAMP);
        return query.getResultList();
    }
}

