/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.Waveform;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.Dataless;
import cn.org.gddsn.jopens.service.SeedExportPlugin;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventExportPlugin
implements SeedExportPlugin {
    static Logger logger = Logger.getLogger(EventExportPlugin.class);
    private SeedVolumeService stationService;
    private SeedVolumeService waveformService;
    private int waveformRecordLength = 512;
    private String[] net;
    private String[] station;
    private Hashtable<ChannelLocator, List<Waveform>> tbl = new Hashtable();
    private Dataless dl;

    @Override
    public void process(String eventId, Date startTime, Date endTime) {
        long now = System.currentTimeMillis();
        this.tbl.clear();
        List<Waveform> list = null;
        list = eventId != null ? this.waveformService.getWaveform(eventId) : this.waveformService.getWaveform(new Date(startTime.getTime() - 1200000L), endTime, this.net, this.station);
        for (Waveform w : list) {
            ChannelLocator cl = w.getChannelLocator();
            List<Waveform> wlist = this.tbl.get(cl);
            if (wlist == null) {
                wlist = new LinkedList<Waveform>();
                this.tbl.put(cl, wlist);
            }
            wlist.add(w);
            this.waveformRecordLength = w.getRecLenth();
        }
        Vector<String> net_staVec = new Vector<String>();
        for (ChannelLocator cl : this.tbl.keySet()) {
            Channel chn = this.dl.findChannel(cl);
            if (chn != null) {
                String net_sta = String.valueOf(cl.getNetCode()) + "/" + cl.getStationCode();
                if (net_staVec.contains(net_sta)) continue;
                net_staVec.add(net_sta);
                continue;
            }
            logger.warn(cl + " have waveform, but could not found suitable station info!");
        }
        logger.info("Fetch waveform from DB elapse time: " + (System.currentTimeMillis() - now));
    }

    @Override
    public List<Waveform> getWaveform(ChannelLocator cl) {
        return this.tbl.get(cl);
    }

    @Override
    public void clear() {
        this.waveformService.findClear();
    }

    @Override
    public int getWaveformChunkSize(ChannelLocator cl) {
        List<Waveform> wlist = this.tbl.get(cl);
        if (wlist == null) {
            return 0;
        }
        int size = 0;
        for (Waveform w : wlist) {
            size += w.getChunkSize();
        }
        return size;
    }

    @Override
    public int getWaveformRecordLength() {
        return this.waveformRecordLength;
    }

    @Override
    public void setFilter(String[] net, String[] sta) {
        this.net = net;
        this.station = sta;
    }

    @Override
    public Dataless getDataless(String eventId, Date startTime, Date endTime) {
        if (eventId == null) {
            if (this.dl == null) {
                this.dl = this.stationService.findDefaultDataless();
            }
        } else {
            this.dl = this.stationService.findDatalessByEventId(eventId);
            startTime = this.dl.getVolumeIndex().getBlockette010().getStartTime();
            endTime = this.dl.getVolumeIndex().getBlockette010().getEndTime();
        }
        return this.dl;
    }

    public SeedVolumeService getStationService() {
        return this.stationService;
    }

    public void setStationService(SeedVolumeService stationService) {
        this.stationService = stationService;
    }

    public SeedVolumeService getWaveformService() {
        return this.waveformService;
    }

    public void setWaveformService(SeedVolumeService waveformService) {
        this.waveformService = waveformService;
    }

    public void setDataless(Dataless dl) {
        this.dl = dl;
    }
}

