/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.service;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.NetworkInfo;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.jopens.entity.ReirInfo;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import cn.org.gddsn.jopens.service.SpringUtil;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.jboss.annotation.ejb.ResourceAdapter;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="maxSessions", propertyValue="1"), @ActivationConfigProperty(propertyName="destination", propertyValue="activemq/topic/eqim"), @ActivationConfigProperty(propertyName="subscriptionName", propertyValue=""), @ActivationConfigProperty(propertyName="subscriptionDurability", propertyValue="NonDurable")})
@ResourceAdapter(value="activemq-ra.rar")
public class EqimMessgeBean
implements MessageListener {
    static Logger logger = Logger.getLogger(EqimMessgeBean.class);
    @Resource(name="ejb/BeanFactoryPath", type=String.class)
    private String beanFactoryPath;
    private SeedVolumeService eqimService;
    @PersistenceContext
    private EntityManager manager;

    @PostConstruct
    public void postConstruct() {
        logger.info("beanFactoryPath = " + this.beanFactoryPath);
        SpringUtil util = new SpringUtil();
        util.loadBeanFactory();
        this.eqimService = (SeedVolumeService)util.getBeanFactory().getBean("eqimService");
    }

    public void onMessage(Message recvMsg) {
        Catalog c;
        ReirInfo to;
        ReirInfo from;
        String myNetcode;
        NetworkInfo ni;
        String netCode;
        Message tm;
        if (recvMsg instanceof TextMessage) {
            tm = (TextMessage)recvMsg;
            try {
                long id = Long.parseLong(tm.getText());
                logger.info("Eqim Id: " + id);
                netCode = tm.getStringProperty("Net_code");
                ni = this.eqimService.findNetworkInfoSelf();
                myNetcode = ni.getId();
                if (myNetcode.equals(netCode)) {
                    // empty if block
                }
                from = null;
                try {
                    from = this.eqimService.readReirInfo(id);
                }
                catch (Exception ex) {
                    logger.warn(ex.getMessage(), ex);
                }
                if (from == null) {
                    logger.warn("got NULL ReirInfo from CDSN, id=" + id + ", Net_code=" + netCode);
                    return;
                }
                logger.info("got ReirInfo from CDSN, id=" + id + ", Net_code=" + netCode);
                to = new ReirInfo();
                try {
                    BeanUtils.copyProperties((Object)to, (Object)from);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                to.setId(0L);
                c = to.getCatalog();
                for (Mag m : c.getMags()) {
                    m.setId(0L);
                    m.setCatalog(c);
                }
                for (Phase p : c.getPhases()) {
                    p.setId(0L);
                    p.setCatalog(c);
                }
                this.manager.persist(to);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
            }
        }
        if (recvMsg instanceof BytesMessage) {
            tm = (BytesMessage)recvMsg;
            try {
                long id = Long.parseLong(tm.getStringProperty("id"));
                logger.info("Eqim Id: " + id);
                netCode = tm.getStringProperty("Net_code");
                ni = this.eqimService.findNetworkInfoSelf();
                myNetcode = ni.getId();
                if (myNetcode.equals(netCode)) {
                    // empty if block
                }
                from = null;
                try {
                    from = this.eqimService.readReirInfo(id);
                }
                catch (Exception ex) {
                    logger.warn(ex.getMessage(), ex);
                }
                if (from == null) {
                    logger.warn("got NULL ReirInfo from CDSN, id=" + id + ", Net_code=" + netCode);
                    return;
                }
                logger.info("got ReirInfo from CDSN, id=" + id + ", Net_code=" + netCode);
                to = new ReirInfo();
                try {
                    BeanUtils.copyProperties((Object)to, (Object)from);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                to.setId(0L);
                c = to.getCatalog();
                for (Mag m : c.getMags()) {
                    m.setId(0L);
                    m.setCatalog(c);
                }
                for (Phase p : c.getPhases()) {
                    p.setId(0L);
                    p.setCatalog(c);
                }
                this.manager.persist(to);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), e);
            }
        }
    }
}

