/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.util;

import cn.org.gddsn.jopens.entity.EventInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityXmlUtils {
    static Logger logger = Logger.getLogger(EntityXmlUtils.class);

    public static EventInfo readEventInfo(InputStream reader) throws IOException {
        EventInfo eventInfo = null;
        try {
            Mapping mapping = new Mapping();
            mapping.loadMapping(EventInfo.class.getResource("mapping.xml"));
            Unmarshaller unmarshaller = new Unmarshaller(EventInfo.class);
            unmarshaller.setMapping(mapping);
            eventInfo = (EventInfo)unmarshaller.unmarshal(new InputSource(reader));
            reader.close();
        }
        catch (ValidationException vEx) {
            logger.warn(vEx.getMessage(), vEx);
        }
        catch (MarshalException marEx) {
            logger.warn(marEx.getMessage(), marEx);
        }
        catch (MappingException mEx) {
            logger.warn(mEx.getMessage(), mEx);
        }
        return eventInfo;
    }

    public static boolean writeEventInfo(OutputStream writer, EventInfo eventInfo) throws IOException {
        boolean ret = false;
        try {
            Mapping mapping = new Mapping();
            mapping.loadMapping(EventInfo.class.getResource("mapping.xml"));
            String encoding = "UTF-8";
            OutputStreamWriter osw = new OutputStreamWriter(writer, encoding);
            Marshaller marshaller = new Marshaller((Writer)osw);
            marshaller.setEncoding(encoding);
            marshaller.setMapping(mapping);
            marshaller.setSuppressNamespaces(true);
            marshaller.setSuppressXSIType(true);
            marshaller.marshal((Object)eventInfo);
            ret = true;
        }
        catch (ValidationException vEx) {
            logger.warn(vEx.getMessage(), vEx);
            ret = false;
        }
        catch (MarshalException marEx) {
            logger.warn(marEx.getMessage(), marEx);
            ret = false;
        }
        catch (MappingException mEx) {
            mEx.printStackTrace();
            logger.warn(mEx.getMessage(), mEx);
            ret = false;
        }
        return ret;
    }

    public static <T> T read(InputStream reader, Class clazz) throws IOException {
        Object t = null;
        try {
            Mapping mapping = new Mapping();
            mapping.loadMapping(clazz.getResource("mapping.xml"));
            Unmarshaller unmarshaller = new Unmarshaller(clazz);
            unmarshaller.setMapping(mapping);
            t = unmarshaller.unmarshal(new InputSource(reader));
            reader.close();
        }
        catch (ValidationException vEx) {
            logger.warn(vEx.getMessage(), vEx);
        }
        catch (MarshalException marEx) {
            logger.warn(marEx.getMessage(), marEx);
        }
        catch (MappingException mEx) {
            logger.warn(mEx.getMessage(), mEx);
        }
        return (T)t;
    }

    public static <T> boolean write(OutputStream writer, T o, Class clazz) throws IOException {
        boolean ret = false;
        try {
            Mapping mapping = new Mapping();
            mapping.loadMapping(clazz.getResource("mapping.xml"));
            String encoding = "UTF-8";
            OutputStreamWriter osw = new OutputStreamWriter(writer, encoding);
            Marshaller marshaller = new Marshaller((Writer)osw);
            marshaller.setEncoding(encoding);
            marshaller.setMapping(mapping);
            marshaller.setSuppressNamespaces(true);
            marshaller.setSuppressXSIType(true);
            marshaller.marshal(o);
            ret = true;
        }
        catch (ValidationException vEx) {
            logger.warn(vEx.getMessage(), vEx);
            ret = false;
        }
        catch (MarshalException marEx) {
            logger.warn(marEx.getMessage(), marEx);
            ret = false;
        }
        catch (MappingException mEx) {
            mEx.printStackTrace();
            logger.warn(mEx.getMessage(), mEx);
            ret = false;
        }
        return ret;
    }
}

