/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.InstrDic;
import cn.org.gddsn.jopens.entity.StationCorr;
import cn.org.gddsn.jopens.entity.StationInfo;
import cn.org.gddsn.jopens.entity.StationSite;
import cn.org.gddsn.jopens.entity.seed.Blockette050;
import cn.org.gddsn.jopens.entity.seed.Blockette051;
import cn.org.gddsn.jopens.entity.seed.Channel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Station
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Column(length=16)
    private String exchangeId;
    private int seqNumber;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="b050_id", nullable=true)
    private Blockette050 blockette050;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="StationInfo_id", nullable=true)
    private StationInfo stationInfo;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="Station_corr_id", nullable=true)
    private StationCorr stationCorr;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="Station_site_id", nullable=true)
    private StationSite stationSite;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="Station_id", nullable=true)
    private List<Blockette051> blockette051 = new ArrayList<Blockette051>();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="Station_id", nullable=true)
    private List<Channel> channel = new ArrayList<Channel>();
    @OneToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="Instrument_id", nullable=true)
    private InstrDic instrument;
    @OneToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="Datarecord_id", nullable=true)
    private InstrDic datarecord;
    @Transient
    private long instrumentId;
    @Transient
    private long datarecordId;

    public List<Channel> getChannel() {
        return this.channel;
    }

    public List<Blockette051> getBlockette051() {
        return this.blockette051;
    }

    public Blockette050 getBlockette050() {
        return this.blockette050;
    }

    public void setBlockette050(Blockette050 blockette050) {
        this.blockette050 = blockette050;
    }

    public void setBlockette051(List<Blockette051> blockette051) {
        this.blockette051 = blockette051;
    }

    public void setChannel(List<Channel> channel) {
        this.channel = channel;
    }

    public Channel findChannel(String location, String chan) {
        for (Channel chn : this.channel) {
            if (!chn.getBlockette052().getLocation().equals(location) || !chn.getBlockette052().getChannel().equals(chan)) continue;
            return chn;
        }
        return null;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public StationCorr getStationCorr() {
        return this.stationCorr;
    }

    public void setStationCorr(StationCorr stationCorr) {
        this.stationCorr = stationCorr;
    }

    public StationInfo getStationInfo() {
        return this.stationInfo;
    }

    public void setStationInfo(StationInfo stationInfo) {
        this.stationInfo = stationInfo;
    }

    public StationSite getStationSite() {
        return this.stationSite;
    }

    public void setStationSite(StationSite stationSite) {
        this.stationSite = stationSite;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public void setExchangeId(String exchangeId) {
        this.exchangeId = exchangeId;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public void setSeqNumber(int order) {
        this.seqNumber = order;
    }

    public InstrDic getDatarecord() {
        return this.datarecord;
    }

    public void setDatarecord(InstrDic datarecord) {
        this.datarecord = datarecord;
    }

    public InstrDic getInstrument() {
        return this.instrument;
    }

    public void setInstrument(InstrDic instrument) {
        this.instrument = instrument;
    }

    public long getDatarecordId() {
        return this.datarecordId;
    }

    public void setDatarecordId(long datarecordId) {
        this.datarecordId = datarecordId;
    }

    public long getInstrumentId() {
        return this.instrumentId;
    }

    public void setInstrumentId(long instrumentId) {
        this.instrumentId = instrumentId;
    }
}

