/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Blockette;
import java.util.Formatter;

public class LogicalBlockBreaker {
    private int sequence = 1;
    private int logicalBlockSize = 4096;
    private StringBuilder sb = new StringBuilder(4096);

    public LogicalBlockBreaker(int logicalBlockSize) {
        this.logicalBlockSize = logicalBlockSize;
    }

    public void addBlockette(Blockette block) {
        if (block != null) {
            int size = this.logicalBlockSize - 8;
            int left = size - this.sb.length() % size;
            if (left < 7) {
                int i = 0;
                while (i < left) {
                    this.sb.append(' ');
                    ++i;
                }
            }
            this.sb.append(block.toBlockette());
        }
    }

    public StringBuilder toLogicalBlock(char type) {
        StringBuilder sbuf = new StringBuilder(this.sb.length());
        int size = this.logicalBlockSize - 8;
        int left = this.sb.length() % size;
        if (left != 0) {
            int pad = size - left;
            int i = 0;
            while (i < pad) {
                this.sb.append(' ');
                ++i;
            }
        }
        Formatter fmt = new Formatter(sbuf);
        int nblock = this.sb.length() / size;
        int i = 0;
        while (i < nblock) {
            this.formatSequence(fmt, type, i);
            fmt.format("%1$s", this.sb.substring(i * size, (i + 1) * size));
            ++i;
        }
        this.sb = null;
        this.sb = new StringBuilder(4096);
        return sbuf;
    }

    public int getSequence() {
        return this.sequence;
    }

    private void formatSequence(Formatter fmt, char type, int nblock) {
        fmt.format("%1$06d%2$c%3$c", this.sequence++, Character.valueOf(type), Character.valueOf(nblock == 0 ? (char)' ' : '*'));
    }
}

