/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.SeedConfig;
import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette010;
import cn.org.gddsn.jopens.entity.seed.Blockette011;
import cn.org.gddsn.jopens.entity.seed.Blockette012;
import cn.org.gddsn.jopens.entity.seed.Blockette030;
import cn.org.gddsn.jopens.entity.seed.Blockette031;
import cn.org.gddsn.jopens.entity.seed.Blockette032;
import cn.org.gddsn.jopens.entity.seed.Blockette033;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import cn.org.gddsn.jopens.entity.seed.Blockette050;
import cn.org.gddsn.jopens.entity.seed.Blockette051;
import cn.org.gddsn.jopens.entity.seed.Blockette052;
import cn.org.gddsn.jopens.entity.seed.Blockette053;
import cn.org.gddsn.jopens.entity.seed.Blockette054;
import cn.org.gddsn.jopens.entity.seed.Blockette055;
import cn.org.gddsn.jopens.entity.seed.Blockette056;
import cn.org.gddsn.jopens.entity.seed.Blockette057;
import cn.org.gddsn.jopens.entity.seed.Blockette058;
import cn.org.gddsn.jopens.entity.seed.Blockette059;
import cn.org.gddsn.jopens.entity.seed.Blockette061;
import cn.org.gddsn.jopens.entity.seed.Blockette070;
import cn.org.gddsn.jopens.entity.seed.Blockette071;
import cn.org.gddsn.jopens.entity.seed.Blockette072;
import cn.org.gddsn.jopens.entity.seed.Blockette073;
import cn.org.gddsn.jopens.entity.seed.Blockette074;
import cn.org.gddsn.jopens.entity.seed.Channel;
import cn.org.gddsn.jopens.entity.seed.LogicalBlock;
import cn.org.gddsn.jopens.entity.seed.LogicalBlockBreaker;
import cn.org.gddsn.jopens.entity.seed.Pair;
import cn.org.gddsn.jopens.entity.seed.RawVolume;
import cn.org.gddsn.jopens.entity.seed.Response;
import cn.org.gddsn.jopens.entity.seed.Station;
import cn.org.gddsn.jopens.entity.seed.TimeSpan;
import cn.org.gddsn.jopens.entity.seed.VolumeIndex;
import cn.org.gddsn.jopens.service.SeedExportPlugin;
import edu.iris.timeutils.TimeStamp;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.util.LocalConfiguration;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Dataless
implements Serializable {
    private static final long serialVersionUID = 1L;
    static Logger logger = Logger.getLogger(Dataless.class);
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="volumeIndex_id", nullable=false)
    private VolumeIndex volumeIndex = new VolumeIndex();
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="seedConfig_id", nullable=false)
    private SeedConfig seedConfig = new SeedConfig();
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="dataless_id", nullable=true)
    private List<TimeSpan> timeSpan = new ArrayList<TimeSpan>();
    private Timestamp saveTime;
    @Transient
    private int seqV = 1;
    @Transient
    private int seqA = 1;
    @Transient
    private int seqS = 1;
    @Transient
    private int seqT = 1;
    @Transient
    private int sizeT = 1;

    public List<TimeSpan> getTimeSpan() {
        return this.timeSpan;
    }

    public VolumeIndex getVolumeIndex() {
        return this.volumeIndex;
    }

    public void setTimeSpan(List<TimeSpan> timeSpan) {
        this.timeSpan = timeSpan;
    }

    public void setVolumeIndex(VolumeIndex volumeIndex) {
        this.volumeIndex = volumeIndex;
    }

    public static Dataless readXMLSeedVolumeDataless(Reader reader) throws IOException {
        Dataless dataless = null;
        try {
            Mapping mapping = new Mapping();
            mapping.loadMapping(Dataless.class.getResource("mapping.xml"));
            Unmarshaller unmarshaller = new Unmarshaller(Dataless.class);
            unmarshaller.setMapping(mapping);
            dataless = (Dataless)unmarshaller.unmarshal(reader);
            reader.close();
        }
        catch (ValidationException vEx) {
            logger.warn(vEx.getMessage(), vEx);
        }
        catch (MarshalException marEx) {
            logger.warn(marEx.getMessage(), marEx);
        }
        catch (MappingException mEx) {
            logger.warn(mEx.getMessage(), mEx);
        }
        return dataless;
    }

    public boolean writeXMLSeedVolumeDataless(Writer writer) throws IOException {
        boolean ret = false;
        boolean indent = false;
        try {
            if (indent) {
                LocalConfiguration.getInstance().getProperties().setProperty("org.exolab.castor.indent", "true");
            }
            Mapping mapping = new Mapping();
            mapping.loadMapping(Dataless.class.getResource("mapping.xml"));
            Marshaller marshaller = new Marshaller(writer);
            marshaller.setMapping(mapping);
            marshaller.setSuppressNamespaces(true);
            marshaller.setSuppressXSIType(true);
            marshaller.marshal((Object)this);
            ret = true;
        }
        catch (ValidationException vEx) {
            logger.warn(vEx.getMessage(), vEx);
            ret = false;
        }
        catch (MarshalException marEx) {
            logger.warn(marEx.getMessage(), marEx);
            ret = false;
        }
        catch (MappingException mEx) {
            mEx.printStackTrace();
            logger.warn(mEx.getMessage(), mEx);
            ret = false;
        }
        return ret;
    }

    public int writeSeedVolumeDataless(OutputStream out) throws IOException {
        int logicalBlockSize = this.volumeIndex.getBlockette010().getLogicalRecordLength();
        LogicalBlockBreaker breaker = new LogicalBlockBreaker((int)Math.pow(2.0, logicalBlockSize));
        breaker.addBlockette(this.volumeIndex.getBlockette010());
        breaker.addBlockette(this.volumeIndex.getBlockette011());
        breaker.addBlockette(this.volumeIndex.getBlockette012());
        out.write(breaker.toLogicalBlock('V').substring(0).getBytes());
        out.flush();
        Abbreviation abbreviation = this.getSeedConfig().getAbbreviation();
        for (Blockette030 blockette030 : abbreviation.getBlockette030()) {
            breaker.addBlockette(blockette030);
        }
        for (Blockette031 blockette031 : abbreviation.getBlockette031()) {
            breaker.addBlockette(blockette031);
        }
        for (Blockette032 blockette032 : abbreviation.getBlockette032()) {
            breaker.addBlockette(blockette032);
        }
        for (Blockette033 blockette033 : abbreviation.getBlockette033()) {
            breaker.addBlockette(blockette033);
        }
        for (Blockette034 blockette034 : abbreviation.getBlockette034()) {
            breaker.addBlockette(blockette034);
        }
        out.write(breaker.toLogicalBlock('A').substring(0).getBytes());
        out.flush();
        List<Station> list = this.getSeedConfig().getStation();
        int n = 0;
        for (Station stn : list) {
            ++n;
            breaker.addBlockette(stn.getBlockette050());
            for (Blockette051 b051 : stn.getBlockette051()) {
                breaker.addBlockette(b051);
            }
            for (Channel chn : stn.getChannel()) {
                breaker.addBlockette(chn.getBlockette052());
                int size = chn.getResponse().size();
                Response rsp = null;
                int i = 1;
                while (i < size) {
                    rsp = chn.getResponse().get(i);
                    breaker.addBlockette(rsp.getBlockette053());
                    breaker.addBlockette(rsp.getBlockette054());
                    breaker.addBlockette(rsp.getBlockette061());
                    breaker.addBlockette(rsp.getBlockette055());
                    breaker.addBlockette(rsp.getBlockette056());
                    breaker.addBlockette(rsp.getBlockette057());
                    breaker.addBlockette(rsp.getBlockette058());
                    ++i;
                }
                rsp = chn.getResponse().get(0);
                breaker.addBlockette(rsp.getBlockette053());
                breaker.addBlockette(rsp.getBlockette054());
                breaker.addBlockette(rsp.getBlockette061());
                breaker.addBlockette(rsp.getBlockette055());
                breaker.addBlockette(rsp.getBlockette056());
                breaker.addBlockette(rsp.getBlockette057());
                breaker.addBlockette(rsp.getBlockette058());
                for (Response rsp1 : chn.getResponse()) {
                    breaker.addBlockette(rsp1.getBlockette059());
                }
            }
            out.write(breaker.toLogicalBlock('S').substring(0).getBytes());
            out.flush();
        }
        logger.info("Total " + n + " station info write into seed header.");
        for (TimeSpan ts : this.timeSpan) {
            breaker.addBlockette(ts.getBlockette070());
            breaker.addBlockette(ts.getBlockette071());
            for (Blockette072 b072 : ts.getBlockette072()) {
                breaker.addBlockette(b072);
            }
            for (Blockette074 b074 : ts.getBlockette074()) {
                breaker.addBlockette(b074);
            }
            out.write(breaker.toLogicalBlock('T').substring(0).getBytes());
            out.flush();
        }
        return breaker.getSequence();
    }

    public boolean readSeedVolumeDataless(PushbackInputStream in) throws IOException {
        RawVolume volume = new RawVolume();
        volume.setIn(in);
        Blockette header = null;
        LogicalBlock block = null;
        TimeSpan ts = null;
        int tsCount = -1;
        Station stn = null;
        int stnCount = -1;
        Channel chn = null;
        int chnCount = -1;
        Response rsp = null;
        int stage = 0;
        boolean dataless = true;
        Abbreviation abbreviation = this.getSeedConfig().getAbbreviation();
        List<Station> station = this.getSeedConfig().getStation();
        int firstB074 = -1;
        block30: while (dataless && (block = volume.next()) != null) {
            logger.info("process: " + block);
            switch (block.getType()) {
                case 'A': 
                case 'S': 
                case 'T': 
                case 'V': {
                    block31: while ((header = block.next()) != null) {
                        switch (header.getType()) {
                            case 10: {
                                Blockette010 b010 = new Blockette010();
                                b010.parse(header);
                                this.volumeIndex.setBlockette010(b010);
                                break;
                            }
                            case 11: {
                                Blockette011 b011 = new Blockette011();
                                b011.parse(header);
                                this.volumeIndex.setBlockette011(b011);
                                break;
                            }
                            case 12: {
                                Blockette012 b012 = new Blockette012();
                                b012.parse(header);
                                this.volumeIndex.setBlockette012(b012);
                                if (this.volumeIndex.getBlockette012() == null) {
                                    this.volumeIndex.setBlockette012(b012);
                                    break;
                                }
                                this.volumeIndex.getBlockette012().merge(b012);
                                break;
                            }
                            case 30: {
                                Blockette030 b030 = new Blockette030();
                                b030.parse(header);
                                abbreviation.getBlockette030().add(b030);
                                b030.setAbbreviation(abbreviation);
                                break;
                            }
                            case 31: {
                                Blockette031 b031 = new Blockette031();
                                b031.parse(header);
                                abbreviation.getBlockette031().add(b031);
                                b031.setAbbreviation(abbreviation);
                                break;
                            }
                            case 32: {
                                Blockette032 b032 = new Blockette032();
                                b032.parse(header);
                                abbreviation.getBlockette032().add(b032);
                                b032.setAbbreviation(abbreviation);
                                break;
                            }
                            case 33: {
                                Blockette033 b033 = new Blockette033();
                                b033.parse(header);
                                abbreviation.getBlockette033().add(b033);
                                b033.setAbbreviation(abbreviation);
                                break;
                            }
                            case 34: {
                                Blockette034 b034 = new Blockette034();
                                b034.parse(header);
                                abbreviation.getBlockette034().add(b034);
                                b034.setAbbreviation(abbreviation);
                                break;
                            }
                            case 50: {
                                Blockette050 b050 = new Blockette050();
                                b050.parse(header, abbreviation);
                                stn = new Station();
                                station.add(stn);
                                stn.setBlockette050(b050);
                                ++stnCount;
                                chnCount = -1;
                                break;
                            }
                            case 51: {
                                Blockette051 b051 = new Blockette051();
                                b051.parse(header, abbreviation);
                                stn = station.get(stnCount);
                                stn.getBlockette051().add(b051);
                                break;
                            }
                            case 52: {
                                Blockette052 b052 = new Blockette052();
                                b052.parse(header, abbreviation);
                                chn = new Channel();
                                chn.setBlockette052(b052);
                                stn = station.get(stnCount);
                                stn.getChannel().add(chn);
                                chn.setStation(stn);
                                ++chnCount;
                                break;
                            }
                            case 53: {
                                Blockette053 b053 = new Blockette053();
                                b053.parse(header, abbreviation);
                                stage = b053.getStageSequence();
                                stn = station.get(stnCount);
                                chn = stn.getChannel().get(chnCount);
                                rsp = this.getResponse(chn, stage);
                                if (rsp.getBlockette053() == null) {
                                    rsp.setBlockette053(b053);
                                    break;
                                }
                                rsp.getBlockette053().merge(b053);
                                break;
                            }
                            case 54: {
                                Blockette054 b054 = new Blockette054();
                                b054.parse(header, abbreviation);
                                stage = b054.getStageSequence();
                                stn = station.get(stnCount);
                                chn = stn.getChannel().get(chnCount);
                                rsp = this.getResponse(chn, stage);
                                if (rsp.getBlockette054() == null) {
                                    rsp.setBlockette054(b054);
                                    break;
                                }
                                rsp.getBlockette054().merge(b054);
                                break;
                            }
                            case 61: {
                                Blockette061 b061 = new Blockette061();
                                b061.parse(header, abbreviation);
                                stage = b061.getStageSequence();
                                stn = station.get(stnCount);
                                chn = stn.getChannel().get(chnCount);
                                rsp = this.getResponse(chn, stage);
                                rsp.setBlockette061(b061);
                                break;
                            }
                            case 55: {
                                Blockette055 b055 = new Blockette055();
                                b055.parse(header, abbreviation);
                                stage = b055.getStageSequence();
                                stn = station.get(stnCount);
                                chn = stn.getChannel().get(chnCount);
                                rsp = this.getResponse(chn, stage);
                                rsp.setBlockette055(b055);
                                break;
                            }
                            case 56: {
                                Blockette056 b056 = new Blockette056();
                                b056.parse(header, abbreviation);
                                stage = b056.getStageSequence();
                                stn = station.get(stnCount);
                                chn = stn.getChannel().get(chnCount);
                                rsp = this.getResponse(chn, stage);
                                rsp.setBlockette056(b056);
                                break;
                            }
                            case 57: {
                                Blockette057 b057 = new Blockette057();
                                b057.parse(header);
                                stage = b057.getStageSequence();
                                stn = station.get(stnCount);
                                chn = stn.getChannel().get(chnCount);
                                rsp = this.getResponse(chn, stage);
                                rsp.setBlockette057(b057);
                                break;
                            }
                            case 58: {
                                Blockette058 b058 = new Blockette058();
                                b058.parse(header);
                                stage = b058.getStageSequence();
                                stn = station.get(stnCount);
                                chn = stn.getChannel().get(chnCount);
                                rsp = this.getResponse(chn, stage);
                                rsp.setBlockette058(b058);
                                break;
                            }
                            case 59: {
                                Blockette059 b059 = new Blockette059();
                                b059.parse(header, abbreviation);
                                stn = station.get(stnCount);
                                chn = stn.getChannel().get(chnCount);
                                rsp = this.getResponse(chn, stage);
                                rsp.setBlockette059(b059);
                                break;
                            }
                            case 70: {
                                Blockette070 b070 = new Blockette070();
                                b070.parse(header);
                                ts = new TimeSpan();
                                ts.setBlockette070(b070);
                                this.timeSpan.add(ts);
                                ++tsCount;
                                break;
                            }
                            case 71: {
                                Blockette071 b071 = new Blockette071();
                                b071.parse(header, abbreviation);
                                ts = this.timeSpan.get(tsCount);
                                ts.setBlockette071(b071);
                                break;
                            }
                            case 72: {
                                Blockette072 b072 = new Blockette072();
                                b072.parse(header, abbreviation);
                                ts = this.timeSpan.get(tsCount);
                                ts.getBlockette072().add(b072);
                                break;
                            }
                            case 73: {
                                Blockette073 b073 = new Blockette073();
                                b073.parse(header, abbreviation);
                                break;
                            }
                            case 74: {
                                Blockette074 b074 = new Blockette074();
                                b074.parse(header);
                                ts = this.timeSpan.get(tsCount);
                                ts.getBlockette074().add(b074);
                                if (firstB074 == -1) {
                                    firstB074 = b074.getFirstSequence();
                                }
                                if (!dataless || block.getSequence() + block.getSize() != firstB074) continue block31;
                                dataless = false;
                                break;
                            }
                            default: {
                                logger.warn("Unknown Blockette Type:" + header.getType());
                                header.parse(header, abbreviation);
                            }
                        }
                    }
                    continue block30;
                }
                case 'D': 
                case 'Q': 
                case 'R': {
                    System.out.println("Data Block");
                }
            }
        }
        in.unread(volume.getCurrentBuffer());
        return true;
    }

    public Station findStation(String networkCode, String sta) {
        List<Station> station = this.getSeedConfig().getStation();
        for (Station elem : station) {
            if (!elem.getBlockette050().getNetworkCode().equals(networkCode) || !elem.getBlockette050().getStation().equals(sta)) continue;
            return elem;
        }
        return null;
    }

    public Channel findChannel(String net, String sta, String locid, String chan) {
        return this.findChannel(new ChannelLocator(net, sta, locid, chan));
    }

    public Channel findChannel(ChannelLocator cl) {
        Station s = this.findStation(cl.getNetCode(), cl.getStationCode());
        if (s == null) {
            return null;
        }
        for (Channel c : s.getChannel()) {
            if (!c.getBlockette052().getLocation().equals(cl.getLocId()) || !c.getBlockette052().getChannel().equals(cl.getChanCode())) continue;
            return c;
        }
        return null;
    }

    private Response getResponse(Channel chn, int stage) {
        int size = chn.getResponse().size();
        if (stage >= size) {
            int i = size;
            while (i <= stage) {
                Response rsp = new Response();
                rsp.setStage(i);
                rsp.setChannel(chn);
                chn.getResponse().add(rsp);
                ++i;
            }
        }
        return chn.getResponse().get(stage);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public SeedConfig getSeedConfig() {
        return this.seedConfig;
    }

    public void setSeedConfig(SeedConfig seedConfig) {
        this.seedConfig = seedConfig;
    }

    public Timestamp getSaveTime() {
        return this.saveTime;
    }

    public void setSaveTime(Timestamp saveTime) {
        this.saveTime = saveTime;
    }

    public void fixupDataless() {
        this.buildVolumeIndex();
        this.buildAbbr();
        this.fixupVolumeIndex();
    }

    private void buildVolumeIndex() {
        Blockette010 b010 = this.getVolumeIndex().getBlockette010();
        b010.fixupBlocketteLength();
        Blockette011 b011 = this.getVolumeIndex().getBlockette011();
        if (b011 == null) {
            b011 = new Blockette011();
            this.getVolumeIndex().setBlockette011(b011);
        }
        ArrayList<Pair> pairs = new ArrayList<Pair>();
        for (Station sta : this.getSeedConfig().getStation()) {
            Pair p = new Pair();
            p.setStation(sta.getBlockette050().getStation());
            pairs.add(p);
            p.setSequence(0);
        }
        b011.setPairs(pairs);
        b011.fixupBlocketteLength();
        Blockette012 b012 = this.getVolumeIndex().getBlockette012();
        int total = b010.getBlocketteLength() + b011.getBlocketteLength();
        if (b012 != null) {
            total += b012.getBlocketteLength();
        }
        int lsize = (int)Math.pow(2.0, b010.getLogicalRecordLength());
        this.seqA = this.seqV + total / (lsize - 8);
        if (total % (lsize - 8) > 0) {
            ++this.seqA;
        }
    }

    private void fixupVolumeIndex() {
        List<Pair> pairs = this.getVolumeIndex().getBlockette011().getPairs();
        int i = 0;
        for (Station sta : this.getSeedConfig().getStation()) {
            Pair p = pairs.get(i);
            String net = sta.getBlockette050().getNetworkCode();
            String sn = sta.getBlockette050().getStation();
            p.setStation(sn);
            p.setSequence(this.seqS);
            this.seqS += this.getStationBlockSize(net, sn);
        }
        this.seqT = this.seqS;
        if (this.getVolumeIndex().getBlockette012() != null && this.getVolumeIndex().getBlockette012().getSpans().size() != 0) {
            this.getVolumeIndex().getBlockette012().getSpans().get(0).setSequence(this.seqT);
        }
    }

    private void buildAbbr() {
        int total = 0;
        List<Blockette030> b030s = this.getSeedConfig().getAbbreviation().getBlockette030();
        for (Blockette030 b : b030s) {
            b.fixupBlocketteLength();
            total += b.getBlocketteLength();
        }
        List<Blockette031> b031s = this.getSeedConfig().getAbbreviation().getBlockette031();
        for (Blockette031 b : b031s) {
            b.fixupBlocketteLength();
            total += b.getBlocketteLength();
        }
        List<Blockette032> b032s = this.getSeedConfig().getAbbreviation().getBlockette032();
        for (Blockette032 b : b032s) {
            b.fixupBlocketteLength();
            total += b.getBlocketteLength();
        }
        List<Blockette033> b033s = this.getSeedConfig().getAbbreviation().getBlockette033();
        for (Blockette033 b : b033s) {
            b.fixupBlocketteLength();
            total += b.getBlocketteLength();
        }
        List<Blockette034> b034s = this.getSeedConfig().getAbbreviation().getBlockette034();
        for (Blockette034 b : b034s) {
            b.fixupBlocketteLength();
            total += b.getBlocketteLength();
        }
        int lsize = (int)Math.pow(2.0, this.getVolumeIndex().getBlockette010().getLogicalRecordLength());
        this.seqS = this.seqA + total / (lsize - 8);
        if (total % (lsize - 8) > 0) {
            ++this.seqS;
        }
    }

    private int getStationBlockSize(String net, String stn) {
        int total = 0;
        Station sta = this.findStation(net, stn);
        if (sta == null) {
            return 0;
        }
        sta.getBlockette050().fixupBlocketteLength();
        total += sta.getBlockette050().getBlocketteLength();
        for (Blockette051 b051 : sta.getBlockette051()) {
            total += b051.getBlocketteLength();
        }
        for (Channel chn : sta.getChannel()) {
            chn.getBlockette052().fixupBlocketteLength();
            total += chn.getBlockette052().getBlocketteLength();
            for (Response rsp : chn.getResponse()) {
                if (rsp.getBlockette053() != null) {
                    rsp.getBlockette053().fixupBlocketteLength();
                    total += rsp.getBlockette053().getBlocketteLength();
                }
                if (rsp.getBlockette054() != null) {
                    rsp.getBlockette054().fixupBlocketteLength();
                    total += rsp.getBlockette054().getBlocketteLength();
                }
                if (rsp.getBlockette055() != null) {
                    rsp.getBlockette055().fixupBlocketteLength();
                    total += rsp.getBlockette055().getBlocketteLength();
                }
                if (rsp.getBlockette056() != null) {
                    rsp.getBlockette056().fixupBlocketteLength();
                    total += rsp.getBlockette056().getBlocketteLength();
                }
                if (rsp.getBlockette057() != null) {
                    rsp.getBlockette057().fixupBlocketteLength();
                    total += rsp.getBlockette057().getBlocketteLength();
                }
                if (rsp.getBlockette058() != null) {
                    rsp.getBlockette058().fixupBlocketteLength();
                    total += rsp.getBlockette058().getBlocketteLength();
                }
                if (rsp.getBlockette061() == null) continue;
                rsp.getBlockette061().fixupBlocketteLength();
                total += rsp.getBlockette061().getBlocketteLength();
            }
        }
        int lsize = (int)Math.pow(2.0, this.getVolumeIndex().getBlockette010().getLogicalRecordLength());
        int nblock = total / (lsize - 8);
        if (total % (lsize - 8) > 0) {
            ++nblock;
        }
        return nblock;
    }

    public void fixupB074(int waveformRecordLength, SeedExportPlugin seedExportPlugin) throws IOException {
        int lsize = (int)Math.pow(2.0, this.getVolumeIndex().getBlockette010().getLogicalRecordLength());
        List<Blockette074> b074s = this.getTimeSpan().get(0).getBlockette074();
        for (Blockette074 b074 : b074s) {
            ChannelLocator cl = new ChannelLocator(b074.getNetworkCode(), b074.getStation(), b074.getLocation(), b074.getChannel());
            if (seedExportPlugin.getWaveform(cl) == null) continue;
            int nblock = seedExportPlugin.getWaveformChunkSize(cl);
            b074.setFirstSequence(this.seqT);
            b074.setFirstSubSequence(1);
            b074.setLastSequence(this.seqT + (nblock - 1) / (lsize / waveformRecordLength));
            b074.setLastSubSeuence((nblock - 1) % (lsize / waveformRecordLength) + 1);
            this.seqT += nblock / (lsize / waveformRecordLength);
            if (nblock % (lsize / waveformRecordLength) <= 0) continue;
            ++this.seqT;
        }
    }

    public void setBlockette052RecordLength(int waveformRecordLength) {
        int len = 256;
        int n = 8;
        while ((len *= 2) <= waveformRecordLength) {
            ++n;
        }
        for (Station s : this.getSeedConfig().getStation()) {
            for (Channel c : s.getChannel()) {
                Blockette052 b052 = c.getBlockette052();
                if (b052 == null) continue;
                b052.setDataRecordLength(n);
            }
        }
    }

    public void fixupTimeSpan(Date startTime, Date endTime, SeedExportPlugin seedExportPlugin, char flag) throws IOException {
        int total = 0;
        if (this.getTimeSpan().size() == 0) {
            this.getTimeSpan().add(new TimeSpan());
            this.getTimeSpan().get(0).setBlockette070(new Blockette070());
        }
        TimeSpan ts = this.getTimeSpan().get(0);
        Blockette070 b070 = ts.getBlockette070();
        b070.setStartTime(new TimeStamp(startTime.getTime()));
        b070.setEndTime(new TimeStamp(endTime.getTime()));
        b070.setTimeSpanFlag(flag);
        b070.fixupBlocketteLength();
        total += b070.getBlocketteLength();
        ArrayList<Blockette074> b074s = new ArrayList<Blockette074>();
        this.getTimeSpan().get(0).setBlockette074(b074s);
        for (Station sta : this.getSeedConfig().getStation()) {
            if (sta == null) continue;
            for (Channel c : sta.getChannel()) {
                ChannelLocator cl = new ChannelLocator(sta.getBlockette050().getNetworkCode(), sta.getBlockette050().getStation(), c.getBlockette052().getLocation(), c.getBlockette052().getChannel());
                if (seedExportPlugin.getWaveform(cl) == null) continue;
                Blockette074 b074 = new Blockette074();
                b074s.add(b074);
                b074.setStation(sta.getBlockette050().getStation());
                b074.setNetworkCode(sta.getBlockette050().getNetworkCode());
                b074.setLocation(c.getBlockette052().getLocation());
                b074.setChannel(c.getBlockette052().getChannel());
                b074.setStartTime(new TimeStamp(startTime.getTime()));
                b074.setFirstSequence(0);
                b074.setFirstSubSequence(1);
                b074.setLastSequence(0);
                b074.setLastSequence(1);
                b074.setEndTime(new TimeStamp(endTime.getTime()));
                b074.fixupBlocketteLength();
                total += b074.getBlocketteLength();
            }
        }
        int lsize = (int)Math.pow(2.0, this.getVolumeIndex().getBlockette010().getLogicalRecordLength());
        int nblock = total / (lsize - 8);
        if (total % (lsize - 8) > 0) {
            ++nblock;
        }
        this.sizeT = nblock;
        this.seqT += this.sizeT;
    }

    public Blockette033 addBlockette033(String desc) {
        Blockette033 b033 = this.getSeedConfig().getAbbreviation().findBlockette033ByName(desc);
        if (b033 != null) {
            return b033;
        }
        int lookup = this.getSeedConfig().getAbbreviation().getBlockette033().size() + 1;
        b033 = new Blockette033();
        b033.setId(0L);
        b033.setDescription(desc);
        b033.setLookupCode(lookup);
        b033.setAbbreviation(this.getSeedConfig().getAbbreviation());
        this.getSeedConfig().getAbbreviation().getBlockette033().add(b033);
        return b033;
    }
}

