/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette032;
import cn.org.gddsn.jopens.entity.seed.Magnitude;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Blockette071
extends Blockette {
    private Timestamp orginTime;
    @OneToOne(cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="b032_id", nullable=false)
    private Blockette032 sourceIdentifier;
    private double latitude;
    private double longitude;
    private double depth;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="b071_id", nullable=true)
    private List<Magnitude> magnitudes = new ArrayList<Magnitude>();
    private int seismicRegion;
    private int seismicLocation;
    @Column(length=40)
    private String regionName;

    public Blockette071() {
        this.type = 71;
    }

    @Override
    public void parse(Blockette block, Abbreviation abbr) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.orginTime = Blockette.toTimestamp(block.getNextVariableField());
        int sourceIdentifier_code = Blockette071.parseInt(block.getNextFixedField(2));
        this.sourceIdentifier = abbr.findBlockette032ByIndex(sourceIdentifier_code);
        this.latitude = Double.parseDouble(block.getNextFixedField(10));
        this.longitude = Double.parseDouble(block.getNextFixedField(11));
        this.depth = Double.parseDouble(block.getNextFixedField(7));
        int numberOfMagnitude = Blockette071.parseInt(block.getNextFixedField(2));
        this.magnitudes = new ArrayList<Magnitude>();
        int i = 0;
        while (i < numberOfMagnitude) {
            Magnitude m = new Magnitude();
            this.magnitudes.add(m);
            m.setValue(Double.parseDouble(block.getNextFixedField(5)));
            m.setType(block.getNextVariableField());
            m.setSource(Blockette071.parseInt(block.getNextFixedField(2)));
            ++i;
        }
        this.seismicRegion = Blockette071.parseInt(block.getNextFixedField(3));
        this.seismicLocation = Blockette071.parseInt(block.getNextFixedField(4));
        this.regionName = block.getNextVariableField();
    }

    @Override
    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        Blockette.formatSeedTime(fmt, this.orginTime);
        fmt.format("%1$02d%2$ 010.6f%3$ 011.6f%4$ 07.2f%5$02d", this.sourceIdentifier != null ? this.sourceIdentifier.getLookupCode() : 0, this.latitude, this.longitude, this.depth, this.magnitudes.size());
        for (Magnitude m : this.magnitudes) {
            fmt.format("%1$ 5.2f%2$s~%3$02d", m.getValue(), m.getType(), m.getSource());
        }
        fmt.format("%1$03d%2$04d%3$s~", this.seismicRegion, this.seismicLocation, this.regionName);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public double getDepth() {
        return this.depth;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public List<Magnitude> getMagnitudes() {
        return this.magnitudes;
    }

    public Timestamp getOrginTime() {
        return this.orginTime;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public int getSeismicLocation() {
        return this.seismicLocation;
    }

    public int getSeismicRegion() {
        return this.seismicRegion;
    }

    public Blockette032 getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void setDepth(double depth) {
        this.depth = depth;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public void setMagnitudes(List<Magnitude> magnitudes) {
        this.magnitudes = magnitudes;
    }

    public void setOrginTime(Timestamp orginTime) {
        this.orginTime = orginTime;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setSeismicLocation(int seismicLocation) {
        this.seismicLocation = seismicLocation;
    }

    public void setSeismicRegion(int seismicRegion) {
        this.seismicRegion = seismicRegion;
    }

    public void setSourceIdentifier(Blockette032 sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }
}

