/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Blockette;
import java.sql.Timestamp;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;

@Entity
public class Blockette070
extends Blockette {
    public static final char TIME_SPAN_FLAG_E = 'E';
    public static final char TIME_SPAN_FLAG_P = 'P';
    @Column(length=1)
    private char timeSpanFlag;
    private Timestamp startTime;
    private Timestamp endTime;

    public Blockette070() {
        this.type = 70;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public char getTimeSpanFlag() {
        return this.timeSpanFlag;
    }

    public void setStartTime(Timestamp beginingTime) {
        this.startTime = beginingTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public void setTimeSpanFlag(char timeSpanFlag) {
        this.timeSpanFlag = timeSpanFlag;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.timeSpanFlag = block.getNextFixedField(1).charAt(0);
        this.startTime = Blockette.toTimestamp(block.getNextVariableField());
        this.endTime = Blockette.toTimestamp(block.getNextVariableField());
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$c", Character.valueOf(this.timeSpanFlag));
        Blockette.formatSeedTime(fmt, this.startTime);
        Blockette.formatSeedTime(fmt, this.endTime);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }
}

