/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.HistoryValue;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Blockette058
extends Blockette {
    private int stageSequence;
    private double sensitivity;
    private double freq;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="b058_id", nullable=true)
    private List<HistoryValue> historyValues = new ArrayList<HistoryValue>();

    public Blockette058() {
        this.type = 58;
    }

    public double getFreq() {
        return this.freq;
    }

    public List<HistoryValue> getHistoryValues() {
        return this.historyValues;
    }

    public double getSensitivity() {
        return this.sensitivity;
    }

    public int getStageSequence() {
        return this.stageSequence;
    }

    public void setFreq(double freq) {
        this.freq = freq;
    }

    public void setHistoryValues(List<HistoryValue> historyValues) {
        this.historyValues = historyValues;
    }

    public void setSensitivity(double sensitivity) {
        this.sensitivity = sensitivity;
    }

    public void setStageSequence(int stageSequence) {
        this.stageSequence = stageSequence;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.stageSequence = Blockette058.parseInt(block.getNextFixedField(2));
        this.sensitivity = Double.parseDouble(block.getNextFixedField(12));
        this.freq = Double.parseDouble(block.getNextFixedField(12));
        int numberOfHistoryValues = Blockette058.parseInt(block.getNextFixedField(2));
        this.historyValues = new ArrayList<HistoryValue>();
        int i = 0;
        while (i < numberOfHistoryValues) {
            HistoryValue h = new HistoryValue();
            h.setSensitivity(Double.parseDouble(block.getNextFixedField(12)));
            h.setFreq(Double.parseDouble(block.getNextFixedField(12)));
            h.setCalibrationTime(Blockette.toTimestamp(block.getNextVariableField()));
            this.historyValues.add(h);
            ++i;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Got Blockette058: " + this.toString());
        }
    }

    @Override
    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$02d%2$ 12.5E%3$ 12.5E", this.stageSequence, this.sensitivity, this.freq);
        fmt.format("%1$02d", this.historyValues.size());
        for (HistoryValue h : this.historyValues) {
            fmt.format("%1$ 12.5E%2$ 12.5E", h.getSensitivity(), h.getFreq());
            Blockette.formatSeedTime(fmt, h.getCalibrationTime(), false);
        }
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }
}

