/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import cn.org.gddsn.jopens.entity.seed.Corner;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Blockette056
extends Blockette {
    private int stageSequence;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="signalInputUnit_id", nullable=false)
    private Blockette034 signalInputUnit;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="signalOutputUnit_id", nullable=false)
    private Blockette034 signalOutputUnit;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="b056_id", nullable=true)
    private List<Corner> corners = new ArrayList<Corner>();

    public Blockette056() {
        this.type = 56;
    }

    public List<Corner> getCorners() {
        return this.corners;
    }

    public Blockette034 getSignalInputUnit() {
        return this.signalInputUnit;
    }

    public Blockette034 getSignalOutputUnit() {
        return this.signalOutputUnit;
    }

    public int getStageSequence() {
        return this.stageSequence;
    }

    public void setCorners(List<Corner> corners) {
        this.corners = corners;
    }

    public void setSignalInputUnit(Blockette034 signalInputUnit) {
        this.signalInputUnit = signalInputUnit;
    }

    public void setSignalOutputUnit(Blockette034 signalOutputUnit) {
        this.signalOutputUnit = signalOutputUnit;
    }

    public void setStageSequence(int stageSequence) {
        this.stageSequence = stageSequence;
    }

    @Override
    public void parse(Blockette block, Abbreviation abbr) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.stageSequence = Blockette056.parseInt(block.getNextFixedField(2));
        int signalInputUnit_code = Blockette056.parseInt(block.getNextFixedField(3));
        int signalOutputUnit_code = Blockette056.parseInt(block.getNextFixedField(3));
        this.signalInputUnit = abbr.findBlockette034ByIndex(signalInputUnit_code);
        this.signalOutputUnit = abbr.findBlockette034ByIndex(signalOutputUnit_code);
        int numberOfNumerators = Blockette056.parseInt(block.getNextFixedField(4));
        this.corners = new ArrayList<Corner>();
        int i = 0;
        while (i < numberOfNumerators) {
            Corner c = new Corner();
            c.setFreq(Double.parseDouble(block.getNextFixedField(12)));
            c.setSlope(Double.parseDouble(block.getNextFixedField(12)));
            this.corners.add(c);
            ++i;
        }
    }

    @Override
    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$02d%2$03d%3$03d", this.stageSequence, this.signalInputUnit != null ? this.signalInputUnit.getLookupCode() : 0, this.signalOutputUnit != null ? this.signalOutputUnit.getLookupCode() : 0);
        fmt.format("%1$04d", this.corners.size());
        for (Corner c : this.corners) {
            fmt.format("%1$ 12.5E%2$ 12.5E", c.getFreq(), c.getSlope());
        }
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }
}

