/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import cn.org.gddsn.jopens.entity.seed.Response055;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Blockette055
extends Blockette {
    private int stageSequence;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="signalInputUnit_id", nullable=false)
    private Blockette034 signalInputUnit;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="signalOutputUnit_id", nullable=false)
    private Blockette034 signalOutputUnit;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="b055_id", nullable=true)
    private List<Response055> responses = new ArrayList<Response055>();

    public Blockette055() {
        this.type = 55;
    }

    public List<Response055> getResponses() {
        return this.responses;
    }

    public Blockette034 getSignalInputUnit() {
        return this.signalInputUnit;
    }

    public Blockette034 getSignalOutputUnit() {
        return this.signalOutputUnit;
    }

    public int getStageSequence() {
        return this.stageSequence;
    }

    public void setResponses(List<Response055> responses) {
        this.responses = responses;
    }

    public void setSignalInputUnit(Blockette034 signalInputUnit) {
        this.signalInputUnit = signalInputUnit;
    }

    public void setSignalOutputUnit(Blockette034 signalOutputUnit) {
        this.signalOutputUnit = signalOutputUnit;
    }

    public void setStageSequence(int stageSequence) {
        this.stageSequence = stageSequence;
    }

    @Override
    public void parse(Blockette block, Abbreviation abbr) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.stageSequence = Blockette055.parseInt(block.getNextFixedField(2));
        int signalInputUnit_code = Blockette055.parseInt(block.getNextFixedField(3));
        int signalOutputUnit_code = Blockette055.parseInt(block.getNextFixedField(3));
        this.signalInputUnit = abbr.findBlockette034ByIndex(signalInputUnit_code);
        this.signalOutputUnit = abbr.findBlockette034ByIndex(signalOutputUnit_code);
        int numberOfResponses = Blockette055.parseInt(block.getNextFixedField(4));
        this.responses = new ArrayList<Response055>();
        int i = 0;
        while (i < numberOfResponses) {
            Response055 r = new Response055();
            r.setFreq(Double.parseDouble(block.getNextFixedField(12)));
            r.setAmp(Double.parseDouble(block.getNextFixedField(12)));
            r.setAmpError(Double.parseDouble(block.getNextFixedField(12)));
            r.setPhase(Double.parseDouble(block.getNextFixedField(12)));
            r.setPhaseError(Double.parseDouble(block.getNextFixedField(12)));
            ++i;
        }
    }

    @Override
    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$02d%2$03d%3$03d", this.stageSequence, this.signalInputUnit != null ? this.signalInputUnit.getLookupCode() : 0, this.signalOutputUnit != null ? this.signalOutputUnit.getLookupCode() : 0);
        fmt.format("%1$04d", this.responses.size());
        for (Response055 r : this.responses) {
            fmt.format("%1$ 12.5E%2$ 12.5E%3$ 12.5E%4$ 12.5E%5$ 12.5E", r.getFreq(), r.getAmp(), r.getAmpError(), r.getPhase(), r.getPhaseError());
        }
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }
}

