/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette034;
import cn.org.gddsn.jopens.entity.seed.ComplexError;
import cn.org.gddsn.jopens.entity.seed.ComplexErrorBlob;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
public class Blockette053
extends Blockette {
    private static final long serialVersionUID = 9138629629243682839L;
    @Column(length=1)
    private char transferFunctionType = (char)66;
    private int stageSequence;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="signalInputUnit_id", nullable=false)
    private Blockette034 signalInputUnit;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="signalOutputUnit_id", nullable=false)
    private Blockette034 signalOutputUnit;
    private double normalizationFactor;
    private double normalizationFrequency;
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="zero_id", nullable=false)
    private ComplexErrorBlob zeroBlob = new ComplexErrorBlob();
    @Transient
    private List<ComplexError> zeros = new ArrayList<ComplexError>();
    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="b053_pole_id", nullable=false)
    private ComplexErrorBlob poleBlob = new ComplexErrorBlob();
    @Transient
    private List<ComplexError> poles = new ArrayList<ComplexError>();

    public Blockette053() {
        this.type = 53;
    }

    public void merge(Blockette053 b053) {
    }

    public double getNormalizationFactor() {
        return this.normalizationFactor;
    }

    public double getNormalizationFrequency() {
        return this.normalizationFrequency;
    }

    public Blockette034 getSignalInputUnit() {
        return this.signalInputUnit;
    }

    public Blockette034 getSignalOutputUnit() {
        return this.signalOutputUnit;
    }

    public int getStageSequence() {
        return this.stageSequence;
    }

    public char getTransferFunctionType() {
        return this.transferFunctionType;
    }

    public List<ComplexError> getPoles() {
        if (this.poles.size() == 0) {
            this.initPoleBlob();
        }
        return this.poles;
    }

    public List<ComplexError> getZeros() {
        if (this.zeros.size() == 0) {
            this.initZeroBlob();
        }
        return this.zeros;
    }

    public void setTransferFunctionType(char transferFunctionType) {
        this.transferFunctionType = transferFunctionType;
    }

    public void setStageSequence(int stageSequence) {
        this.stageSequence = stageSequence;
    }

    public void setSignalOutputUnit(Blockette034 signalOutputUnit) {
        this.signalOutputUnit = signalOutputUnit;
    }

    public void setSignalInputUnit(Blockette034 signalInputUnit) {
        this.signalInputUnit = signalInputUnit;
    }

    public void setNormalizationFrequency(double normalizationFrequency) {
        this.normalizationFrequency = normalizationFrequency;
    }

    public void setNormalizationFactor(double normalizationFactor) {
        this.normalizationFactor = normalizationFactor;
    }

    public void setPoles(List<ComplexError> poles) {
        this.poles = poles;
        StringBuffer buf = new StringBuffer(1024);
        for (ComplexError ce : poles) {
            buf.append(String.valueOf(ce.getRealPart()) + " ");
            buf.append(String.valueOf(ce.getRealError()) + " ");
            buf.append(String.valueOf(ce.getImPart()) + " ");
            buf.append(String.valueOf(ce.getImError()) + "\n");
        }
        if (this.poleBlob == null) {
            this.poleBlob = new ComplexErrorBlob();
        }
        this.poleBlob.setComplexError(buf.substring(0));
    }

    public void setZeros(List<ComplexError> zeros) {
        this.zeros = zeros;
        StringBuffer buf = new StringBuffer(1024);
        for (ComplexError ce : zeros) {
            buf.append(String.valueOf(ce.getRealPart()) + " ");
            buf.append(String.valueOf(ce.getRealError()) + " ");
            buf.append(String.valueOf(ce.getImPart()) + " ");
            buf.append(String.valueOf(ce.getImError()) + "\n");
        }
        if (this.zeroBlob == null) {
            this.zeroBlob = new ComplexErrorBlob();
        }
        this.zeroBlob.setComplexError(buf.substring(0));
    }

    @Override
    public void parse(Blockette block, Abbreviation abbr) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.transferFunctionType = block.getNextFixedField(1).charAt(0);
        this.stageSequence = Blockette053.parseInt(block.getNextFixedField(2));
        int signalInputUnit_code = Blockette053.parseInt(block.getNextFixedField(3));
        int signalOutputUnit_code = Blockette053.parseInt(block.getNextFixedField(3));
        this.signalInputUnit = abbr.findBlockette034ByIndex(signalInputUnit_code);
        this.signalOutputUnit = abbr.findBlockette034ByIndex(signalOutputUnit_code);
        this.normalizationFactor = Double.parseDouble(block.getNextFixedField(12));
        this.normalizationFrequency = Double.parseDouble(block.getNextFixedField(12));
        int numberOfZeros = Blockette053.parseInt(block.getNextFixedField(3));
        ArrayList<ComplexError> zeros1 = new ArrayList<ComplexError>();
        int i = 0;
        while (i < numberOfZeros) {
            ComplexError zero = new ComplexError();
            zero.setRealPart(Double.parseDouble(block.getNextFixedField(12)));
            zero.setImPart(Double.parseDouble(block.getNextFixedField(12)));
            zero.setRealError(Double.parseDouble(block.getNextFixedField(12)));
            zero.setImError(Double.parseDouble(block.getNextFixedField(12)));
            zeros1.add(zero);
            ++i;
        }
        this.setZeros(zeros1);
        int numberOfPoles = Blockette053.parseInt(block.getNextFixedField(3));
        ArrayList<ComplexError> poles1 = new ArrayList<ComplexError>();
        int i2 = 0;
        while (i2 < numberOfPoles) {
            ComplexError pole = new ComplexError();
            pole.setRealPart(Double.parseDouble(block.getNextFixedField(12)));
            pole.setImPart(Double.parseDouble(block.getNextFixedField(12)));
            pole.setRealError(Double.parseDouble(block.getNextFixedField(12)));
            pole.setImError(Double.parseDouble(block.getNextFixedField(12)));
            poles1.add(pole);
            ++i2;
        }
        this.setPoles(poles1);
    }

    @Override
    public String toBlockette() {
        this.getPoles();
        this.getZeros();
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$c%2$02d%3$03d%4$03d", Character.valueOf(this.transferFunctionType), this.stageSequence, this.signalInputUnit != null ? this.signalInputUnit.getLookupCode() : 0, this.signalOutputUnit != null ? this.signalOutputUnit.getLookupCode() : 0);
        fmt.format("%1$ 12.5E%2$ 12.5E", this.normalizationFactor, this.normalizationFrequency);
        fmt.format("%1$03d", this.zeros.size());
        for (ComplexError z : this.zeros) {
            fmt.format("%1$ 12.5E%2$ 12.5E%3$ 12.5E%4$ 12.5E", z.getRealPart(), z.getImPart(), z.getRealError(), z.getImError());
        }
        fmt.format("%1$03d", this.poles.size());
        for (ComplexError p : this.poles) {
            fmt.format("%1$ 12.5E%2$ 12.5E%3$ 12.5E%4$ 12.5E", p.getRealPart(), p.getImPart(), p.getRealError(), p.getImError());
        }
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public ComplexErrorBlob getPoleBlob() {
        return this.poleBlob;
    }

    public void setPoleBlob(ComplexErrorBlob poleBlob) {
        this.poleBlob = poleBlob;
        this.initPoleBlob();
    }

    public ComplexErrorBlob getZeroBlob() {
        return this.zeroBlob;
    }

    public void setZeroBlob(ComplexErrorBlob zeroBlob) {
        this.zeroBlob = zeroBlob;
        this.initZeroBlob();
    }

    private void initZeroBlob() {
        String zeroLine = this.zeroBlob.getComplexError();
        if (zeroLine == null) {
            logger.warn("coluld not found zero data for Blockette053 id=" + this.getId());
            return;
        }
        StringTokenizer st = new StringTokenizer(zeroLine);
        int n = st.countTokens() / 4;
        this.zeros.clear();
        int i = 0;
        while (i < n) {
            ComplexError ce = new ComplexError();
            ce.setRealPart(Double.parseDouble(st.nextToken()));
            ce.setRealError(Double.parseDouble(st.nextToken()));
            ce.setImPart(Double.parseDouble(st.nextToken()));
            ce.setImError(Double.parseDouble(st.nextToken()));
            this.zeros.add(ce);
            ++i;
        }
    }

    private void initPoleBlob() {
        String poleLine = this.poleBlob.getComplexError();
        if (poleLine == null) {
            logger.warn("coluld not found pole data for Blockette053 id=" + this.getId());
            return;
        }
        StringTokenizer st = new StringTokenizer(poleLine);
        int n = st.countTokens() / 4;
        this.poles.clear();
        int i = 0;
        while (i < n) {
            ComplexError ce = new ComplexError();
            ce.setRealPart(Double.parseDouble(st.nextToken()));
            ce.setRealError(Double.parseDouble(st.nextToken()));
            ce.setImPart(Double.parseDouble(st.nextToken()));
            ce.setImError(Double.parseDouble(st.nextToken()));
            this.poles.add(ce);
            ++i;
        }
    }
}

