/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import cn.org.gddsn.jopens.entity.seed.Blockette031;
import java.sql.Timestamp;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;

@Entity
public class Blockette051
extends Blockette {
    private Timestamp startTime;
    private Timestamp endTime;
    @OneToOne(cascade={CascadeType.MERGE})
    @JoinColumn(name="b031_id", nullable=false)
    private Blockette031 comment;
    private int commentLevel;

    public Blockette051() {
        this.type = 51;
    }

    public Timestamp getEndTime() {
        return this.endTime;
    }

    public int getCommentLevel() {
        return this.commentLevel;
    }

    public Timestamp getStartTime() {
        return this.startTime;
    }

    public void setEndTime(Timestamp endTime) {
        this.endTime = endTime;
    }

    public void setCommentLevel(int level) {
        this.commentLevel = level;
    }

    public void setStartTime(Timestamp startTime) {
        this.startTime = startTime;
    }

    public void parse(Blockette block, Abbreviation abbr) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.startTime = Blockette.toTimestamp(block.getNextVariableField());
        this.endTime = Blockette.toTimestamp(block.getNextVariableField());
        int codeKey = Blockette051.parseInt(block.getNextFixedField(4));
        this.comment = abbr.findBlockette031ByIndex(codeKey);
        this.commentLevel = Blockette051.parseInt(block.getNextFixedField(6));
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        Blockette.formatSeedTime(fmt, this.startTime, false);
        Blockette.formatSeedTime(fmt, this.endTime, false);
        fmt.format("%1$04d%2$06d", this.comment != null ? this.comment.getCodeKey() : 0, this.commentLevel);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public Blockette031 getComment() {
        return this.comment;
    }

    public void setComment(Blockette031 comment) {
        this.comment = comment;
    }
}

