/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class Blockette033
extends Blockette {
    private int lookupCode;
    @Column(length=50)
    private String description;
    @ManyToOne
    @JoinColumn(name="abbr_id", nullable=true)
    private Abbreviation abbreviation;

    public Blockette033() {
        this.type = 33;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLookupCode() {
        return this.lookupCode;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setLookupCode(int lookupCode) {
        this.lookupCode = lookupCode;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.lookupCode = Blockette033.parseInt(block.getNextFixedField(3));
        this.description = block.getNextVariableField();
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$03d%2$s~", this.lookupCode, this.description);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public Abbreviation getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(Abbreviation abbreviation) {
        this.abbreviation = abbreviation;
    }
}

