/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class Blockette032
extends Blockette {
    private int lookupCode;
    @Column(length=70)
    private String author = "";
    @Column(length=70)
    private String dateCatalog;
    @Column(length=50)
    private String publisher;
    @ManyToOne
    @JoinColumn(name="abbr_id", nullable=true)
    private Abbreviation abbreviation;

    public Blockette032() {
        this.type = 32;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDateCatalog() {
        return this.dateCatalog;
    }

    public int getLookupCode() {
        return this.lookupCode;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public void setLookupCode(int lookupCode) {
        this.lookupCode = lookupCode;
    }

    public void setDateCatalog(String dateCatalog) {
        this.dateCatalog = dateCatalog;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.lookupCode = Blockette032.parseInt(block.getNextFixedField(2));
        this.author = block.getNextVariableField();
        this.dateCatalog = block.getNextVariableField();
        this.publisher = block.getNextVariableField();
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$02d%2$s~%3$s~%4$s~", this.lookupCode, this.author, this.dateCatalog, this.publisher);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public Abbreviation getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(Abbreviation abbreviation) {
        this.abbreviation = abbreviation;
    }
}

