/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import java.util.Formatter;
import java.util.Locale;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;

@Entity
public class Blockette031
extends Blockette {
    private int codeKey;
    private char classCode;
    @Column(length=70)
    private String description = "Time correction does not include";
    private int unit;
    @ManyToOne
    @JoinColumn(name="abbr_id", nullable=true)
    private Abbreviation abbreviation;

    public Blockette031() {
        this.type = 31;
    }

    public char getClassCode() {
        return this.classCode;
    }

    public int getCodeKey() {
        return this.codeKey;
    }

    public String getDescription() {
        return this.description;
    }

    public int getUnit() {
        return this.unit;
    }

    public void setUnit(int unit) {
        this.unit = unit;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCodeKey(int codeKey) {
        this.codeKey = codeKey;
    }

    public void setClassCode(char classCode) {
        this.classCode = classCode;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.codeKey = Blockette031.parseInt(block.getNextFixedField(4));
        this.classCode = block.getNextFixedField(1).charAt(0);
        this.description = block.getNextVariableField();
        this.unit = Blockette031.parseInt(block.getNextFixedField(3));
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        fmt.format("%1$04d%2$c%3$s~%4$03d", this.codeKey, Character.valueOf(this.classCode), this.description, this.unit);
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public Abbreviation getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(Abbreviation abbreviation) {
        this.abbreviation = abbreviation;
    }
}

