/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity.seed;

import cn.org.gddsn.jopens.entity.seed.Abbreviation;
import cn.org.gddsn.jopens.entity.seed.Blockette;
import java.util.Formatter;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;

@Entity
public class Blockette030
extends Blockette {
    @Column(length=50)
    private String description = "";
    private int dataFormat;
    private int dataFamilyType;
    @Lob
    private String keyBlob;
    @ManyToOne
    @JoinColumn(name="abbr_id", nullable=true)
    private Abbreviation abbreviation;

    public Blockette030() {
        this.type = 30;
    }

    public int getDataFamilyType() {
        return this.dataFamilyType;
    }

    public int getDataFormat() {
        return this.dataFormat;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDataFormat(int dataFormat) {
        this.dataFormat = dataFormat;
    }

    public void setDataFamilyType(int dataFamilyType) {
        this.dataFamilyType = dataFamilyType;
    }

    public void parse(Blockette block) {
        this.setBlocketteLength(block.getBlocketteLength());
        this.description = block.getNextVariableField();
        this.dataFormat = Blockette030.parseInt(block.getNextFixedField(4));
        this.dataFamilyType = Blockette030.parseInt(block.getNextFixedField(3));
        int numberOfKey = Blockette030.parseInt(block.getNextFixedField(2));
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < numberOfKey) {
            sb.append(block.getNextVariableField());
            sb.append('\n');
            ++i;
        }
        this.keyBlob = sb.substring(0);
    }

    public String toBlockette() {
        StringBuilder sb = new StringBuilder();
        Formatter fmt = new Formatter(sb, Locale.ENGLISH);
        StringTokenizer st = new StringTokenizer(this.keyBlob, "\r\n");
        fmt.format("%1$s~%2$04d%3$03d%4$02d", this.description, this.dataFormat, this.dataFamilyType, st.countTokens());
        while (st.hasMoreTokens()) {
            fmt.format("%1$s~", st.nextToken());
        }
        this.blocketteLength = sb.length() + 7;
        return String.valueOf(super.toBlockette()) + sb.substring(0);
    }

    public Abbreviation getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(Abbreviation abbreviation) {
        this.abbreviation = abbreviation;
    }

    public String getKeyBlob() {
        return this.keyBlob;
    }

    public void setKeyBlob(String keyBlob) {
        this.keyBlob = keyBlob;
    }
}

