/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity;

import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.seed.Channel;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import edu.iris.miniseedutils.steim.MiniSeedChunk;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.log4j.Logger;

@MappedSuperclass
public class Waveform
implements Serializable {
    private static final long serialVersionUID = -2318473921315532021L;
    static Logger logger = Logger.getLogger(Waveform.class);
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    private long id;
    @Embedded
    private ChannelLocator channelLocator;
    @Column(name="Serial_number", length=6, nullable=false)
    private int serialNumber;
    @Column(name="Nsamples", length=6, nullable=false)
    private int nsamples;
    @Column(name="Samp_rate", length=6, nullable=false)
    private float sampRate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="Start_time", nullable=false)
    private Date startTime;
    @Column(name="Start_time_frac", length=6, nullable=false)
    private int startTimeFrac;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="End_time", nullable=false)
    private Date endTime;
    @Column(name="End_time_frac", length=6, nullable=false)
    private int endTimeFrac;
    @Column(name="Encode_format", length=6, nullable=false)
    private int encodeFormat;
    @Column(name="Active_flag", length=6, nullable=false)
    private int activeFlag;
    @Column(name="Word_order", length=6, nullable=false)
    private int wordOrder;
    @Column(name="Rec_lenth", length=6, nullable=false)
    private int recLenth;
    @Transient
    private int chunkSize = 1;
    @Lob
    @Column(name="Waveform")
    private byte[] waveform;
    @ManyToOne
    @JoinColumn(name="Channel_id", nullable=true)
    private Channel channel;

    public Waveform() {
    }

    public Waveform(MiniSeedChunk m) {
        this.channelLocator = new ChannelLocator(m.getNetwork(), m.getStation(), m.getLocID(), m.getChannel());
        this.serialNumber = Integer.parseInt(m.getSequenceNumber().trim());
        this.sampRate = (float)m.getSampleRate();
        this.nsamples = m.getNumSamples();
        long sec = (long)m.getStartTime();
        this.startTime = new Date(sec * 1000L);
        this.startTimeFrac = (int)((m.getStartTime() - (double)sec) * 10000.0);
        sec = (long)m.getEndTime();
        this.endTime = new Date(sec * 1000L);
        this.endTimeFrac = (int)((m.getEndTime() - (double)sec) * 10000.0);
        this.recLenth = m.getRecordLength();
        this.wordOrder = m.getWordOrder();
        this.activeFlag = m.getActiveFlag();
        this.encodeFormat = m.getDataFormat();
        this.waveform = new byte[m.getLength()];
        System.arraycopy(m.getData(), 0, this.waveform, 0, this.waveform.length);
    }

    public Waveform(GenericMiniSeedRecord gmsr) {
        this.channelLocator = new ChannelLocator(gmsr.getNetwork(), gmsr.getStation(), gmsr.getLocID(), gmsr.getChannel());
        this.serialNumber = Integer.parseInt(gmsr.getSequenceNumber().trim());
        this.sampRate = (float)gmsr.getSampleRate();
        this.nsamples = gmsr.getNumSamples();
        this.startTime = new Date(gmsr.getStartTime().getTime() / 1000L * 1000L);
        this.startTimeFrac = gmsr.getStartTime().getNanos() / 100000;
        this.recLenth = gmsr.getRecordLength();
        this.wordOrder = gmsr.getWordOrder();
        this.activeFlag = gmsr.getActiveFlag();
        this.encodeFormat = gmsr.getDataFormat();
        long ns = (long)((double)(gmsr.getNumSamples() * 1000) / gmsr.getSampleRate()) * 1000000L + (long)gmsr.getStartTime().getNanos();
        if (ns < 0L) {
            ns = 0L;
            logger.warn("Error: naosec<0");
            logger.warn("smps: " + gmsr.getNumSamples() + "\tsrate: " + gmsr.getSampleRate() + "\tstart_naos: " + gmsr.getStartTime().getNanos());
            logger.warn(gmsr);
        }
        Timestamp endTS = new Timestamp((gmsr.getStartTime().getTime() / 1000L + ns / 1000000000L) * 1000L);
        endTS.setNanos((int)(ns %= 1000000000L));
        this.endTime = new Date(endTS.getTime() / 1000L * 1000L);
        this.endTimeFrac = endTS.getNanos() / 100000;
        this.waveform = gmsr.getBytes();
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getWordOrder() {
        return this.wordOrder;
    }

    public void setWordOrder(int wordOrder) {
        this.wordOrder = wordOrder;
    }

    public int getRecLenth() {
        return this.recLenth;
    }

    public void setRecLenth(int recLenth) {
        this.recLenth = recLenth;
    }

    public float getSampRate() {
        return this.sampRate;
    }

    public void setSampRate(float sampRate) {
        this.sampRate = sampRate;
    }

    public byte[] getWaveform() {
        return this.waveform;
    }

    public void setWaveform(byte[] waveform) {
        this.waveform = waveform;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public int getEndTimeFrac() {
        return this.endTimeFrac;
    }

    public void setEndTimeFrac(int endTimeFrac) {
        this.endTimeFrac = endTimeFrac;
    }

    public int getNsamples() {
        return this.nsamples;
    }

    public void setNsamples(int nsamples) {
        this.nsamples = nsamples;
    }

    public int getStartTimeFrac() {
        return this.startTimeFrac;
    }

    public void setStartTimeFrac(int startTimeFrac) {
        this.startTimeFrac = startTimeFrac;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public int getEncodeFormat() {
        return this.encodeFormat;
    }

    public void setEncodeFormat(int encodeFormat) {
        this.encodeFormat = encodeFormat;
    }

    public int getActiveFlag() {
        return this.activeFlag;
    }

    public void setActiveFlag(int activeFlag) {
        this.activeFlag = activeFlag;
    }

    public ChannelLocator getChannelLocator() {
        return this.channelLocator;
    }

    public void setChannelLocator(ChannelLocator channelLocator) {
        this.channelLocator = channelLocator;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }
}

