/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.entity;

import cn.org.gddsn.jopens.entity.ChannelLocator;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.jopens.entity.Pick;
import cn.org.gddsn.jopens.entity.StationMagnitude;
import java.io.Serializable;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="Auto_flag", length=1, discriminatorType=DiscriminatorType.STRING)
public class Catalog
implements Serializable {
    private static final long serialVersionUID = -7910771681106846950L;
    @Id
    @Column(name="id", length=40)
    private String id;
    @ManyToOne
    @JoinColumn(name="Event_id", nullable=true)
    private EventInfo eventInfo;
    @Column(name="Net_code", length=2)
    private String netCode;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="Save_time")
    private Date saveTime;
    @Column(name="Operator", length=20)
    private String operator;
    @Column(name="Loc_program", length=20)
    private String locProgram;
    @Column(name="Eq_type", length=40)
    private String eqType;
    @Column(name="Sequen_name", length=128)
    private String sequenName;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="O_time")
    private Date originTime;
    @Column(name="O_time_frac")
    private int originTimeFrac;
    @Column(name="Epi_lat", precision=3)
    private float lat;
    @Column(name="Epi_lon", precision=3)
    private float lon;
    @Column(name="Epi_depth", precision=3)
    private float depth;
    @Column(name="Depfix_flag")
    private int depfixFlag;
    @Column(name="M")
    private float m;
    @Column(name="M_source", length=4)
    private String mSource;
    @Column(name="SPmin", precision=3)
    private float spmin;
    @Column(name="Dmin", precision=2)
    private float dmin;
    @Column(name="Gap_azi", precision=1)
    private float gapAzi;
    @Column(name="Rms", precision=3)
    private float rms;
    @Column(name="Erh", precision=3)
    private float erh;
    @Column(name="Erz", precision=3)
    private float erz;
    @Column(name="Qloc", length=3)
    private String qloc;
    @Column(name="Qnet", length=3)
    private String qnet;
    @Column(name="Qcom", length=3)
    private String qcom;
    @Column(name="Sum_stn")
    private int sumStn;
    @Column(name="Loc_stn")
    private int locStn;
    @Column(name="Sum_pha")
    private int sumPha;
    @Column(name="Loc_pha")
    private int locPha;
    @Column(name="Epic_id", length=2)
    private String epicId;
    @Column(name="Source_id", length=2)
    private String sourceId;
    @Column(name="Location_cname", length=128)
    private String location;
    @Column(name="Location_sname", length=128)
    private String locationSname;
    @Column(name="FE_num")
    private int feNum;
    @Column(name="FE_sname", length=128)
    private String feSname;
    @Column(name="FE_cname", length=128)
    private String feCname;
    @Column(name="Eq_name", length=128)
    private String eqName;
    @Column(name="Model_name", length=20)
    private String modelName;
    @Column(name="Lock_flag", length=1)
    private String lock;
    @Column(name="Remark", length=128)
    private String remark;
    @Column(name="Cata_name", length=40)
    private String cataName;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="Catalog_id")
    private List<Phase> phases;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinColumn(name="Catalog_id")
    private Set<Mag> mags;
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="Catalog_id")
    private List<StationMagnitude> stationMagnitudes;

    public Catalog() {
        this.fillDefaultValue();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCataName() {
        return this.cataName;
    }

    public void setCataName(String cataId) {
        this.cataName = cataId;
    }

    public String getNetCode() {
        return this.netCode;
    }

    public void setNetCode(String netCode) {
        this.netCode = netCode;
    }

    public int getSumPha() {
        return this.sumPha;
    }

    public void setSumPha(int sumPha) {
        this.sumPha = sumPha;
    }

    public int getSumStn() {
        return this.sumStn;
    }

    public void setSumStn(int sumStn) {
        this.sumStn = sumStn;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public String getMSource() {
        return this.mSource;
    }

    public void setMSource(String mSource) {
        this.mSource = mSource;
    }

    public float getErz() {
        return this.erz;
    }

    public void setErz(float erz) {
        this.erz = erz;
    }

    public String getQloc() {
        return this.qloc;
    }

    public void setQloc(String qloc) {
        this.qloc = qloc;
    }

    public float getGapAzi() {
        return this.gapAzi;
    }

    public void setGapAzi(float gapAzi) {
        this.gapAzi = gapAzi;
    }

    public String getQnet() {
        return this.qnet;
    }

    public void setQnet(String qnet) {
        this.qnet = qnet;
    }

    public float getLon() {
        return this.lon;
    }

    public void setLon(float epiLon) {
        this.lon = epiLon;
    }

    public int getLocPha() {
        return this.locPha;
    }

    public void setLocPha(int locPha) {
        this.locPha = locPha;
    }

    public float getErh() {
        return this.erh;
    }

    public void setErh(float erh) {
        this.erh = erh;
    }

    public String getLocationSname() {
        return this.locationSname;
    }

    public void setLocationSname(String locationSname) {
        this.locationSname = locationSname;
    }

    public int getLocStn() {
        return this.locStn;
    }

    public void setLocStn(int locStn) {
        this.locStn = locStn;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public Date getSaveTime() {
        return this.saveTime;
    }

    public void setSaveTime(Date saveTime) {
        this.saveTime = saveTime;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public float getDmin() {
        return this.dmin;
    }

    public void setDmin(float dmin) {
        this.dmin = dmin;
    }

    public float getLat() {
        return this.lat;
    }

    public void setLat(float epiLat) {
        this.lat = epiLat;
    }

    public String getEqType() {
        return this.eqType;
    }

    public void setEqType(String eqType) {
        this.eqType = eqType;
    }

    public Date getOriginTime() {
        return this.originTime;
    }

    public void setOriginTime(Date oTime) {
        this.originTime = oTime;
    }

    public float getM() {
        return this.m;
    }

    public void setM(float m) {
        this.m = m;
    }

    public int getFeNum() {
        return this.feNum;
    }

    public void setFeNum(int feNum) {
        this.feNum = feNum;
    }

    public String getQcom() {
        return this.qcom;
    }

    public void setQcom(String qcom) {
        this.qcom = qcom;
    }

    public int getOriginTimeFrac() {
        return this.originTimeFrac;
    }

    public void setOriginTimeFrac(int oTimeFrac) {
        this.originTimeFrac = oTimeFrac;
    }

    public float getSpmin() {
        return this.spmin;
    }

    public void setSpmin(float spmin) {
        this.spmin = spmin;
    }

    public float getDepth() {
        return this.depth;
    }

    public void setDepth(float epiDepth) {
        this.depth = epiDepth;
    }

    public String getEqName() {
        return this.eqName;
    }

    public void setEqName(String eqName) {
        this.eqName = eqName;
    }

    public String getLocProgram() {
        return this.locProgram;
    }

    public void setLocProgram(String locProgram) {
        this.locProgram = locProgram;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getSequenName() {
        return this.sequenName;
    }

    public void setSequenName(String sequenName) {
        this.sequenName = sequenName;
    }

    public String getFeSname() {
        return this.feSname;
    }

    public void setFeSname(String feSnmae) {
        this.feSname = feSnmae;
    }

    public String getEpicId() {
        return this.epicId;
    }

    public void setEpicId(String epicId) {
        this.epicId = epicId;
    }

    public int getDepfixFlag() {
        return this.depfixFlag;
    }

    public void setDepfixFlag(int depfixFlag) {
        this.depfixFlag = depfixFlag;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    public float getRms() {
        return this.rms;
    }

    public void setRms(float rms) {
        this.rms = rms;
    }

    public EventInfo getEventInfo() {
        return this.eventInfo;
    }

    public void setEventInfo(EventInfo eventInfo) {
        this.eventInfo = eventInfo;
    }

    public List<Phase> getPhases() {
        return this.phases;
    }

    public void setPhases(List<Phase> phases) {
        this.phases = phases;
    }

    public Set<Mag> getMags() {
        return this.mags;
    }

    public void setMags(Set<Mag> mags) {
        this.mags = mags;
    }

    public String getFeCname() {
        return this.feCname;
    }

    public void setFeCname(String feCname) {
        this.feCname = feCname;
    }

    public String getLock() {
        return this.lock;
    }

    public void setLock(String lock) {
        this.lock = lock;
    }

    public Mag findNetworkMagnitude(String magName) {
        for (Mag m : this.mags) {
            if (!m.getMagType().getId().equalsIgnoreCase(magName)) continue;
            return m.getMagVal() > 0.0f ? m : null;
        }
        return null;
    }

    public Hashtable<String, Float> getMagList(String magName) {
        Hashtable<String, Float> tbl = new Hashtable<String, Float>(64);
        for (Phase p : this.getPhases()) {
            if (p.getMagType() == null || !p.getMagType().getId().equalsIgnoreCase(magName)) continue;
            tbl.put(String.valueOf(p.getChannelLocator().getNetCode()) + "/" + p.getChannelLocator().getStationCode(), Float.valueOf(p.getMagVal()));
        }
        return tbl;
    }

    public Mag findNetworkMagnitude(long magId) {
        Mag m = null;
        for (Mag mag : this.mags) {
            if (mag.getId() != magId) continue;
            if (mag.getMagVal() > 0.0f) {
                m = mag;
                break;
            }
            m = null;
            break;
        }
        return m;
    }

    private void fillDefaultValue() {
        float dv = -99999.0f;
        int idv = -99999;
        this.setOperator("importer");
        this.setSaveTime(new Date());
        this.setLocProgram(null);
        this.setOriginTime(new Date());
        this.setOriginTimeFrac(0);
        this.setLat(dv);
        this.setLon(dv);
        this.setDepth(dv);
        this.setDepfixFlag(0);
        this.setM(dv);
        this.setMSource("Ms");
        this.setSpmin(dv);
        this.setDmin(dv);
        this.setGapAzi(dv);
        this.setRms(dv);
        this.setErh(dv);
        this.setErz(dv);
        this.setSumPha(idv);
        this.setLocStn(idv);
        this.setLocPha(idv);
        this.setFeNum(idv);
    }

    public void updateCatalog(Catalog c) {
        this.netCode = c.netCode;
        this.saveTime = new Date(c.saveTime.getTime());
        this.operator = c.operator;
        this.locProgram = c.locProgram;
        this.eqType = c.eqType;
        this.sequenName = c.sequenName;
        this.originTime = new Date(c.originTime.getTime());
        this.originTimeFrac = c.originTimeFrac;
        this.lat = c.lat;
        this.lon = c.lon;
        this.depth = c.depth;
        this.depfixFlag = c.depfixFlag;
        this.m = c.m;
        this.mSource = c.mSource;
        this.spmin = c.spmin;
        this.dmin = c.dmin;
        this.gapAzi = c.gapAzi;
        this.rms = c.rms;
        this.erh = c.erh;
        this.erz = c.erz;
        this.qloc = c.qloc;
        this.qnet = c.qnet;
        this.qcom = c.qcom;
        this.sumStn = c.sumStn;
        this.locStn = c.locStn;
        this.sumPha = c.sumPha;
        this.locPha = c.locPha;
        this.epicId = c.epicId;
        this.sourceId = c.sourceId;
        this.location = c.location;
        this.locationSname = c.locationSname;
        this.feNum = c.feNum;
        this.feSname = c.feSname;
        this.feCname = c.feCname;
        this.eqName = c.eqName;
        this.modelName = c.modelName;
        this.lock = c.lock;
        this.remark = c.remark;
        this.cataName = c.cataName;
    }

    public Phase findPhaseByName(String pckId) {
        for (Phase p : this.phases) {
            if (!p.getPick().getId().equals(pckId)) continue;
            return p;
        }
        return null;
    }

    public Phase findPhase(ChannelLocator cl, String phn) {
        for (Phase p : this.phases) {
            if (!p.getPick().getChannelLocator().equals(cl) || !p.getPhaseName().equals(phn)) continue;
            return p;
        }
        return null;
    }

    public Pick findPick(ChannelLocator cl) {
        for (Phase p : this.phases) {
            if (!p.getPick().getChannelLocator().equals(cl)) continue;
            return p.getPick();
        }
        return null;
    }

    public StationMagnitude findStationMagnitude(String magId) {
        for (StationMagnitude sm : this.stationMagnitudes) {
            if (!sm.getId().equals(magId)) continue;
            return sm;
        }
        return null;
    }

    public StationMagnitude findStationMagnitude(ChannelLocator cl, String magType) {
        for (StationMagnitude sm : this.stationMagnitudes) {
            if (!sm.getMagnitudeType().equals(magType) || !sm.getStationAmplitude().getPick().equals(cl)) continue;
            return sm;
        }
        return null;
    }

    public List<StationMagnitude> getStationMagnitudes() {
        return this.stationMagnitudes;
    }

    public void setStationMagnitudes(List<StationMagnitude> stationMagnitudes) {
        this.stationMagnitudes = stationMagnitudes;
    }
}

