/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.client;

import cn.org.gddsn.liss.port.event.MiniSeedPortEvent;
import cn.org.gddsn.liss.port.event.MiniSeedPortEventListener;
import cn.org.gddsn.liss.port.sss.SSSPort;
import edu.iris.miniseedutils.steim.GenericMiniSeedRecord;
import javax.jms.BytesMessage;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

public class WaveformJmsSender
implements MiniSeedPortEventListener {
    private JmsTemplate jmsTemplate;
    private Topic topic;
    static XmlBeanFactory factory = null;

    public void send(final GenericMiniSeedRecord gmsr) {
        this.jmsTemplate.send(this.topic, new MessageCreator(){

            public Message createMessage(Session session) throws JMSException {
                BytesMessage bmsg = session.createBytesMessage();
                bmsg.writeBytes(gmsr.getBytes());
                bmsg.setJMSDeliveryMode(2);
                bmsg.setIntProperty("Serial_number", Integer.parseInt(gmsr.getSequenceNumber().trim()));
                bmsg.setStringProperty("Net_code", gmsr.getNetwork());
                bmsg.setStringProperty("Sta_code", gmsr.getStation());
                bmsg.setStringProperty("Loc_id", gmsr.getLocID());
                bmsg.setStringProperty("Chn_code", gmsr.getChannel());
                bmsg.setLongProperty("Event_id", 0L);
                bmsg.setDoubleProperty("sampRate", gmsr.getSampleRate());
                bmsg.setLongProperty("Start_time", gmsr.getStartTime().getTime());
                bmsg.setIntProperty("Active_flag", gmsr.getActiveFlag());
                return bmsg;
            }
        });
    }

    public void setConnectionFactory(ConnectionFactory cf) {
        this.jmsTemplate = new JmsTemplate(cf);
    }

    public void setTopic(Topic topic) {
        this.topic = topic;
    }

    public void miniSeedEvent(MiniSeedPortEvent MiniSeedPortEvent2) {
        this.send(MiniSeedPortEvent2.getGenericMiniSeedRecord());
    }

    public static void main(String[] args) {
        FileSystemResource res = new FileSystemResource("JOPENS-service.xml");
        factory = new XmlBeanFactory(res);
        WaveformJmsSender sender = (WaveformJmsSender)factory.getBean("waveformJmsSender");
        SSSPort sssPort = (SSSPort)factory.getBean("sssPort");
        sssPort.addMiniSeedPortEventListener(sender);
    }

    public JmsTemplate getJmsTemplate() {
        return this.jmsTemplate;
    }

    public void setJmsTemplate(JmsTemplate jmsTemplate) {
        this.jmsTemplate = jmsTemplate;
    }
}

