/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.jopens.client;

import cn.org.gddsn.jopens.entity.Catalog;
import cn.org.gddsn.jopens.entity.CatalogC;
import cn.org.gddsn.jopens.entity.EventInfo;
import cn.org.gddsn.jopens.entity.Mag;
import cn.org.gddsn.jopens.entity.Phase;
import cn.org.gddsn.jopens.entity.UniEventId;
import cn.org.gddsn.jopens.service.SeedVolumeService;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.log4j.Logger;
import org.springframework.context.support.FileSystemXmlApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniCatalogClient {
    static Logger logger = Logger.getLogger(UniCatalogClient.class);
    private SeedVolumeService bulletinService;
    private EventInfo localEventInfo;

    public void setLocalEventInfo(EventInfo localEventInfo) throws Exception {
        this.localEventInfo = UniCatalogClient.copyEventInfo(localEventInfo);
        this.localEventInfo.setUniEventId(null);
        Iterator<Catalog> it = this.localEventInfo.getCatalogs().iterator();
        while (it.hasNext()) {
            Catalog c = it.next();
            if (c instanceof CatalogC) continue;
            it.remove();
        }
        if (this.localEventInfo.getCatalogs().size() == 0) {
            throw new IllegalArgumentException("EventInfo should contain C type Catalog.");
        }
    }

    public void init(String bulletionConfFile) throws Exception {
        FileSystemXmlApplicationContext ctx = new FileSystemXmlApplicationContext(new String[]{bulletionConfFile});
        this.bulletinService = (SeedVolumeService)ctx.getBean("bulletinService");
    }

    public void addEventInfo() throws Exception {
        UniEventId uniEventId = new UniEventId();
        uniEventId.setSaveTime(new Date());
        uniEventId.setNationEventId(this.localEventInfo.getEventId());
        LinkedList<EventInfo> col = new LinkedList<EventInfo>();
        col.add(this.localEventInfo);
        uniEventId.setEventInfos(col);
        this.localEventInfo.setUniEventId(uniEventId);
        this.bulletinService.writeUniEventId(uniEventId);
    }

    public void deleteEventInfo() throws Exception {
        this.bulletinService.deleteEventInfo(this.localEventInfo.getEventId(), false);
    }

    public void matchEventInfo(String uniEventId) throws Exception {
        this.bulletinService.updateUniEventId(uniEventId, this.localEventInfo);
    }

    public List<Catalog> findCatalog(float maxOriginDiff, float maxLocDiff, float maxMagDiff) throws Exception {
        return this.bulletinService.findCatalog(this.localEventInfo, maxOriginDiff, maxLocDiff, maxMagDiff);
    }

    public Catalog findCatalog(String cataId) throws Exception {
        return this.bulletinService.findCatalog(cataId);
    }

    private static EventInfo copyEventInfo(EventInfo from) {
        EventInfo to = new EventInfo();
        try {
            BeanUtils.copyProperties((Object)to, (Object)from);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        to.setDataless(null);
        for (Catalog c : to.getCatalogs()) {
            c.setEventInfo(to);
            for (Mag m : c.getMags()) {
                m.setId(0L);
                m.setCatalog(c);
            }
            for (Phase p : c.getPhases()) {
                p.setId(0L);
                p.setCatalog(c);
            }
        }
        return to;
    }

    public SeedVolumeService getBulletinService() {
        return this.bulletinService;
    }

    public void setBulletinService(SeedVolumeService bulletinService) {
        this.bulletinService = bulletinService;
    }

    public static void main(String[] args) throws Exception {
        UniCatalogClient client = new UniCatalogClient();
        client.init("bulletin.xml");
    }
}

