/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Date;
import java.util.GregorianCalendar;

public class Logger {
    public static final int LOG_EMERG = 0;
    public static final int LOG_ALERT = 1;
    public static final int LOG_CRIT = 2;
    public static final int LOG_ERR = 3;
    public static final int LOG_WARNING = 4;
    public static final int LOG_NOTICE = 5;
    public static final int LOG_INFO = 6;
    public static final int LOG_DEBUG = 7;
    public static final int LOG_OFF = -1;
    public static final String[] priorityNames = new String[]{"EMERG", "ALERT", "CRIT", "ERR", "WARNING", "NOTICE", "INFO", "DEBUG"};
    private static PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(System.err), true);
    private static int priority = -1;
    private static int fileCount = 10;
    private static int maxFileSize = 1024;
    private static File logFile;
    private static boolean bSizeOrTime;
    private static int sleepTime;
    private static int week_of_year;
    private static boolean bStop;
    private static Thread archiveThread;

    static {
        bSizeOrTime = false;
        sleepTime = 60000;
        bStop = false;
    }

    private Logger() {
    }

    public static void setWriter(PrintWriter writer) {
        Logger.writer = writer;
    }

    public static void setFile(File logFile) {
        Logger.logFile = logFile;
        try {
            FileOutputStream outputStream = new FileOutputStream(Logger.logFile.getPath(), true);
            writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        archiveThread = new FileMgrThread();
        archiveThread.start();
    }

    public static void setPriority(int priority) {
        Logger.priority = priority;
    }

    public static void log(int priority, String message) {
        if (priority <= Logger.priority && writer != null) {
            writer.println(new Date() + "\t" + priorityNames[priority] + "\t" + message);
        }
    }

    public static void setArchiveFileCount(int archiveFileCount) {
        fileCount = archiveFileCount;
    }

    public static void setWhen(String when) {
        try {
            maxFileSize = Integer.parseInt(when);
            bSizeOrTime = false;
        }
        catch (NumberFormatException nEx) {
            bSizeOrTime = true;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            week_of_year = cal.get(3);
        }
    }

    private static boolean isNeedToArchive() {
        if (bSizeOrTime) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            if (week_of_year != cal.get(3)) {
                week_of_year = cal.get(3);
                return true;
            }
            return false;
        }
        return logFile.length() / 1024L > (long)maxFileSize;
    }

    private static void archiveLoggerFile() {
        Logger.close();
        File oldFile = new File(String.valueOf(logFile.getPath()) + "." + (fileCount - 1));
        if (oldFile.exists()) {
            oldFile.delete();
        }
        int i = fileCount - 2;
        while (i >= 0) {
            oldFile = new File(String.valueOf(logFile.getPath()) + "." + i);
            if (oldFile.exists()) {
                oldFile.renameTo(new File(String.valueOf(logFile.getPath()) + "." + (i + 1)));
            }
            --i;
        }
        logFile.renameTo(new File(String.valueOf(logFile.getPath()) + ".0"));
        try {
            FileOutputStream outputStream = new FileOutputStream(logFile.getPath(), true);
            writer = new PrintWriter((Writer)new OutputStreamWriter(outputStream), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.out.println(new Date() + ":\t" + logFile + ":\tRestart Logger with new LOG file.");
        System.out.println();
    }

    public static void close() {
        try {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void stop() {
        bStop = true;
        archiveThread.interrupt();
        Logger.close();
    }

    public static class FileMgrThread
    extends Thread {
        public void run() {
            this.setName("LoggerFileMgr-Thread");
            while (!bStop) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException iEx) {
                    break;
                }
                if (!Logger.isNeedToArchive()) continue;
                Logger.archiveLoggerFile();
            }
        }
    }
}

