/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.UTFDataFormatException;

public class LittleEndianInputStream
extends FilterInputStream
implements DataInput {
    private char[] lineBuffer;

    public LittleEndianInputStream(InputStream in) {
        super(in);
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        InputStream in = this.in;
        int n = 0;
        while (n < len) {
            int count = in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            n += count;
        }
    }

    public final boolean readBoolean() throws IOException {
        int bool = this.in.read();
        if (bool == -1) {
            throw new EOFException();
        }
        return bool != 0;
    }

    public final byte readByte() throws IOException {
        int temp = this.in.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return (byte)temp;
    }

    public final int readUnsignedByte() throws IOException {
        int temp = this.in.read();
        if (temp == -1) {
            throw new EOFException();
        }
        return temp;
    }

    public final short readShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1 || byte2 == -1) {
            throw new EOFException();
        }
        return (short)((byte2 << 8) + (byte1 << 0));
    }

    public final int readUnsignedShort() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte2 == -1 || byte2 == -1) {
            throw new EOFException();
        }
        return (byte2 << 8) + byte1;
    }

    public final char readChar() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        if (byte1 == -1 || byte2 == -1) {
            throw new EOFException();
        }
        return (char)((byte2 << 8) + byte1);
    }

    public final int readInt24() throws IOException {
        int byte1 = this.in.read();
        int byte2 = this.in.read();
        int byte3 = this.in.read();
        int byte4 = 0;
        if (byte3 == -1 || byte2 == -1 || byte1 == -1) {
            throw new EOFException();
        }
        byte4 = byte3 > 127 ? 255 : 0;
        return (byte4 << 24) + (byte3 << 16) + (byte2 << 8) + byte1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int readInt() throws IOException {
        int byte4;
        int byte3;
        int byte2;
        int byte1;
        LittleEndianInputStream littleEndianInputStream = this;
        synchronized (littleEndianInputStream) {
            byte1 = this.in.read();
            byte2 = this.in.read();
            byte3 = this.in.read();
            byte4 = this.in.read();
        }
        if (byte4 == -1 || byte3 == -1 || byte2 == -1 || byte1 == -1) {
            throw new EOFException();
        }
        return (byte4 << 24) + (byte3 << 16) + (byte2 << 8) + byte1;
    }

    public final long readLong() throws IOException {
        long byte1 = this.in.read();
        long byte2 = this.in.read();
        long byte3 = this.in.read();
        long byte4 = this.in.read();
        long byte5 = this.in.read();
        long byte6 = this.in.read();
        long byte7 = this.in.read();
        long byte8 = this.in.read();
        if (byte4 == -1L || byte3 == -1L || byte2 == -1L || byte1 == -1L || byte8 == -1L || byte7 == -1L || byte6 == -1L || byte5 == -1L) {
            throw new EOFException();
        }
        return (byte8 << 56) + (byte7 << 48) + (byte6 << 40) + (byte5 << 32) + (byte4 << 24) + (byte3 << 16) + (byte2 << 8) + byte1;
    }

    public final String readUTF() throws IOException {
        int numbytes = this.readUnsignedShort();
        char[] result = new char[numbytes];
        int numread = 0;
        int numchars = 0;
        while (numread < numbytes) {
            int c2;
            int c1 = this.readUnsignedByte();
            int test = c1 >> 4;
            if (test < 8) {
                ++numread;
                result[numchars++] = (char)c1;
                continue;
            }
            if (test == 12 || test == 13) {
                if ((numread += 2) > numbytes) {
                    throw new UTFDataFormatException();
                }
                c2 = this.readUnsignedByte();
                if ((c2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                result[numchars++] = (char)((c1 & 0x1F) << 6 | c2 & 0x3F);
                continue;
            }
            if (test == 14) {
                if ((numread += 3) > numbytes) {
                    throw new UTFDataFormatException();
                }
                c2 = this.readUnsignedByte();
                int c3 = this.readUnsignedByte();
                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                result[numchars++] = (char)((c1 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException();
        }
        return new String(result, 0, numchars);
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final int skipBytes(int n) throws IOException {
        int i = 0;
        while (i < n) {
            i += (int)this.skip(n - i);
        }
        return n;
    }

    public final String readLine() throws IOException {
        int c;
        InputStream in = this.in;
        char[] buf = this.lineBuffer;
        if (buf == null) {
            buf = this.lineBuffer = new char[128];
        }
        int room = buf.length;
        int offset = 0;
        block4: while (true) {
            c = in.read();
            switch (c) {
                case -1: 
                case 10: {
                    break block4;
                }
                case 13: {
                    int c2 = in.read();
                    if (c2 == 10 || c2 == -1) break block4;
                    if (!(in instanceof PushbackInputStream)) {
                        in = this.in = new PushbackInputStream(in);
                    }
                    ((PushbackInputStream)in).unread(c2);
                    break block4;
                }
                default: {
                    if (--room < 0) {
                        buf = new char[offset + 128];
                        room = buf.length - offset - 1;
                        System.arraycopy(this.lineBuffer, 0, buf, 0, offset);
                        this.lineBuffer = buf;
                    }
                    buf[offset++] = (char)c;
                    continue block4;
                }
            }
            break;
        }
        if (c == -1 && offset == 0) {
            return null;
        }
        return String.copyValueOf(buf, 0, offset);
    }
}

