/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.io;

import cn.org.gddsn.io.ConsoleLogger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.zip.GZIPOutputStream;

public class FileConsoleLogger
extends ConsoleLogger {
    private PrintStream out;
    private int fileCount = 10;
    private int maxFileSize = 1024;
    private File logFile;
    private boolean bSizeOrTime = false;
    private int sleepTime = 60000;
    private int week_of_year;
    private static Thread archiveThread;

    public FileConsoleLogger(String file) {
        this.logFile = new File(file);
        try {
            this.out = file.endsWith(".gz") ? new PrintStream(new GZIPOutputStream(new FileOutputStream(file))) : new PrintStream(new FileOutputStream(file, true));
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
        archiveThread = new FileMgrThread();
        archiveThread.start();
    }

    public void setArchiveFileCount(int archiveFileCount) {
        this.fileCount = archiveFileCount;
    }

    public void setWhen(String when) {
        try {
            this.maxFileSize = Integer.parseInt(when);
            this.bSizeOrTime = false;
        }
        catch (NumberFormatException nEx) {
            this.bSizeOrTime = true;
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            this.week_of_year = cal.get(3);
        }
    }

    private boolean isNeedToArchive() {
        if (this.bSizeOrTime) {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(new Date());
            if (this.week_of_year != cal.get(3)) {
                this.week_of_year = cal.get(3);
                return true;
            }
            return false;
        }
        return this.logFile.length() / 1024L > (long)this.maxFileSize;
    }

    private void archiveLoggerFile() {
        this.close();
        File oldFile = new File(String.valueOf(this.logFile.getPath()) + "." + (this.fileCount - 1));
        if (oldFile.exists()) {
            oldFile.delete();
        }
        int i = this.fileCount - 2;
        while (i >= 0) {
            oldFile = new File(String.valueOf(this.logFile.getPath()) + "." + i);
            if (oldFile.exists()) {
                oldFile.renameTo(new File(String.valueOf(this.logFile.getPath()) + "." + (i + 1)));
            }
            --i;
        }
        this.logFile.renameTo(new File(String.valueOf(this.logFile.getPath()) + ".0"));
        try {
            String file = this.logFile.getAbsolutePath();
            this.out = file.endsWith(".gz") ? new PrintStream(new GZIPOutputStream(new FileOutputStream(file))) : new PrintStream(new FileOutputStream(file, true));
        }
        catch (IOException ioEx) {
            ioEx.printStackTrace();
        }
        this.run();
        System.out.println(new Date() + ":\t" + this.logFile + ":\t Restart Logger with new LOG file.");
        System.out.println();
    }

    public void addMessage(String newmsg) {
        try {
            if (this.out != null) {
                this.out.println(newmsg);
                this.out.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void close() {
        super.close();
        archiveThread.interrupt();
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class FileMgrThread
    extends Thread {
        public void run() {
            this.setName("ConsoleLoggerFileMgr-Thread");
            while (true) {
                try {
                    Thread.sleep(FileConsoleLogger.this.sleepTime);
                }
                catch (InterruptedException iEx) {
                    break;
                }
                if (!FileConsoleLogger.this.isNeedToArchive()) continue;
                FileConsoleLogger.this.archiveLoggerFile();
            }
        }
    }
}

