/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.fft;

public final class FFT {
    public static void fft(double[] pr, double[] pi, int n, int k, double[] fr, double[] fi, boolean isIfft, boolean retRAndA) {
        double s;
        double q;
        int j;
        int i;
        int m;
        int it = 0;
        while (it <= n - 1) {
            m = it;
            int is = 0;
            i = 0;
            while (i <= k - 1) {
                j = m / 2;
                is = 2 * is + (m - 2 * j);
                m = j;
                ++i;
            }
            fr[it] = pr[is];
            fi[it] = pi[is];
            ++it;
        }
        pr[0] = 1.0;
        pi[0] = 0.0;
        double p = Math.PI * 2 / (1.0 * (double)n);
        pr[1] = Math.cos(p);
        pi[1] = -Math.sin(p);
        if (isIfft) {
            pi[1] = -pi[1];
        }
        i = 2;
        while (i <= n - 1) {
            p = pr[i - 1] * pr[1];
            q = pi[i - 1] * pi[1];
            s = (pr[i - 1] + pi[i - 1]) * (pr[1] + pi[1]);
            pr[i] = p - q;
            pi[i] = s - p - q;
            ++i;
        }
        it = 0;
        while (it <= n - 2) {
            double vr = fr[it];
            double vi = fi[it];
            fr[it] = vr + fr[it + 1];
            fi[it] = vi + fi[it + 1];
            fr[it + 1] = vr - fr[it + 1];
            fi[it + 1] = vi - fi[it + 1];
            it += 2;
        }
        m = n / 2;
        int nv = 2;
        int l0 = k - 2;
        while (l0 >= 0) {
            m /= 2;
            nv *= 2;
            it = 0;
            while (it <= (m - 1) * nv) {
                j = 0;
                while (j <= nv / 2 - 1) {
                    p = pr[m * j] * fr[it + j + nv / 2];
                    q = pi[m * j] * fi[it + j + nv / 2];
                    s = pr[m * j] + pi[m * j];
                    double poddr = p - q;
                    double poddi = (s *= fr[it + j + nv / 2] + fi[it + j + nv / 2]) - p - q;
                    fr[it + j + nv / 2] = fr[it + j] - poddr;
                    fi[it + j + nv / 2] = fi[it + j] - poddi;
                    fr[it + j] = fr[it + j] + poddr;
                    fi[it + j] = fi[it + j] + poddi;
                    ++j;
                }
                it += nv;
            }
            --l0;
        }
        if (isIfft) {
            i = 0;
            while (i <= n - 1) {
                fr[i] = fr[i] / (1.0 * (double)n);
                fi[i] = fi[i] / (1.0 * (double)n);
                ++i;
            }
        }
        if (retRAndA) {
            i = 0;
            while (i <= n - 1) {
                pr[i] = Math.sqrt(fr[i] * fr[i] + fi[i] * fi[i]);
                pi[i] = Math.abs(fr[i]) < 1.0E-6 * Math.abs(fi[i]) ? (fi[i] * fr[i] > 0.0 ? 90.0 : -90.0) : Math.atan(fi[i] / fr[i]) * 360.0 / 2.0 / Math.PI;
                ++i;
            }
        }
    }

    private FFT() {
    }

    public static void main(String[] args) {
        int j;
        double[] pr = new double[128];
        double[] pi = new double[128];
        double[] fr = new double[128];
        double[] fi = new double[128];
        int i = 0;
        while (i < 128) {
            pr[i] = Math.exp(-0.1 * ((double)i + 0.5));
            pi[i] = 0.0;
            ++i;
        }
        System.out.println();
        i = 0;
        while (i <= 15) {
            j = 0;
            while (j <= 3) {
                System.out.print(pr[4 * i + j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
        FFT.fft(pr, pi, 128, 7, fr, fi, false, true);
        i = 0;
        while (i <= 15) {
            j = 0;
            while (j <= 3) {
                System.out.print(fr[4 * i + j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
        i = 0;
        while (i <= 15) {
            j = 0;
            while (j <= 3) {
                System.out.print(fi[4 * i + j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
        i = 0;
        while (i <= 15) {
            j = 0;
            while (j <= 3) {
                System.out.print(pr[4 * i + j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
        i = 0;
        while (i <= 15) {
            j = 0;
            while (j <= 3) {
                System.out.print(pi[4 * i + j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
        FFT.fft(fr, fi, 64, 6, pr, pi, true, true);
        i = 0;
        while (i <= 15) {
            j = 0;
            while (j <= 3) {
                System.out.print(fr[4 * i + j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
        System.out.println();
    }
}

