/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.coyote.stochastic;

public abstract class Stochastic {
    protected int seed = 0;
    protected static final float FLT_MAX = 0.9999999f;
    protected static final float FLT_AM = 4.6566134E-10f;
    protected static final double DBL_MAX = 0.9999998807907104;
    protected static final double DBL_AM = 4.656613057391769E-10;
    private final StochasticException err_hilo = new StochasticException(" invalid low - high range");

    public Stochastic() {
        this.seed = (int)System.currentTimeMillis();
    }

    public Stochastic(int seed) {
        this.seed = seed;
    }

    public abstract int nextValue();

    public final float nextFloat() {
        this.nextValue();
        float temp = 4.6566134E-10f * (float)this.seed;
        if (temp > 0.9999999f) {
            return 0.9999999f;
        }
        return temp;
    }

    public final double nextDouble() {
        this.nextValue();
        double temp = 4.656613057391769E-10 * (double)this.seed;
        if (temp > 0.9999998807907104) {
            return 0.9999998807907104;
        }
        return temp;
    }

    public final int nextValue(int lo, int hi) {
        if (lo >= hi) {
            throw this.err_hilo;
        }
        return (int)((float)lo + (float)((long)hi - (long)lo) * this.nextFloat());
    }

    public final int nextValue(int hi) {
        return (int)((float)hi * this.nextFloat());
    }

    public final float nextFloat(float lo, float hi) {
        if (lo >= hi) {
            throw this.err_hilo;
        }
        return lo + (hi - lo) * this.nextFloat();
    }

    public final double nextDouble(double lo, double hi) {
        if (lo >= hi) {
            throw this.err_hilo;
        }
        return lo + (hi - lo) * this.nextDouble();
    }

    class StochasticException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StochasticException() {
        }

        public StochasticException(String s) {
            super(s);
        }
    }
}

