/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.convert;

import java.awt.geom.Point2D;

public class SphereUtil {
    final double a = 6378.16;
    final double b = 6356.778;
    final double e = 0.006693516541533384;
    double Lat0;
    double Lon0;
    double Rn;
    double Rm;
    public static final int LT_LATITUDE = 1;
    public static final int LT_COLATITUDE = 0;

    public SphereUtil(double lon0, double lat0) {
        this.Lat0 = lat0;
        this.Lon0 = lon0;
        this.Rn = 6378.16 / Math.sqrt(1.0 - 4.4803163691781034E-5 * Math.sin(this.Lat0) * Math.sin(this.Lat0));
        this.Rm = this.Rn * 0.9999551968363082 / (1.0 - 4.4803163691781034E-5 * Math.sin(this.Lat0) * Math.sin(this.Lat0));
    }

    public double getX(double lon, double lat) {
        double x = this.Rn * (lon - this.Lon0) * Math.cos(this.Lat0);
        return x;
    }

    public double getY(double lon, double lat) {
        double x = this.Rn * (lon - this.Lon0) * Math.cos(this.Lat0);
        double y = this.Rm * (lat - this.Lat0) + x * x * Math.tan(this.Lat0) / (2.0 * this.Rn);
        return y;
    }

    public double getLon(double x, double y) {
        return x / (this.Rn * Math.cos(this.Lat0)) + this.Lon0;
    }

    public double getLat(double x, double y) {
        return y / this.Rm - x * x * Math.tan(this.Lat0) / (2.0 * this.Rm * this.Rn) + this.Lat0;
    }

    public static final double distOnSphere(double fi1, double lam1, double fi2, double lam2) {
        double x1 = Math.cos(lam1 *= Math.PI / 180) * Math.cos(fi1 *= Math.PI / 180);
        double y1 = Math.cos(fi1) * Math.sin(lam1);
        double z1 = Math.sin(fi1);
        double x2 = Math.cos(lam2 *= Math.PI / 180) * Math.cos(fi2 *= Math.PI / 180);
        double y2 = Math.cos(fi2) * Math.sin(lam2);
        double z2 = Math.sin(fi2);
        double dist = Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
        dist = Math.asin(dist / 2.0) * 180.0 / Math.PI * 2.0;
        return dist;
    }

    public static void filam(double f, double l, double dist, double aza, Point2D point) {
        double grad = Math.PI / 180;
        double RZ = 6371.0;
        aza *= grad;
        dist /= RZ;
        double x = Math.cos(f *= grad) * Math.cos(l *= grad);
        double y = Math.cos(f) * Math.sin(l);
        double z = Math.sin(f);
        double x1 = x * Math.cos(l) + y * Math.sin(l);
        double y1 = -x * Math.sin(l) + y * Math.cos(l);
        double z1 = z;
        double x2 = -z1 * Math.cos(f) + x1 * Math.sin(f);
        double y2 = y1;
        double z2 = z1 * Math.sin(f) + x1 * Math.cos(f);
        aza = -Math.PI - aza;
        x2 = Math.sin(dist) * Math.cos(aza);
        y2 = Math.sin(dist) * Math.sin(aza);
        z2 = Math.cos(dist);
        x1 = -(-z2 * Math.cos(-f) + x2 * Math.sin(-f));
        y1 = y2;
        z1 = -(z2 * Math.sin(-f) + x2 * Math.cos(-f));
        x = x1 * Math.cos(-l) + y1 * Math.sin(-l);
        y = -x1 * Math.sin(-l) + y1 * Math.cos(-l);
        z = z1;
        double fi = Math.asin(z) / grad;
        double lam = Math.atan2(y, x) / grad;
        point.setLocation(fi, lam);
    }

    public static DELTAI deltai(double lat1, double lon1, double lat2, double lon2) {
        double sinc;
        double c;
        double cosc;
        double xx;
        double b;
        if (lat1 == lat2 && lon1 == lon2) {
            return new DELTAI(0.0, 0.0, 0.0);
        }
        if (Math.abs(Math.abs(lat1) - 90.0) < 1.0E-9) {
            lat1 = lat1 > 0.0 ? 89.999999999 : -89.999999999;
        }
        if (Math.abs(Math.abs(lat2) - 90.0) < 1.0E-9) {
            lat2 = lat2 > 0.0 ? 89.999999999 : -89.999999999;
        }
        double pi180 = Math.PI / 180;
        double ip180 = 57.29577951308232;
        double a = (90.0 - lat2) * pi180;
        if (a < 1.0E-9) {
            a = 1.0E-9;
        }
        if ((b = (90.0 - lat1) * pi180) < 1.0E-9) {
            b = 1.0E-9;
        }
        double gam = (lon1 - lon2) * pi180;
        double cosa = Math.cos(a);
        double cosb = Math.cos(b);
        double sina = Math.sin(a);
        double sinb = Math.sin(b);
        double y = cosa * cosb + sinb * sina * Math.cos(gam);
        if (y > 1.0) {
            y = 1.0;
        }
        if (y < -1.0) {
            y = -1.0;
        }
        if ((xx = (cosa - cosb * (cosc = Math.cos(c = Math.acos(y)))) / (sinb * (sinc = Math.sin(c)))) > 1.0) {
            xx = 1.0;
        }
        if (xx < -1.0) {
            xx = -1.0;
        }
        double az1 = Math.acos(xx) * ip180;
        xx = (cosb - cosa * cosc) / (sina * sinc);
        if (xx > 1.0) {
            xx = 1.0;
        }
        if (xx < -1.0) {
            xx = -1.0;
        }
        double az2 = Math.acos(xx) * ip180;
        double delta = c * ip180;
        if (Math.sin(gam) < 0.0) {
            az2 = 360.0 - az2;
        } else {
            az1 = 360.0 - az1;
        }
        return new DELTAI(delta, az1, az2);
    }

    public static double[] bjdaz2(double zlat0, double alon0, double zlat, double alon, int lattype) {
        double alat;
        double alat0;
        double pii = Math.PI;
        double twopi = Math.PI * 2;
        double[] ret = new double[3];
        if (lattype == 1) {
            alat0 = pii * 0.5 - zlat0;
            alat = pii * 0.5 - zlat;
        } else {
            alat0 = zlat0;
            alat = zlat;
        }
        double st0 = Math.sin(alat0);
        double ct0 = Math.cos(alat0);
        double ct1 = Math.cos(alat);
        double s0c1 = st0 * ct1;
        double st1 = Math.sin(alat);
        double s1c0 = st1 * ct0;
        double dlon = alon - alon0;
        double sdlon = Math.sin(dlon);
        double cdlon = Math.cos(dlon);
        double cdelt = st0 * st1 * cdlon + ct0 * ct1;
        double b = s0c1 - s1c0 * cdlon;
        double a = st1 * sdlon;
        double sdelt = Math.sqrt(b * b + a * a);
        double ddelt = Math.atan2(sdelt, cdelt);
        double aze = 0.0;
        if (sdelt != 0.0) {
            aze = Math.atan2(a, b);
        }
        a = -sdlon * st0;
        b = s1c0 - s0c1 * cdlon;
        double azs = pii;
        if (sdelt != 0.0) {
            azs = Math.atan2(a, b);
        }
        if (aze < 0.0) {
            aze += twopi;
        }
        if (azs < 0.0) {
            azs += twopi;
        }
        double delt = ddelt;
        double az1 = aze;
        double az2 = azs;
        ret[0] = delt;
        ret[1] = az1;
        ret[2] = az2;
        return ret;
    }

    public static void main(String[] args) {
        double dist = SphereUtil.distOnSphere(0.0, 100.0, 0.0, 170.0);
        DELTAI dlt = SphereUtil.deltai(0.0, 100.0, 0.0, 170.0);
        System.out.println(dist);
        System.out.println(dlt);
        dlt = SphereUtil.deltai(10.0, 110.0, 0.0, 110.0);
        System.out.println(dlt);
    }

    public static class DELTAI {
        public double delta;
        public double az1;
        public double az2;

        public String toString() {
            return "delta=" + this.delta + ",az1=" + this.az1 + ",az2=" + this.az2;
        }

        public DELTAI() {
        }

        public DELTAI(double delta, double az1, double az2) {
            this.delta = delta;
            this.az1 = az1;
            this.az2 = az2;
        }
    }
}

