/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.convert;

import cn.org.gddsn.convert.DoubleFormat;
import cn.org.gddsn.convert.cs_printf;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public final class DateToString {
    private DateToString() {
    }

    public static String getTime(Date date) {
        TimeZone tz = TimeZone.getDefault();
        long t = date.getTime();
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setTime(date);
        double sec = (float)c.get(13) + (float)(t % 1000L) / 1000.0f;
        String Buffer2 = c.get(11) + ":" + c.get(12) + ":" + DoubleFormat.toString(sec, 3);
        return Buffer2;
    }

    public static String getDate(Date d) {
        TimeZone tz = TimeZone.getDefault();
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setTime(d);
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        int month = c.get(2) + 1;
        P.printf("%4.4d%2.2d%2.2d", new Integer(c.get(1)), new Integer(month), new Integer(c.get(5)));
        return strBuffer.substring(0);
    }

    public static String getFullTime(Date d) {
        TimeZone tz = TimeZone.getDefault();
        GregorianCalendar c = new GregorianCalendar(tz);
        c.setTime(d);
        StringBuffer strBuffer = new StringBuffer();
        cs_printf P = new cs_printf(strBuffer);
        int month = c.get(2) + 1;
        P.printf("%4.4d%2.2d%2.2d", new Integer(c.get(1)), new Integer(month), new Integer(c.get(5)));
        P.printf("%2.2d%2.2d%2.2d", new Integer(c.get(11)), new Integer(c.get(12)), new Integer(c.get(13)));
        return strBuffer.substring(0);
    }

    public static String Date2GSE(Date date, String pattern) {
        return DateToString.Date2GSE(date, pattern, "UTC");
    }

    public static String Date2GSE(Date date, String pattern, String tz) {
        String msStr = null;
        int index = pattern.lastIndexOf(46);
        if (index == -1) {
            index = pattern.length();
        } else {
            String msPattern = pattern.substring(index);
            msPattern = msPattern.replace('s', '#');
            double ms = (double)(date.getTime() % 1000L) / 1000.0;
            DecimalFormat df = new DecimalFormat(msPattern);
            msStr = df.format(ms);
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern.substring(0, index));
        formatter.setTimeZone(TimeZone.getTimeZone(tz));
        String dateTimeStr = formatter.format(date);
        return String.valueOf(dateTimeStr) + msStr;
    }

    public static Date GSE2Date(String dateStr, String pattern) throws ParseException {
        return DateToString.GSE2Date(dateStr, pattern, "UTC");
    }

    public static Date GSE2Date(String dateStr, String pattern, String tz) throws ParseException {
        int mSec = 0;
        int index = pattern.lastIndexOf(46);
        if (index == -1) {
            index = pattern.length();
        } else {
            mSec = Integer.parseInt(dateStr.substring(index + 1));
        }
        SimpleDateFormat formatter = new SimpleDateFormat(pattern.substring(0, index));
        formatter.setTimeZone(TimeZone.getTimeZone(tz));
        Date date = formatter.parse(dateStr.substring(0, index));
        date.setTime(date.getTime() + (long)mSec);
        return date;
    }
}

