/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.convert;

import java.awt.Point;
import org.apache.log4j.Logger;

public class CoordinateTran {
    static Logger logger;
    Point OPixel;
    float XScale;
    float YScale;
    float Ox;
    float Oy;
    IllegalArgumentException coordinateTranException = new IllegalArgumentException("The Scale argument must be positive!");
    final int maxInt = 8192;
    final int minInt = -8192;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.convert.CoordinateTran");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public CoordinateTran(Point aOPixel, float aOx, float aOy, float aXScale, float aYScale) {
        if ((double)aXScale <= 0.0) {
            logger.warn("XScale: " + aXScale);
            throw this.coordinateTranException;
        }
        if ((double)aYScale <= 0.0) {
            logger.warn("YScale: " + aYScale);
            throw this.coordinateTranException;
        }
        this.OPixel = aOPixel;
        this.Ox = aOx;
        this.Oy = aOy;
        this.XScale = aXScale;
        this.YScale = aYScale;
    }

    public CoordinateTran() {
        this.OPixel = new Point(0, 0);
        this.Ox = 0.0f;
        this.Oy = 0.0f;
        this.XScale = 1.0f;
        this.YScale = 1.0f;
    }

    public void setTran(Point aOPixel, float aOx, float aOy, float aXScale, float aYScale) {
        if ((double)aXScale <= 0.0) {
            logger.warn("XScale: " + aXScale);
            throw this.coordinateTranException;
        }
        if ((double)aYScale <= 0.0) {
            logger.warn("YScale: " + aYScale);
            throw this.coordinateTranException;
        }
        this.OPixel = aOPixel;
        this.Ox = aOx;
        this.Oy = aOy;
        this.XScale = aXScale;
        this.YScale = aYScale;
    }

    public void setXScale(float aXScale) {
        if ((double)aXScale <= 0.0) {
            logger.warn("XScale: " + aXScale);
            throw this.coordinateTranException;
        }
        this.XScale = aXScale;
    }

    public void setYScale(float aYScale) {
        if ((double)aYScale <= 0.0) {
            logger.warn("YScale: " + aYScale);
            throw this.coordinateTranException;
        }
        this.YScale = aYScale;
    }

    public float getXScale() {
        return this.XScale;
    }

    public float getYScale() {
        return this.YScale;
    }

    public Point getOPixel() {
        return this.OPixel;
    }

    public void setOPixel(Point aOPixel) {
        this.OPixel = aOPixel;
    }

    public void setOx(float aOx) {
        this.Ox = aOx;
    }

    public float getOx() {
        return this.Ox;
    }

    public void setOy(float aOy) {
        this.Oy = aOy;
    }

    public float getOy() {
        return this.Oy;
    }

    public Point toPixel(float X, float Y) {
        Point Pixel = new Point(0, 0);
        Pixel.x = this.OPixel.x + Math.round((X - this.Ox) / this.XScale);
        int temp = Math.round((Y - this.Oy) / this.YScale);
        Pixel.y = this.OPixel.y - temp;
        if (Pixel.y > 8192) {
            Pixel.y = 8192;
        }
        if (Pixel.y < -8192) {
            Pixel.y = -8192;
        }
        return Pixel;
    }

    public Point toPixel(int X, int Y) {
        Point Pixel = new Point(0, 0);
        Pixel.x = this.OPixel.x + Math.round(((float)X - this.Ox) / this.XScale);
        int temp = Math.round(((float)Y - this.Oy) / this.YScale);
        Pixel.y = this.OPixel.y - temp;
        if (Pixel.y > 8192) {
            Pixel.y = 8192;
        }
        if (Pixel.y < -8192) {
            Pixel.y = -8192;
        }
        return Pixel;
    }

    public Point toPixel(int X, double Y) {
        Point Pixel = new Point(0, 0);
        Pixel.x = this.OPixel.x + Math.round(((float)X - this.Ox) / this.XScale);
        int temp = (int)Math.round((Y - (double)this.Oy) / (double)this.YScale);
        Pixel.y = this.OPixel.y - temp;
        if (Pixel.y > 8192) {
            Pixel.y = 8192;
        }
        if (Pixel.y < -8192) {
            Pixel.y = -8192;
        }
        return Pixel;
    }

    public float toOrgX(Point Pixel) {
        return this.Ox + (float)(Pixel.x - this.OPixel.x) * this.XScale;
    }

    public float toOrgY(Point Pixel) {
        return this.Oy + (float)(this.OPixel.y - Pixel.y) * this.YScale;
    }

    public String toString() {
        return "[" + this.OPixel + "]--(" + this.Ox + "," + this.Oy + ")--{" + this.XScale + "," + this.YScale + "}";
    }
}

