/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.chart;

import cn.org.gddsn.chart.ContourPlot;
import cn.org.gddsn.chart.ContourPlotLayout;
import cn.org.gddsn.chart.ParseMatrixException;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Event;
import java.awt.Font;
import java.awt.Label;
import java.awt.TextArea;
import java.io.IOException;

public class ContourPlotApplet
extends Applet {
    static final int NUMBER_COMPONENTS = 6;
    static final int MIN_X_STEPS = 2;
    static final int MIN_Y_STEPS = 2;
    static final int MAX_X_STEPS = 100;
    static final int MAX_Y_STEPS = 100;
    static final String EOL = System.getProperty("line.separator");
    static final String DEFAULT_Z = "{{0.5,1.1,1.5,1,2.0,3,3,2,1,0.1}," + EOL + " {1.0,1.5,3.0,5,6.0,2,1,1.2,1,4}," + EOL + " {0.9,2.0,2.1,3,6.0,7,3,2,1,1.4}," + EOL + " {1.0,1.5,3.0,4,6.0,5,2,1.5,1,2}," + EOL + " {0.8,2.0,3.0,3,4.0,4,3,2.4,2,3}," + EOL + " {0.6,1.1,1.5,1,4.0,3.5,3,2,3,4}," + EOL + " {1.0,1.5,3.0,5,6.0,2,1,1.2,2.7,4}," + EOL + " {0.8,2.0,3.0,3,5.5,6,3,2,1,1.4}," + EOL + " {1.0,1.5,3.0,4,6.0,5,2,1,0.5,0.2}}";
    ContourPlot thePlot = new ContourPlot(2, 2);
    Label zPrompt = new Label("", 0);
    TextArea zField = new TextArea(DEFAULT_Z, 30, 6);
    Checkbox interBox = new Checkbox();
    Button drawBtn = new Button();
    TextArea results = new TextArea();
    static String contourValuesTitle;
    static String infoStrX;
    static String infoStrY;
    static String errParse;
    static String errLog;
    static String errComp;
    static String errEqual;
    static String errExpect;
    static String errEOF;
    static String errBounds;

    public void init() {
        infoStrX = this.getParameter("stringX");
        infoStrY = this.getParameter("stringY");
        this.setLayout(new ContourPlotLayout());
        this.add("thePlot", this.thePlot);
        this.zPrompt.setText(this.getParameter("stringZ"));
        this.add("zPrompt", this.zPrompt);
        this.zField.setBackground(Color.white);
        this.add("zField", this.zField);
        this.interBox.setLabel(this.getParameter("stringBox"));
        this.interBox.setState(false);
        this.add("interBox", this.interBox);
        this.drawBtn.setLabel(this.getParameter("stringButton"));
        this.drawBtn.setFont(new Font("Helvetica", 1, 10));
        this.drawBtn.setBackground(Color.white);
        this.add("drawBtn", this.drawBtn);
        this.results.setEditable(false);
        this.results.setFont(new Font("Courier", 0, 9));
        this.results.setBackground(Color.white);
        this.add("results", this.results);
        contourValuesTitle = this.getParameter("stringResults");
        errParse = this.getParameter("stringErrParse");
        errLog = String.valueOf(this.getParameter("stringErrLog1")) + EOL + this.getParameter("stringErrLog2") + EOL + this.getParameter("stringErrLog3");
        errComp = this.getParameter("stringErrComp");
        errEqual = this.getParameter("stringErrEqual");
        errExpect = this.getParameter("stringErrExpect");
        errEOF = this.getParameter("stringErrEOF");
        errBounds = this.getParameter("stringErrBounds");
    }

    public boolean handleEvent(Event e) {
        if (e != null && e.id == 1001 && e.target == this.drawBtn) {
            this.DrawTheContourPlot();
            return true;
        }
        return super.handleEvent(e);
    }

    public void DrawTheContourPlot() {
        try {
            try {
                String s = this.zField.getText();
                this.thePlot.logInterpolation = this.interBox.getState();
                this.thePlot.ParseZedMatrix(s);
                this.thePlot.paint(this.thePlot.getGraphics());
                s = String.valueOf(this.thePlot.ReturnZedMatrix()) + contourValuesTitle + EOL + this.thePlot.GetContourValuesString();
                this.results.setText(s);
            }
            catch (ParseMatrixException e) {
                this.thePlot.repaint();
                this.results.setText(e.getMessage());
                System.out.println("Exiting DrawTheContourPlot");
            }
            catch (IOException e) {
                this.thePlot.repaint();
                this.results.setText(e.getMessage());
                System.out.println("Exiting DrawTheContourPlot");
            }
        }
        finally {
            System.out.println("Exiting DrawTheContourPlot");
        }
    }
}

