/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.ann;

import JSci.maths.matrices.DoubleMatrix;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;
import cn.org.gddsn.ann.NNWeight;
import cn.org.gddsn.ann.TranFunc;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class BPnet
implements Serializable {
    static Logger logger;
    static final long serialVersionUID = -8594127540226444626L;
    int nLayers;
    int[] nNeurons;
    NNWeight[] LW;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("cn.org.gddsn.ann.BPnet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz);
    }

    public BPnet(int anLayers, int[] anNeurons) {
        this.nLayers = anLayers;
        this.nNeurons = anNeurons;
        this.init();
    }

    public BPnet() {
        int[] anNeurons = new int[]{2, 2, 1};
        this.nLayers = 3;
        this.nNeurons = anNeurons;
        this.init();
    }

    public int getInputNeurons() {
        return this.nNeurons[0];
    }

    public int getHidenNeurons(int nlayer) {
        return this.nNeurons[nlayer + 1];
    }

    public int getOutputNeurons() {
        return this.nNeurons[this.nNeurons.length - 1];
    }

    void init() {
        this.LW = new NNWeight[this.nLayers - 1];
        int i = 0;
        while (i < this.nLayers - 1) {
            this.LW[i] = new NNWeight(this.nNeurons[i], this.nNeurons[i + 1]);
            ++i;
        }
    }

    public double[] sim(double[] p) {
        DoubleVector input = new DoubleVector(p);
        int i = 0;
        while (i < this.nLayers - 1) {
            DoubleVector output;
            DoubleMatrix dm = new DoubleMatrix(this.LW[i].weights);
            AbstractDoubleVector sum = dm.multiply(input);
            sum = sum.add(new DoubleVector(this.LW[i].biases));
            input = output = TranFunc.logSig(sum);
            ++i;
        }
        double[] ret = new double[input.dimension()];
        int j = 0;
        while (j < ret.length) {
            ret[j] = input.getComponent(j);
            ++j;
        }
        return ret;
    }

    public void writeBPWeight(String filterName) {
        try {
            FileOutputStream fos = new FileOutputStream(filterName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeInt(this.nLayers);
            oos.writeObject(this.nNeurons);
            oos.writeObject(this.LW);
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (Exception ex) {
            logger.warn("Trouble writing " + filterName, ex);
        }
    }

    public void readBPWeight(String filterName) {
        try {
            FileInputStream fis = new FileInputStream(filterName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.nLayers = ois.readInt();
            this.nNeurons = (int[])ois.readObject();
            this.LW = (NNWeight[])ois.readObject();
            ois.close();
            fis.close();
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            logger.warn("Trouble reading " + filterName);
        }
    }

    public void readAsciiBPWeight(String fName) {
        try {
            FileReader fs = new FileReader(fName);
            BufferedReader ds = new BufferedReader(fs);
            String LineStr = ds.readLine();
            StringTokenizer st = new StringTokenizer(LineStr);
            this.nLayers = Integer.parseInt(st.nextToken());
            LineStr = ds.readLine();
            st = new StringTokenizer(LineStr);
            int i = 0;
            while (i < this.nLayers) {
                this.nNeurons[i] = Integer.parseInt(st.nextToken());
                ++i;
            }
            this.init();
            int L = 0;
            while (L < this.nLayers - 1) {
                int i2 = 0;
                while (i2 < this.nNeurons[L + 1]) {
                    LineStr = ds.readLine();
                    st = new StringTokenizer(LineStr);
                    int j = 0;
                    while (j < this.nNeurons[L]) {
                        this.LW[L].weights[i2][j] = Double.valueOf(st.nextToken());
                        ++j;
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < this.nNeurons[L + 1]) {
                    LineStr = ds.readLine();
                    st = new StringTokenizer(LineStr);
                    this.LW[L].biases[i2] = Double.valueOf(st.nextToken());
                    ++i2;
                }
                ++L;
            }
        }
        catch (Exception ex) {
            logger.warn(ex.getMessage(), ex);
            logger.warn("Trouble writing " + fName);
        }
    }

    public static void main(String[] args) {
        BPnet bPnet = new BPnet();
        bPnet.readAsciiBPWeight("D:/detecteq80.txt");
        bPnet.writeBPWeight("d:/detecteq80.sr");
    }
}

