/*
 * Decompiled with CFR 0.152.
 */
package cn.org.gddsn.alarm;

import cn.org.gddsn.alarm.SoundPlayer;
import java.util.Date;
import javax.swing.JOptionPane;

abstract class EQMonitor
implements Runnable {
    long hours = new Date().getTime() / 3600000L;
    private int period = 1;
    boolean oneHourAlarm = false;

    public void setPeriod(int newPeriod) {
        this.period = newPeriod;
    }

    public void setOneHourAlarm(boolean alarm) {
        this.oneHourAlarm = alarm;
    }

    public int getPeriod() {
        return this.period;
    }

    public abstract boolean isEarthQuake();

    public void run() {
        while (true) {
            Date now;
            long tmpHours;
            try {
                Thread.sleep(this.period * 1000);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.isEarthQuake()) {
                SoundPlayer sp = new SoundPlayer();
                sp.playEQWarring();
                JOptionPane.showMessageDialog(null, "An earthquake is happening!");
                sp.stop();
            }
            if (!this.oneHourAlarm || (tmpHours = (now = new Date()).getTime() / 3600000L) <= this.hours) continue;
            this.hours = tmpHours;
            SoundPlayer sp = new SoundPlayer();
            sp.playOneHourSound();
            JOptionPane.showMessageDialog(null, "Please check system status.");
            sp.stop();
        }
    }
}

