/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.LittleEndian;

public class NMXPDataBundles {
    public static final int BUNDLE_SIZE = 17;
    public static final byte NULL_BUNDLE = 9;
    static final byte BYTE_PACKING = 1;
    static final byte SHORT_PACKING = 2;
    static final byte LONG_PACKING = 3;
    static int[] samplesPerMiniX;
    private byte m_numBundles;
    private int m_initialValue;
    private byte[] m_data;

    static {
        int[] nArray = new int[256];
        nArray[1] = 4;
        nArray[2] = 2;
        nArray[3] = 1;
        nArray[4] = 4;
        nArray[5] = 8;
        nArray[6] = 6;
        nArray[7] = 5;
        nArray[8] = 2;
        nArray[9] = 6;
        nArray[10] = 4;
        nArray[11] = 3;
        nArray[12] = 1;
        nArray[13] = 5;
        nArray[14] = 3;
        nArray[15] = 2;
        nArray[16] = 4;
        nArray[17] = 8;
        nArray[18] = 6;
        nArray[19] = 5;
        nArray[20] = 8;
        nArray[21] = 12;
        nArray[22] = 10;
        nArray[23] = 9;
        nArray[24] = 6;
        nArray[25] = 10;
        nArray[26] = 8;
        nArray[27] = 7;
        nArray[28] = 5;
        nArray[29] = 9;
        nArray[30] = 7;
        nArray[31] = 6;
        nArray[32] = 2;
        nArray[33] = 6;
        nArray[34] = 4;
        nArray[35] = 3;
        nArray[36] = 6;
        nArray[37] = 10;
        nArray[38] = 8;
        nArray[39] = 7;
        nArray[40] = 4;
        nArray[41] = 8;
        nArray[42] = 6;
        nArray[43] = 5;
        nArray[44] = 3;
        nArray[45] = 7;
        nArray[46] = 5;
        nArray[47] = 4;
        nArray[48] = 1;
        nArray[49] = 5;
        nArray[50] = 3;
        nArray[51] = 2;
        nArray[52] = 5;
        nArray[53] = 9;
        nArray[54] = 7;
        nArray[55] = 6;
        nArray[56] = 3;
        nArray[57] = 7;
        nArray[58] = 5;
        nArray[59] = 4;
        nArray[60] = 2;
        nArray[61] = 6;
        nArray[62] = 4;
        nArray[63] = 3;
        nArray[64] = 4;
        nArray[65] = 8;
        nArray[66] = 6;
        nArray[67] = 5;
        nArray[68] = 8;
        nArray[69] = 12;
        nArray[70] = 10;
        nArray[71] = 9;
        nArray[72] = 6;
        nArray[73] = 10;
        nArray[74] = 8;
        nArray[75] = 7;
        nArray[76] = 5;
        nArray[77] = 9;
        nArray[78] = 7;
        nArray[79] = 6;
        nArray[80] = 8;
        nArray[81] = 12;
        nArray[82] = 10;
        nArray[83] = 9;
        nArray[84] = 12;
        nArray[85] = 16;
        nArray[86] = 14;
        nArray[87] = 13;
        nArray[88] = 10;
        nArray[89] = 14;
        nArray[90] = 12;
        nArray[91] = 11;
        nArray[92] = 9;
        nArray[93] = 13;
        nArray[94] = 11;
        nArray[95] = 10;
        nArray[96] = 6;
        nArray[97] = 10;
        nArray[98] = 8;
        nArray[99] = 7;
        nArray[100] = 10;
        nArray[101] = 14;
        nArray[102] = 12;
        nArray[103] = 11;
        nArray[104] = 8;
        nArray[105] = 12;
        nArray[106] = 10;
        nArray[107] = 9;
        nArray[108] = 7;
        nArray[109] = 11;
        nArray[110] = 9;
        nArray[111] = 8;
        nArray[112] = 5;
        nArray[113] = 9;
        nArray[114] = 7;
        nArray[115] = 6;
        nArray[116] = 9;
        nArray[117] = 13;
        nArray[118] = 11;
        nArray[119] = 10;
        nArray[120] = 7;
        nArray[121] = 11;
        nArray[122] = 9;
        nArray[123] = 8;
        nArray[124] = 6;
        nArray[125] = 10;
        nArray[126] = 8;
        nArray[127] = 7;
        nArray[128] = 2;
        nArray[129] = 6;
        nArray[130] = 4;
        nArray[131] = 3;
        nArray[132] = 6;
        nArray[133] = 10;
        nArray[134] = 8;
        nArray[135] = 7;
        nArray[136] = 4;
        nArray[137] = 8;
        nArray[138] = 6;
        nArray[139] = 5;
        nArray[140] = 3;
        nArray[141] = 7;
        nArray[142] = 5;
        nArray[143] = 4;
        nArray[144] = 6;
        nArray[145] = 10;
        nArray[146] = 8;
        nArray[147] = 7;
        nArray[148] = 10;
        nArray[149] = 14;
        nArray[150] = 12;
        nArray[151] = 11;
        nArray[152] = 8;
        nArray[153] = 12;
        nArray[154] = 10;
        nArray[155] = 9;
        nArray[156] = 7;
        nArray[157] = 11;
        nArray[158] = 9;
        nArray[159] = 8;
        nArray[160] = 4;
        nArray[161] = 8;
        nArray[162] = 6;
        nArray[163] = 5;
        nArray[164] = 8;
        nArray[165] = 12;
        nArray[166] = 10;
        nArray[167] = 9;
        nArray[168] = 6;
        nArray[169] = 10;
        nArray[170] = 8;
        nArray[171] = 7;
        nArray[172] = 5;
        nArray[173] = 9;
        nArray[174] = 7;
        nArray[175] = 6;
        nArray[176] = 3;
        nArray[177] = 7;
        nArray[178] = 5;
        nArray[179] = 4;
        nArray[180] = 7;
        nArray[181] = 11;
        nArray[182] = 9;
        nArray[183] = 8;
        nArray[184] = 5;
        nArray[185] = 9;
        nArray[186] = 7;
        nArray[187] = 6;
        nArray[188] = 4;
        nArray[189] = 8;
        nArray[190] = 6;
        nArray[191] = 5;
        nArray[192] = 1;
        nArray[193] = 5;
        nArray[194] = 3;
        nArray[195] = 2;
        nArray[196] = 5;
        nArray[197] = 9;
        nArray[198] = 7;
        nArray[199] = 6;
        nArray[200] = 3;
        nArray[201] = 7;
        nArray[202] = 5;
        nArray[203] = 4;
        nArray[204] = 2;
        nArray[205] = 6;
        nArray[206] = 4;
        nArray[207] = 3;
        nArray[208] = 5;
        nArray[209] = 9;
        nArray[210] = 7;
        nArray[211] = 6;
        nArray[212] = 9;
        nArray[213] = 13;
        nArray[214] = 11;
        nArray[215] = 10;
        nArray[216] = 7;
        nArray[217] = 11;
        nArray[218] = 9;
        nArray[219] = 8;
        nArray[220] = 6;
        nArray[221] = 10;
        nArray[222] = 8;
        nArray[223] = 7;
        nArray[224] = 3;
        nArray[225] = 7;
        nArray[226] = 5;
        nArray[227] = 4;
        nArray[228] = 7;
        nArray[229] = 11;
        nArray[230] = 9;
        nArray[231] = 8;
        nArray[232] = 5;
        nArray[233] = 9;
        nArray[234] = 7;
        nArray[235] = 6;
        nArray[236] = 4;
        nArray[237] = 8;
        nArray[238] = 6;
        nArray[239] = 5;
        nArray[240] = 2;
        nArray[241] = 6;
        nArray[242] = 4;
        nArray[243] = 3;
        nArray[244] = 6;
        nArray[245] = 10;
        nArray[246] = 8;
        nArray[247] = 7;
        nArray[248] = 4;
        nArray[249] = 8;
        nArray[250] = 6;
        nArray[251] = 5;
        nArray[252] = 3;
        nArray[253] = 7;
        nArray[254] = 5;
        nArray[255] = 4;
        samplesPerMiniX = nArray;
    }

    public NMXPDataBundles() {
    }

    public NMXPDataBundles(int initialValue, byte[] data) {
        this.setData(initialValue, data);
    }

    public void setData(int initialValue, byte[] data) {
        if (data != null && data.length % 17 == 0) {
            this.m_initialValue = initialValue;
            this.m_data = data;
            this.m_numBundles = (byte)(this.m_data.length / 17);
        }
    }

    public int[] getSamples() {
        int numSamples = this.getNumSamples();
        if (numSamples < 0) {
            numSamples = 0;
        }
        int numBundles = this.getNumBundles();
        int[] samples = new int[numSamples];
        int last = this.getInitialValue();
        int sample = 0;
        int bundle = 0;
        while (bundle < numBundles) {
            int offset = bundle * 17;
            int bundleCode = this.m_data[offset] & 0xFF;
            if (bundleCode == 9) break;
            ++offset;
            int subframe = 0;
            while (subframe < 4) {
                int XCode = this.getXCode(bundleCode, subframe);
                switch (XCode) {
                    case 1: {
                        samples[sample++] = last += this.m_data[offset];
                        samples[sample++] = last += this.m_data[++offset];
                        samples[sample++] = last += this.m_data[++offset];
                        samples[sample++] = last += this.m_data[++offset];
                        ++offset;
                        break;
                    }
                    case 2: {
                        samples[sample++] = last += LittleEndian.readShort(this.m_data, offset);
                        samples[sample++] = last += LittleEndian.readShort(this.m_data, offset += 2);
                        offset += 2;
                        break;
                    }
                    case 3: {
                        samples[sample++] = last += LittleEndian.readInt(this.m_data, offset);
                        offset += 4;
                    }
                }
                ++subframe;
            }
            ++bundle;
        }
        return samples;
    }

    public int getNumSamples() {
        int numBundles = this.getNumBundles();
        int numSamples = 0;
        int bundle = 0;
        while (bundle < numBundles) {
            int XCode = this.m_data[bundle * 17] & 0xFF;
            if (XCode == 9) break;
            numSamples += samplesPerMiniX[XCode];
            ++bundle;
        }
        return numSamples;
    }

    public int getInitialValue() {
        return this.m_initialValue;
    }

    public void setInitialValue(int x) {
        this.m_initialValue = x;
    }

    public byte getNumBundles() {
        return this.m_numBundles;
    }

    public int getSize() {
        return this.getNumBundles() * 17;
    }

    public byte[] getData() {
        return this.m_data;
    }

    public int getXCode(int bundleCode, int subFrame) {
        return bundleCode >> 2 * (3 - subFrame) & 3;
    }
}

