/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.Debugger;
import ca.nanometrics.util.ErrorLog;

public class Log {
    public static final int DEBUG = 0;
    public static final int VERBOSE = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public static final int FATAL = 5;
    public static final int UNKNOWN = 6;
    public static final char[] severityLabel = new char[]{'D', 'V', 'I', 'W', 'E', 'F', 'X'};
    public static final String[] verbosityName = new String[]{"DEBUG", "VERBOSE", "INFO", "WARNING", "ERROR", "FATAL"};
    private static ErrorLog log = null;
    private static Debugger debugger = null;

    public static void report(Object obj, int errNum, int severity, String message) {
        if (log != null) {
            log.report(obj, errNum, severity, message);
        }
    }

    public static void report(String name, int errNum, int severity, String message) {
        if (log != null) {
            log.report(name, errNum, severity, message);
        }
    }

    public static void report(int severity, long time, String source, String message) {
        if (log != null) {
            log.report(severity, time, source, message);
        }
    }

    public static void debug(Object obj, String message) {
        if (debugger != null) {
            debugger.report(obj, message);
        }
    }

    public static void debug(String message) {
        if (debugger != null) {
            debugger.report(message);
        }
    }

    public static void installLog(ErrorLog errorLog) {
        log = errorLog;
    }

    public static void installDebugConsole(Debugger aDebugger) {
        debugger = aDebugger;
    }
}

