/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.BiIterator;
import ca.nanometrics.util.BinarySearchTreeNode;
import ca.nanometrics.util.InvalidInputException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class BinarySearchTree {
    private BinarySearchTreeNode m_root = null;
    private int m_size = 0;

    public boolean contains(Comparable key) {
        return this.get(key) != null;
    }

    /*
     * Unable to fully structure code
     */
    public boolean delete(Comparable key) {
        node = this.find(key);
        if (node != null && node.compareKey(key) == 0) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            swapNode = node.getLeft() == null ? node.getRight().getMin() : node.getLeft().getMax();
            swapNode.swapKeys(node);
            node = swapNode;
lbl7:
            // 2 sources

            ** while (!node.isLeaf())
        }
lbl8:
        // 1 sources

        node.dispose();
        if (this.m_root == node) {
            this.m_root = null;
        }
        --this.m_size;
        return true;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BinarySearchTree)) {
            return false;
        }
        BinarySearchTree tree = (BinarySearchTree)obj;
        if (tree.size() != this.size()) {
            return false;
        }
        BiIterator iter1 = this.iterator();
        BiIterator iter2 = tree.iterator();
        while (iter1.hasNext()) {
            if (iter1.next().equals(iter2.next())) continue;
            return false;
        }
        return true;
    }

    public Comparable get(Comparable key) {
        BinarySearchTreeNode node = this.find(key);
        if (node == null || node.compareKey(key) != 0) {
            return null;
        }
        return node.getKey();
    }

    public Comparable getMax() {
        if (this.m_root == null) {
            return null;
        }
        return this.m_root.getMax().getKey();
    }

    public Comparable getMin() {
        if (this.m_root == null) {
            return null;
        }
        return this.m_root.getMin().getKey();
    }

    public void insert(Comparable key) throws InvalidInputException {
        BinarySearchTreeNode curNode = this.m_root;
        BinarySearchTreeNode parentNode = null;
        while (curNode != null) {
            int compareValue = curNode.compareKey(key);
            if (compareValue == 0) {
                throw new InvalidInputException("Duplicate key found!");
            }
            if (compareValue < 0) {
                parentNode = curNode;
                curNode = curNode.getRight();
                continue;
            }
            parentNode = curNode;
            curNode = curNode.getLeft();
        }
        BinarySearchTreeNode newNode = this.createNode(key, parentNode);
        if (this.m_root == null) {
            this.m_root = newNode;
        }
        ++this.m_size;
    }

    public boolean isEmpty() {
        return this.m_root == null;
    }

    public BiIterator iterator() {
        BinarySearchTreeNode node = this.m_root;
        if (this.m_root != null) {
            node = this.m_root.getMin();
        }
        return new NaturalTreeIterator(node);
    }

    public BiIterator iterator(Comparable key) {
        return new NaturalTreeIterator(this.find(key));
    }

    public Iterator iteratorBreadthFirst() {
        return new BreadthFirstTreeIterator(this.m_root);
    }

    public Iterator iteratorBreadthFirst(Comparable key) {
        BinarySearchTreeNode node = this.find(key);
        if (node == null || node.compareKey(key) != 0) {
            return new BreadthFirstTreeIterator(null);
        }
        return new BreadthFirstTreeIterator(node);
    }

    public int size() {
        return this.m_size;
    }

    protected BinarySearchTreeNode createNode(Comparable key, BinarySearchTreeNode parent) {
        return new BinarySearchTreeNode(key, parent);
    }

    protected BinarySearchTreeNode find(Comparable key) {
        if (this.m_root == null) {
            return null;
        }
        BinarySearchTreeNode curNode = this.m_root;
        int compareValue;
        while ((compareValue = curNode.compareKey(key)) != 0) {
            if (compareValue < 0) {
                if (curNode.getRight() == null) {
                    return curNode.getNext();
                }
                curNode = curNode.getRight();
                continue;
            }
            if (curNode.getLeft() == null) {
                return curNode;
            }
            curNode = curNode.getLeft();
        }
        return curNode;
    }

    protected class NaturalTreeIterator
    implements BiIterator {
        private BinarySearchTreeNode m_node;
        private boolean m_atEnd = false;
        private Object m_lastKey = null;

        public NaturalTreeIterator(BinarySearchTreeNode node) {
            this.m_node = node;
            if (this.m_node == null && !BinarySearchTree.this.isEmpty()) {
                this.m_node = BinarySearchTree.this.find(BinarySearchTree.this.getMax());
                this.m_atEnd = true;
            }
        }

        public boolean hasNext() {
            return !this.m_atEnd && this.m_node != null;
        }

        public boolean hasPrevious() {
            return this.m_node != null && (this.m_atEnd || this.m_node.getPrevious() != null);
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Comparable value = this.m_node.getKey();
            BinarySearchTreeNode nextNode = this.m_node.getNext();
            if (nextNode == null) {
                this.m_atEnd = true;
            } else {
                this.m_node = nextNode;
            }
            this.m_lastKey = value;
            return value;
        }

        public Object previous() throws NoSuchElementException {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            Comparable value = null;
            if (this.m_atEnd) {
                value = this.m_node.getKey();
                this.m_atEnd = false;
            } else {
                this.m_node = this.m_node.getPrevious();
                value = this.m_node.getKey();
            }
            this.m_lastKey = value;
            return value;
        }

        public void remove() throws IllegalStateException {
            if (this.m_lastKey == null) {
                throw new IllegalStateException();
            }
            BinarySearchTree.this.delete((Comparable)this.m_lastKey);
            this.m_node = BinarySearchTree.this.find((Comparable)this.m_lastKey);
            this.m_lastKey = null;
        }
    }

    protected class BreadthFirstTreeIterator
    implements Iterator {
        private LinkedList m_nodeQueue = new LinkedList();

        public BreadthFirstTreeIterator(BinarySearchTreeNode node) {
            if (node != null) {
                this.m_nodeQueue.addLast(node);
            }
        }

        public boolean hasNext() {
            return this.m_nodeQueue.size() > 0;
        }

        public Object next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BinarySearchTreeNode node = (BinarySearchTreeNode)this.m_nodeQueue.removeFirst();
            if (node.getLeft() != null) {
                this.m_nodeQueue.addLast(node.getLeft());
            }
            if (node.getRight() != null) {
                this.m_nodeQueue.addLast(node.getRight());
            }
            return node.getKey();
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }
    }
}

