/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.util;

import ca.nanometrics.util.BigEndian;
import ca.nanometrics.util.EndianReader;

public class BigEndianReader
implements EndianReader {
    private byte[] buffer;
    private int offset;

    public BigEndianReader(byte[] aBuffer, int anOffset) {
        this.buffer = aBuffer;
        this.offset = anOffset;
    }

    public BigEndianReader(byte[] aBuffer) {
        this(aBuffer, 0);
    }

    public void setOffset(int newOffset) {
        this.offset = newOffset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int read(byte[] barray, int start, int bytesToRead) {
        System.arraycopy(this.buffer, this.offset, barray, start, bytesToRead);
        this.offset += bytesToRead;
        return bytesToRead;
    }

    public int read(byte[] barray) {
        return this.read(barray, 0, barray.length);
    }

    public int readInt() {
        int val = BigEndian.readInt(this.buffer, this.offset);
        this.offset += 4;
        return val;
    }

    public long readUInt() {
        long val = BigEndian.readUInt(this.buffer, this.offset);
        this.offset += 4;
        return val;
    }

    public byte readByte() {
        byte val = this.buffer[this.offset];
        ++this.offset;
        return val;
    }

    public short readUByte() {
        return (short)(this.readByte() & 0xFF);
    }

    public short readShort() {
        short val = BigEndian.readShort(this.buffer, this.offset);
        this.offset += 2;
        return val;
    }

    public int readUShort() {
        int val = BigEndian.readUShort(this.buffer, this.offset);
        this.offset += 2;
        return val;
    }

    public long readLong() {
        long val = BigEndian.readLong(this.buffer, this.offset);
        this.offset += 8;
        return val;
    }

    public int readInt24() {
        int val = BigEndian.readInt24(this.buffer, this.offset);
        this.offset += 3;
        return val;
    }

    public float readFloat() {
        float val = BigEndian.readFloat(this.buffer, this.offset);
        this.offset += 4;
        return val;
    }

    public double readDouble() {
        double val = BigEndian.readDouble(this.buffer, this.offset);
        this.offset += 8;
        return val;
    }

    public String readString(int strlen) {
        String val = BigEndian.readString(this.buffer, this.offset, strlen);
        this.offset += strlen;
        return val;
    }
}

