/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet.test;

import ca.nanometrics.packet.PSCalibrationCommandPacket;
import ca.nanometrics.util.Log;
import ca.nanometrics.util.PrintLog;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class PSCalibrationCommandPacketTest
extends TestCase {
    int timeSecs;
    int instrumentID;
    byte channelBits;
    byte subtype;
    byte ctrlLines;
    byte attenuation;
    float amplitude;
    byte amplitudeUnit;
    float dcOffset;
    float duration;
    float tOn;
    float ramp;
    String identifier;
    float pulseWidth;
    PSCalibrationCommandPacket packet;
    static /* synthetic */ Class class$0;

    public PSCalibrationCommandPacketTest(String name) {
        super(name);
    }

    public static Test Suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("ca.nanometrics.packet.test.PSCalibrationCommandPacketTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void setUp() {
        PrintLog log = new PrintLog();
        Log.installLog(log);
        log.setVerbosity(0);
        this.timeSecs = 10;
        this.instrumentID = 5;
        this.channelBits = 1;
        this.subtype = (byte)2;
        this.amplitudeUnit = (byte)3;
        this.ctrlLines = (byte)4;
        this.attenuation = 1;
        this.amplitude = 2.0f;
        this.dcOffset = 1.0f;
        this.duration = 30.3f;
        this.tOn = 12.0f;
        this.ramp = 12.3f;
        this.identifier = "test";
        this.pulseWidth = 2.3f;
        this.packet = new PSCalibrationCommandPacket(this.timeSecs, this.instrumentID, this.channelBits, this.ctrlLines, this.attenuation, this.amplitudeUnit, this.amplitude, this.dcOffset, this.tOn, this.ramp, this.duration, this.identifier, this.pulseWidth);
    }

    public void testConstructor() throws Exception {
        Assert.assertNotNull((String)"null regular constructor", (Object)this.packet);
    }

    public void testGets() throws Exception {
        Assert.assertEquals((String)"getPulseWidth()", (double)this.pulseWidth, (double)this.packet.getPulseWidth(), (double)0.001);
    }

    public void testSets() throws Exception {
        this.pulseWidth = 0.4f;
        this.packet.setPulseWidth(this.pulseWidth);
        Assert.assertEquals((String)"setPulseWidth()", (double)this.pulseWidth, (double)this.packet.getPulseWidth(), (double)0.001);
    }

    public void testPackable() throws Exception {
        byte[] buffer = new byte[this.packet.getDataLength() + 2];
        this.packet.writeTo(buffer, 2);
        PSCalibrationCommandPacket packedPacket = new PSCalibrationCommandPacket(buffer, 2, buffer.length);
        Assert.assertEquals((String)"getPulseDuration()", (double)this.pulseWidth, (double)packedPacket.getPulseWidth(), (double)0.001);
    }
}

