/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.CalibrationCommandPacket;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class PSCalibrationCommandPacket
extends CalibrationCommandPacket {
    public static final byte SUB_TYPE = 2;
    private static final int NUM_PARAMS = 1;
    private static final int NUM_PARAMBYTES = 4;
    private static final int OFFSET_TO_PULSEDUR = 0;

    public PSCalibrationCommandPacket(int _timeSecs, int _instrumentID, byte _channelBits, byte _ctrlLines, byte _attenuation, byte _amplitudeUnit, float _amplitude, float _dcOffset, float _tOn, float _ramp, float _duration, String _identifier, float _pulseWidth) {
        super(_timeSecs, _instrumentID, _channelBits, (byte)2, _ctrlLines, _attenuation, _amplitudeUnit, _amplitude, _dcOffset, _tOn, _ramp, _duration, _identifier, 4);
        this.setPulseWidth(_pulseWidth);
    }

    public PSCalibrationCommandPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    public float getPulseWidth() {
        float pulseDur = LittleEndian.readFloat(this.paramBytes, 0);
        return pulseDur;
    }

    public void setPulseWidth(float newPulseDur) {
        LittleEndian.writeFloat(this.paramBytes, 0, newPulseDur);
    }

    public void readFrom(byte[] buffer, int offset, int length) throws InvalidInputException {
        super.readFrom(buffer, offset, length);
        this.setNumParamBytes(4);
    }

    public String toString() {
        return "PSCalibrationCommand for instrument " + this.getInstrumentID();
    }
}

