/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.HrdCommandPacket;
import ca.nanometrics.util.Format;
import ca.nanometrics.util.InvalidInputException;
import ca.nanometrics.util.LittleEndian;

public class HrdCalPacket
extends HrdCommandPacket {
    static final int CMD_TYPE = 6;
    static final int CHANNEL_POSITION = 7;
    static final int STARTTIME_POSITION = 10;
    static final int FREQUENCY_POSITION = 14;
    static final int AMPLITUDE_POSITION = 18;
    static final int DURATION_POSITION = 22;
    static final int DIGLINES_POSITION = 24;
    static final int CALTYPE_POSITION = 25;

    public HrdCalPacket(int timeSecs, int instrumentID, int channelBits, int startTime, float frequencyHz, float amplitudeValue, int durationSecs, int digitalBits, int calType) {
        super(timeSecs, instrumentID, 6);
        this.packet[7] = (byte)channelBits;
        LittleEndian.writeInt(this.packet, 10, startTime);
        LittleEndian.writeFloat(this.packet, 14, frequencyHz);
        LittleEndian.writeFloat(this.packet, 18, amplitudeValue);
        LittleEndian.writeShort(this.packet, 22, (short)durationSecs);
        this.packet[25] = (byte)calType;
        this.packet[24] = (byte)digitalBits;
    }

    public HrdCalPacket(byte[] buffer, int offset, int length) throws InvalidInputException {
        super(buffer, offset, length);
    }

    public int getChannelBits() {
        return this.packet[7];
    }

    public int getStartTime() {
        return LittleEndian.readInt(this.packet, 10);
    }

    public float getFrequency() {
        return LittleEndian.readFloat(this.packet, 14);
    }

    public float getAmplitude() {
        return LittleEndian.readFloat(this.packet, 18);
    }

    public int getDuration() {
        return LittleEndian.readShort(this.packet, 22);
    }

    public String getCalTypeString() {
        int type = this.getCalType();
        if (type == 1) {
            return "Trident(V)";
        }
        if (type == 2) {
            return "Trident(A)";
        }
        return "HRD(V)";
    }

    public int getDigitalBits() {
        return this.packet[24];
    }

    public int getCalType() {
        return this.packet[25];
    }

    public String toString() {
        Format cfmt = new Format("%2.2x");
        Format rfmt = new Format("%.3f");
        Format afmt = new Format("%.8f");
        return "HrdCalPacket " + this.getInstrumentName() + " " + this.getCalTypeString() + " CE:" + cfmt.form(this.getChannelBits()) + " DE:" + cfmt.form(this.getDigitalBits()) + " Start:" + this.getStartTime() % 86400 + " Dur:" + this.getDuration() + " Freq:" + rfmt.form(this.getFrequency()) + " Amp:" + afmt.form(this.getAmplitude());
    }
}

