/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.DataPacket;
import ca.nanometrics.packet.NmxPacketHandler;
import ca.nanometrics.packet.SampleRateTable;
import ca.nanometrics.util.LittleEndian;
import ca.nanometrics.util.Runner;

public class DataGenerator
extends Runner {
    static final int NUM_POINTS = 35;
    static final int NMX_PACKET_TYPE = 1;
    static final int BYTE_PACKING = 85;
    static final int SHORT_PACKING = 170;
    static final int BUNDLE_SIZE = 17;
    private NmxPacketHandler sender;
    private int oldestSequence = 0;
    private int sequenceNumber = 0;
    private int instrumentID;
    private int channel;
    private int sampleRate;
    private int bundlesPerPacket;
    private int packetLength;
    private byte channelByte;
    private boolean useByteDiffs = true;
    private long packetTime;
    private int index = 0;
    private byte[] values;
    private byte[] diffs;

    public DataGenerator(int _instrumentID, int _channel, int _sampleRate, int _bundlesPerPacket, NmxPacketHandler _sender) {
        super("DataGenerator" + _instrumentID + "-" + _channel);
        this.sender = _sender;
        this.instrumentID = _instrumentID;
        this.channel = _channel;
        this.sampleRate = _sampleRate;
        this.bundlesPerPacket = _bundlesPerPacket;
        this.packetLength = 17 * (1 + this.bundlesPerPacket);
        int sampleIndex = SampleRateTable.getIndex(this.sampleRate);
        this.channelByte = (byte)(sampleIndex << 3 | this.channel);
        this.initValues();
    }

    private void initValues() {
        this.values = new byte[35];
        this.diffs = new byte[35];
        double delta = 0.17951958020513104;
        int ix = 0;
        while (ix < 35) {
            this.values[ix] = (byte)(100.5 * Math.sin((double)ix * delta));
            ++ix;
        }
        ix = 0;
        while (ix < 35) {
            this.diffs[ix] = (byte)(this.values[(ix + 1) % 35] - this.values[ix]);
            ++ix;
        }
    }

    private void buildPacket(byte[] buffer) {
        int scaleFactor = 1;
        int samplesPerBundle = 16;
        if (!this.useByteDiffs) {
            scaleFactor = 20;
            samplesPerBundle = 8;
        }
        int timeSeconds = (int)(this.packetTime / 1000L);
        short timeFraction = (short)(10L * this.packetTime % 10000L);
        buffer[0] = 1;
        LittleEndian.writeInt(buffer, 1, timeSeconds);
        LittleEndian.writeShort(buffer, 5, timeFraction);
        LittleEndian.writeShort(buffer, 7, (short)this.instrumentID);
        LittleEndian.writeInt(buffer, 9, this.sequenceNumber);
        buffer[13] = this.channelByte;
        LittleEndian.writeInt24(buffer, 14, scaleFactor * this.values[this.index]);
        int bundle = 1;
        while (bundle <= this.bundlesPerPacket) {
            int ix;
            int offset = bundle * 17;
            if (this.useByteDiffs) {
                buffer[offset] = 85;
                ++offset;
                ix = 0;
                while (ix < samplesPerBundle) {
                    buffer[offset + ix] = this.diffs[this.index];
                    this.index = (this.index + 1) % 35;
                    ++ix;
                }
            } else {
                buffer[offset] = -86;
                ++offset;
                ix = 0;
                while (ix < samplesPerBundle) {
                    LittleEndian.writeShort(buffer, offset + 2 * ix, (short)(scaleFactor * this.diffs[this.index]));
                    this.index = (this.index + 1) % 35;
                    ++ix;
                }
            }
            ++bundle;
        }
        ++this.sequenceNumber;
        if (this.oldestSequence < this.sequenceNumber - 25) {
            this.oldestSequence += 5;
        }
        this.packetTime += (long)(1000 * this.bundlesPerPacket * samplesPerBundle / this.sampleRate);
        if (this.index == 0) {
            this.useByteDiffs = !this.useByteDiffs;
        }
    }

    private void sendPacket(byte[] buffer) {
        try {
            this.sender.put(new DataPacket(buffer, this.oldestSequence));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void run() {
        this.packetTime = System.currentTimeMillis();
        while (this.stayAlive) {
            try {
                byte[] buffer = new byte[this.packetLength];
                this.buildPacket(buffer);
                while (this.packetTime > System.currentTimeMillis()) {
                    Thread.sleep(50L);
                }
                this.sendPacket(buffer);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

