/*
 * Decompiled with CFR 0.152.
 */
package ca.nanometrics.packet;

import ca.nanometrics.packet.Packet;
import ca.nanometrics.util.BigEndian;

public class CalibrationResponse
extends Packet {
    public static final int MSG_TYPE = 195;
    private float calib;
    private float calper;
    private String channel;
    private String instrument;
    private String response;
    private String recordID;

    public CalibrationResponse(float _calib, float _calper, String _channel, String _instrument, String _response, String _recordID) {
        this.calib = _calib;
        this.calper = _calper;
        this.channel = _channel;
        this.instrument = _instrument;
        this.response = _response;
        this.recordID = _recordID;
    }

    public CalibrationResponse(byte[] buffer, int offset, int length) {
        this.readFrom(buffer, offset, length);
    }

    public int getDataType() {
        return 195;
    }

    public int getDataLength() {
        return 8 + this.channel.length() + 1 + this.instrument.length() + 1 + this.response.length() + 1 + this.recordID.length() + 1;
    }

    public void writeTo(byte[] buffer, int offset) throws IllegalArgumentException {
        if (buffer.length < this.getDataLength()) {
            throw new IllegalArgumentException("writeTo: buffer too small");
        }
        BigEndian.writeFloat(buffer, offset, this.calib);
        BigEndian.writeFloat(buffer, offset += 4, this.calper);
        BigEndian.writeString(buffer, offset += 4, this.channel, this.channel.length() + 1);
        BigEndian.writeString(buffer, offset += this.channel.length() + 1, this.instrument, this.instrument.length() + 1);
        BigEndian.writeString(buffer, offset += this.instrument.length() + 1, this.response, this.response.length() + 1);
        BigEndian.writeString(buffer, offset += this.response.length() + 1, this.recordID, this.recordID.length() + 1);
        offset += this.response.length() + 1;
    }

    public void readFrom(byte[] buffer, int offset, int length) throws IllegalArgumentException {
        if (buffer.length - offset < 8) {
            throw new IllegalArgumentException("readFrom: insufficient data.");
        }
        this.calib = BigEndian.readFloat(buffer, offset);
        this.calper = BigEndian.readFloat(buffer, offset += 4);
        this.channel = BigEndian.readString(buffer, offset += 4, length);
        this.instrument = BigEndian.readString(buffer, offset += this.channel.length() + 1, length);
        this.response = BigEndian.readString(buffer, offset += this.instrument.length() + 1, length);
        this.recordID = BigEndian.readString(buffer, offset += this.response.length() + 1, length);
    }

    public float getCalib() {
        return this.calib;
    }

    public float getCalper() {
        return this.calper;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public String getResponse() {
        return this.response;
    }

    public String getRecordID() {
        return this.recordID;
    }

    public String toString() {
        String s = "CalResp: " + this.instrument + "." + this.channel + " calib:" + this.calib + " calper:" + this.calper + " recordID " + this.recordID;
        return s;
    }
}

