/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.CategoryGraph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.swing.JCategoryGraph2D;
import java.awt.Color;
import java.awt.Graphics;

public class JPieChart
extends JCategoryGraph2D {
    private float pieTotal;
    protected Color[] sliceColor = new Color[]{Color.blue, Color.green, Color.red, Color.yellow, Color.cyan, Color.lightGray, Color.magenta, Color.orange, Color.pink};

    public JPieChart(CategoryGraph2DModel categoryGraph2DModel) {
        super(categoryGraph2DModel);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        this.model.firstSeries();
        int n = this.model.seriesLength();
        this.pieTotal = 0.0f;
        for (int i = 0; i < n; ++i) {
            this.pieTotal += this.model.getValue(i);
        }
        if (n > this.sliceColor.length) {
            Color[] colorArray = this.sliceColor;
            this.sliceColor = new Color[n];
            System.arraycopy(colorArray, 0, this.sliceColor, 0, colorArray.length);
            for (int i = colorArray.length; i < this.sliceColor.length; ++i) {
                this.sliceColor[i] = this.sliceColor[i - colorArray.length];
            }
        }
        this.rescale();
    }

    public final void setColor(int n, Color color) {
        this.sliceColor[n] = color;
    }

    public final Color getColor(int n) {
        return this.sliceColor[n];
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    protected final void rescale() {
        this.origin.x = this.getWidth() / 2;
        this.origin.y = this.getHeight() / 2;
        this.redraw();
    }

    protected void offscreenPaint(Graphics graphics) {
        int n;
        int n2 = 2 * (this.origin.x - 25);
        int n3 = 2 * (this.origin.y - 25);
        double d = 0.4 * (double)n2;
        double d2 = 0.4 * (double)n3;
        int n4 = 0;
        this.model.firstSeries();
        int n5 = this.model.seriesLength();
        if (n5 > 0) {
            for (n = 0; n < n5 - 1; ++n) {
                graphics.setColor(this.sliceColor[n]);
                int n6 = Math.round(this.model.getValue(n) * 360.0f / this.pieTotal);
                graphics.fillArc(25, 25, n2, n3, n4, n6);
                n4 += n6;
            }
            graphics.setColor(this.sliceColor[n5 - 1]);
            graphics.fillArc(25, 25, n2, n3, n4, 360 - n4);
        }
        graphics.setColor(this.getForeground());
        graphics.drawArc(25, 25, n2, n3, 0, 360);
        n = graphics.getFontMetrics().getHeight() / 2;
        double d3 = 0.0;
        graphics.setColor(this.getForeground());
        for (int i = 0; i < n5; ++i) {
            double d4 = (double)this.model.getValue(i) * Math.PI / (double)this.pieTotal;
            String string = this.model.getCategory(i);
            int n7 = graphics.getFontMetrics().stringWidth(string) / 2;
            graphics.drawString(string, this.origin.x - n7 + (int)(d * Math.cos(d3 += d4)), this.origin.y + n - (int)(d2 * Math.sin(d3)));
            d3 += d4;
        }
    }
}

