/*
 * Decompiled with CFR 0.152.
 */
package JSci.swing;

import JSci.awt.Graph2D;
import JSci.awt.Graph2DModel;
import JSci.awt.GraphDataEvent;
import JSci.awt.GraphDataListener;
import JSci.maths.ExtraMath;
import JSci.swing.JDoubleBufferedComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public abstract class JGraph2D
extends JDoubleBufferedComponent
implements GraphDataListener {
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    protected Graph2DModel model;
    protected Point origin = new Point();
    protected Graph2D.DataMarker dataMarker = Graph2D.DataMarker.NONE;
    protected Color[] seriesColor = new Color[]{Color.black, Color.blue, Color.green, Color.red, Color.yellow, Color.cyan, Color.lightGray, Color.magenta, Color.orange, Color.pink};
    protected boolean xNumbering = true;
    protected boolean yNumbering = true;
    protected NumberFormat xNumberFormat = new DecimalFormat("##0.0");
    protected NumberFormat yNumberFormat = new DecimalFormat("##0.0");
    protected boolean xAxisLine = true;
    protected boolean yAxisLine = true;
    protected boolean gridLines = false;
    private final Color gridLineColor = Color.lightGray;
    private float xScale;
    private float yScale;
    private int xScaleType;
    private int yScaleType;
    private float minX;
    private float minY;
    private float maxX;
    private float maxY;
    private float scaledMinX;
    private float scaledMinY;
    private float scaledMaxX;
    private float scaledMaxY;
    private boolean autoXExtrema = true;
    private boolean autoYExtrema = true;
    private float xGrowth;
    private float yGrowth;
    private final float xIncPixels = 40.0f;
    private final float yIncPixels = 40.0f;
    private float xInc;
    private float yInc;
    private boolean autoXInc = true;
    private boolean autoYInc = true;
    protected final int scalePad = 5;
    protected final int axisPad = 25;
    protected int leftAxisPad;

    public JGraph2D(Graph2DModel graph2DModel) {
        this.model = graph2DModel;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final void setModel(Graph2DModel graph2DModel) {
        this.model.removeGraphDataListener(this);
        this.model = graph2DModel;
        this.model.addGraphDataListener(this);
        this.dataChanged(new GraphDataEvent(this.model));
    }

    public final Graph2DModel getModel() {
        return this.model;
    }

    public void dataChanged(GraphDataEvent graphDataEvent) {
        if (graphDataEvent.isIncremental()) {
            Graphics graphics = this.getOffscreenGraphics();
            if (graphics == null) {
                return;
            }
            int n = graphDataEvent.getSeries();
            if (n == -1) {
                this.model.firstSeries();
                int n2 = 0;
                do {
                    int n3 = this.model.seriesLength() - 1;
                    this.incrementalRescale(this.model.getXCoord(n3), this.model.getYCoord(n3));
                    graphics.setColor(this.seriesColor[n2]);
                    this.drawDataPoint(graphics, n3);
                    ++n2;
                } while (this.model.nextSeries());
            } else {
                int n4;
                this.model.firstSeries();
                for (n4 = 0; n4 < n; ++n4) {
                    this.model.nextSeries();
                }
                int n5 = this.model.seriesLength() - 1;
                this.incrementalRescale(this.model.getXCoord(n5), this.model.getYCoord(n5));
                graphics.setColor(this.seriesColor[n4]);
                this.drawDataPoint(graphics, n5);
            }
            this.repaint();
        } else {
            int n = 1;
            this.model.firstSeries();
            while (this.model.nextSeries()) {
                ++n;
            }
            if (n > this.seriesColor.length) {
                Color[] colorArray = this.seriesColor;
                this.seriesColor = new Color[n];
                System.arraycopy(colorArray, 0, this.seriesColor, 0, colorArray.length);
                for (int i = colorArray.length; i < n; ++i) {
                    this.seriesColor[i] = this.seriesColor[i - colorArray.length];
                }
            }
            if (this.autoXExtrema) {
                this.setXExtrema(0.0f, 0.0f);
            }
            if (this.autoYExtrema) {
                this.setYExtrema(0.0f, 0.0f);
            }
            this.redraw();
        }
    }

    private void incrementalRescale(float f, float f2) {
        float f3 = f < this.minX ? (this.autoXExtrema ? Math.min(f, this.minX - this.xGrowth) : this.minX - this.xGrowth) : this.minX;
        float f4 = f > this.maxX ? (this.autoXExtrema ? Math.max(f, this.maxX + this.xGrowth) : this.maxX + this.xGrowth) : this.maxX;
        this.rescaleX(f3, f4);
        f3 = f2 < this.minY ? (this.autoYExtrema ? Math.min(f2, this.minY - this.yGrowth) : this.minY - this.yGrowth) : this.minY;
        f4 = f2 > this.maxY ? (this.autoYExtrema ? Math.max(f2, this.maxY + this.yGrowth) : this.maxY + this.yGrowth) : this.maxY;
        this.rescaleY(f3, f4);
    }

    public final void setNumbering(boolean bl) {
        this.setNumbering(bl, bl);
    }

    public final void setNumbering(boolean bl, boolean bl2) {
        this.xNumbering = bl;
        this.yNumbering = bl2;
        this.leftAxisPad = 25;
        if (this.yNumbering && this.getFont() != null) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = fontMetrics.stringWidth(this.yNumberFormat.format(this.maxY));
            int n2 = fontMetrics.stringWidth(this.yNumberFormat.format(this.minY));
            int n3 = Math.max(n2, n);
            if (this.scaledMinX < 0.0f) {
                int n4 = (int)((float)(Math.max(this.getSize().width, this.getMinimumSize().width) - 60) * this.scaledMinX / (this.scaledMinX - this.scaledMaxX));
                n3 = Math.max(n3 - n4, 0);
            }
            this.leftAxisPad += n3;
        }
        this.rescale();
    }

    public void addNotify() {
        super.addNotify();
        this.setNumbering(this.xNumbering, this.yNumbering);
    }

    public final void setNumberFormat(NumberFormat numberFormat) {
        this.xNumberFormat = numberFormat;
        this.yNumberFormat = numberFormat;
        this.setNumbering(this.xNumbering, this.yNumbering);
    }

    public final void setXNumberFormat(NumberFormat numberFormat) {
        this.xNumberFormat = numberFormat;
        this.setNumbering(this.xNumbering, this.yNumbering);
    }

    public final void setYNumberFormat(NumberFormat numberFormat) {
        this.yNumberFormat = numberFormat;
        this.setNumbering(this.xNumbering, this.yNumbering);
    }

    public final void setAxisLines(boolean bl, boolean bl2) {
        this.xAxisLine = bl;
        this.yAxisLine = bl2;
        this.redraw();
    }

    public final void setGridLines(boolean bl) {
        this.gridLines = bl;
        this.redraw();
    }

    public final void setXScale(int n) {
        if (this.xScaleType != n) {
            this.xScaleType = n;
            this.dataChanged(new GraphDataEvent(this.model));
        }
    }

    public final void setYScale(int n) {
        if (this.yScaleType != n) {
            this.yScaleType = n;
            this.dataChanged(new GraphDataEvent(this.model));
        }
    }

    public final void setXIncrement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        if (f == 0.0f) {
            if (!this.autoXInc) {
                this.autoXInc = true;
                this.rescale();
            }
        } else {
            this.autoXInc = false;
            if (f != this.xInc) {
                this.xInc = f;
                this.rescale();
            }
        }
    }

    public final float getXIncrement() {
        return this.xInc;
    }

    public final void setYIncrement(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Increment should be positive.");
        }
        if (f == 0.0f) {
            if (!this.autoYInc) {
                this.autoYInc = true;
                this.rescale();
            }
        } else {
            this.autoYInc = false;
            if (f != this.yInc) {
                this.yInc = f;
                this.rescale();
            }
        }
    }

    public final float getYIncrement() {
        return this.yInc;
    }

    public final void setXExtrema(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            this.autoXExtrema = true;
            f = Float.POSITIVE_INFINITY;
            f2 = Float.NEGATIVE_INFINITY;
            this.model.firstSeries();
            do {
                for (int i = 0; i < this.model.seriesLength(); ++i) {
                    float f3 = this.model.getXCoord(i);
                    if (Float.isNaN(f3)) continue;
                    f = Math.min(f3, f);
                    f2 = Math.max(f3, f2);
                }
            } while (this.model.nextSeries());
            if (f == f2) {
                if (this.yScaleType == 1) {
                    f /= 10.0f;
                    f2 *= 10.0f;
                } else {
                    f -= 0.5f;
                    f2 += 0.5f;
                }
            }
            if (f == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
                if (this.xScaleType == 1) {
                    f = 1.0f;
                    f2 = 100.0f;
                } else {
                    f = -5.0f;
                    f2 = 5.0f;
                }
            }
        } else {
            if (f2 <= f) {
                throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + f2 + " and min = " + f);
            }
            this.autoXExtrema = false;
        }
        this.rescaleX(f, f2);
    }

    public final void setXExtrema(float f, float f2, float f3) {
        this.setXExtrema(f, f2);
        this.xGrowth = f3;
    }

    public final float getXMinimum() {
        return this.minX;
    }

    public final float getXMaximum() {
        return this.maxX;
    }

    private void rescaleX(float f, float f2) {
        if (f != this.minX || f2 != this.maxX) {
            this.minX = f;
            this.maxX = f2;
            if (this.xScaleType == 1) {
                this.scaledMinX = (float)Math.log(this.minX);
                this.scaledMaxX = (float)Math.log(this.maxX);
            } else {
                this.scaledMinX = this.minX;
                this.scaledMaxX = this.maxX;
            }
            this.setNumbering(this.xNumbering, this.yNumbering);
        }
    }

    public final void setYExtrema(float f, float f2) {
        if (f == 0.0f && f2 == 0.0f) {
            this.autoYExtrema = true;
            f = Float.POSITIVE_INFINITY;
            f2 = Float.NEGATIVE_INFINITY;
            this.model.firstSeries();
            do {
                for (int i = 0; i < this.model.seriesLength(); ++i) {
                    float f3 = this.model.getYCoord(i);
                    if (Float.isNaN(f3)) continue;
                    f = Math.min(f3, f);
                    f2 = Math.max(f3, f2);
                }
            } while (this.model.nextSeries());
            if (f == f2) {
                if (this.yScaleType == 1) {
                    f /= 10.0f;
                    f2 *= 10.0f;
                } else {
                    f -= 0.5f;
                    f2 += 0.5f;
                }
            }
            if (f == Float.POSITIVE_INFINITY || f2 == Float.NEGATIVE_INFINITY) {
                if (this.yScaleType == 1) {
                    f = 1.0f;
                    f2 = 100.0f;
                } else {
                    f = -5.0f;
                    f2 = 5.0f;
                }
            }
        } else {
            if (f2 <= f) {
                throw new IllegalArgumentException("Maximum should be greater than minimum; max = " + f2 + " and min = " + f);
            }
            this.autoYExtrema = false;
        }
        this.rescaleY(f, f2);
    }

    public final void setYExtrema(float f, float f2, float f3) {
        this.setYExtrema(f, f2);
        this.yGrowth = f3;
    }

    public final float getYMinimum() {
        return this.minY;
    }

    public final float getYMaximum() {
        return this.maxY;
    }

    private void rescaleY(float f, float f2) {
        if (f != this.minY || f2 != this.maxY) {
            this.minY = f;
            this.maxY = f2;
            if (this.yScaleType == 1) {
                this.scaledMinY = (float)Math.log(this.minY);
                this.scaledMaxY = (float)Math.log(this.maxY);
            } else {
                this.scaledMinY = this.minY;
                this.scaledMaxY = this.maxY;
            }
            this.setNumbering(this.xNumbering, this.yNumbering);
        }
    }

    public final Rectangle2D.Float getExtrema() {
        return new Rectangle2D.Float(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public final void setMarker(Graph2D.DataMarker dataMarker) {
        this.dataMarker = dataMarker;
        this.redraw();
    }

    public final void setColor(int n, Color color) {
        this.seriesColor[n] = color;
        this.redraw();
    }

    public final Color getColor(int n) {
        return this.seriesColor[n];
    }

    public final void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.rescale();
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        return new Dimension(170, 170);
    }

    protected final void rescale() {
        Dimension dimension = this.getMinimumSize();
        int n = Math.max(this.getWidth(), dimension.width);
        int n2 = Math.max(this.getHeight(), dimension.height);
        this.xScale = (float)((double)(n - (this.leftAxisPad + 25)) / (double)(this.scaledMaxX - this.scaledMinX));
        this.yScale = (float)((double)(n2 - 50) / (double)(this.scaledMaxY - this.scaledMinY));
        if (this.autoXInc) {
            this.xInc = (float)ExtraMath.round(40.0 / (double)this.xScale, 1);
            if (this.xInc == 0.0f) {
                this.xInc = Float.MIN_VALUE;
            }
        }
        if (this.autoYInc) {
            this.yInc = (float)ExtraMath.round(40.0 / (double)this.yScale, 1);
            if (this.yInc == 0.0f) {
                this.yInc = Float.MIN_VALUE;
            }
        }
        this.origin.x = this.leftAxisPad - Math.round(this.scaledMinX * this.xScale);
        this.origin.y = n2 - 25 + Math.round(this.scaledMinY * this.yScale);
        this.redraw();
    }

    protected final Point dataToScreen(float f, float f2) {
        if (this.xScaleType == 1) {
            f = (float)Math.log(f);
        }
        if (this.yScaleType == 1) {
            f2 = (float)Math.log(f2);
        }
        return this.scaledDataToScreen(f, f2);
    }

    protected final Point scaledDataToScreen(float f, float f2) {
        return new Point(this.origin.x + Math.round(this.xScale * f), this.origin.y - Math.round(this.yScale * f2));
    }

    protected final Point2D.Float screenToData(Point point) {
        double d = (double)(point.x - this.origin.x) / (double)this.xScale;
        double d2 = (double)(this.origin.y - point.y) / (double)this.yScale;
        if (this.xScaleType == 1) {
            d = Math.exp(d);
        }
        if (this.yScaleType == 1) {
            d2 = Math.exp(d2);
        }
        return new Point2D.Float((float)d, (float)d2);
    }

    protected final void drawAxes(Graphics graphics) {
        Point point;
        double d;
        float f;
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setColor(this.getForeground());
        if (this.gridLines || this.xNumbering) {
            f = this.scaledMinY > 0.0f ? this.scaledMinY : (this.scaledMaxY < 0.0f ? this.scaledMaxY : 0.0f);
            double d2 = d = this.scaledMinX > 0.0f ? (double)this.scaledMinX : (double)this.xInc;
            while (d <= (double)this.scaledMaxX) {
                point = this.scaledDataToScreen((float)d, f);
                if (this.gridLines) {
                    graphics.setColor(this.gridLineColor);
                    graphics.drawLine(point.x, 20, point.x, n2 - 20);
                    graphics.setColor(this.getForeground());
                }
                if (this.xNumbering) {
                    this.drawXLabel(graphics, d, point);
                }
                d += (double)this.xInc;
            }
            for (d = (double)(-this.xInc); d >= (double)this.scaledMinX; d -= (double)this.xInc) {
                point = this.scaledDataToScreen((float)d, f);
                if (this.gridLines) {
                    graphics.setColor(this.gridLineColor);
                    graphics.drawLine(point.x, 20, point.x, n2 - 20);
                    graphics.setColor(this.getForeground());
                }
                if (!this.xNumbering) continue;
                this.drawXLabel(graphics, d, point);
            }
        }
        if (this.gridLines || this.yNumbering) {
            f = this.scaledMinX > 0.0f ? this.scaledMinX : (this.scaledMaxX < 0.0f ? this.scaledMaxX : 0.0f);
            double d3 = d = this.scaledMinY > 0.0f ? (double)this.scaledMinY : (double)this.yInc;
            while (d <= (double)this.scaledMaxY) {
                point = this.scaledDataToScreen(f, (float)d);
                if (this.gridLines) {
                    graphics.setColor(this.gridLineColor);
                    graphics.drawLine(this.leftAxisPad - 5, point.y, n - 20, point.y);
                    graphics.setColor(this.getForeground());
                }
                if (this.yNumbering) {
                    this.drawYLabel(graphics, d, point);
                }
                d += (double)this.yInc;
            }
            for (d = (double)(-this.yInc); d >= (double)this.scaledMinY; d -= (double)this.yInc) {
                point = this.scaledDataToScreen(f, (float)d);
                if (this.gridLines) {
                    graphics.setColor(this.gridLineColor);
                    graphics.drawLine(this.leftAxisPad - 5, point.y, n - 20, point.y);
                    graphics.setColor(this.getForeground());
                }
                if (!this.yNumbering) continue;
                this.drawYLabel(graphics, d, point);
            }
        }
        if (this.xAxisLine) {
            if (this.scaledMinY > 0.0f) {
                graphics.drawLine(this.leftAxisPad - 5, n2 - 25, n - 20, n2 - 25);
            } else if (this.scaledMaxY < 0.0f) {
                graphics.drawLine(this.leftAxisPad - 5, 25, n - 20, 25);
            } else {
                graphics.drawLine(this.leftAxisPad - 5, this.origin.y, n - 20, this.origin.y);
            }
        }
        if (this.yAxisLine) {
            if (this.scaledMinX > 0.0f) {
                graphics.drawLine(this.leftAxisPad, 20, this.leftAxisPad, n2 - 20);
            } else if (this.scaledMaxX < 0.0f) {
                graphics.drawLine(n - 25, 20, n - 25, n2 - 20);
            } else {
                graphics.drawLine(this.origin.x, 20, this.origin.x, n2 - 20);
            }
        }
    }

    protected void drawXLabel(Graphics graphics, double d, Point point) {
        double d2 = this.xScaleType == 1 ? Math.exp(d) : d;
        String string = this.xNumberFormat.format(d2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawLine(point.x, point.y, point.x, point.y + 5);
        graphics.drawString(string, point.x - n / 2, point.y + 5 + n2);
    }

    protected void drawYLabel(Graphics graphics, double d, Point point) {
        double d2 = this.yScaleType == 1 ? Math.exp(d) : d;
        String string = this.yNumberFormat.format(d2);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getHeight();
        graphics.drawLine(point.x, point.y, point.x - 5, point.y);
        graphics.drawString(string, point.x - 8 - n, point.y + n2 / 3);
    }

    protected void drawData(Graphics graphics) {
        int n;
        this.model.firstSeries();
        graphics.setColor(this.seriesColor[0]);
        for (n = 0; n < this.model.seriesLength(); ++n) {
            this.drawDataPoint(graphics, n);
        }
        int n2 = 1;
        while (this.model.nextSeries()) {
            graphics.setColor(this.seriesColor[n2]);
            for (n = 0; n < this.model.seriesLength(); ++n) {
                this.drawDataPoint(graphics, n);
            }
            ++n2;
        }
    }

    private void drawDataPoint(Graphics graphics, int n) {
        Point point = this.dataToScreen(this.model.getXCoord(n), this.model.getYCoord(n));
        this.dataMarker.paint(graphics, point.x, point.y);
    }

    protected void offscreenPaint(Graphics graphics) {
        this.drawAxes(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        graphics.setClip(this.leftAxisPad - 5, 20, n - (this.leftAxisPad + 25 - 10), n2 - 40);
        this.drawData(graphics);
    }
}

